/*
 * Decompiled with CFR 0.152.
 */
package io.nuov.logging;

import io.nuov.logging.LoggingDependency;
import io.nuov.sentence.Nouns;
import io.nuov.sentence.Sentence;
import io.nuov.sentence.SingularNoun;
import io.nuov.sentence.Superlatives;
import io.nuov.validator.CollectionValidator;
import io.nuov.validator.Noun;
import io.nuov.validator.ObjectValidator;
import io.nuov.validator.StringValidator;
import java.util.Arrays;

public interface LoggingMethods
extends LoggingDependency {
    default public void logClassMethod(String methodName) {
        StringValidator.the((Noun)io.nuov.validator.Nouns.ARGUMENT, (String)"methodName", (String)methodName).validate();
        String canonicalClassName = this.getClass().getCanonicalName();
        String message = String.format("%s.%s", canonicalClassName, methodName);
        this.getLogger().debug(message);
    }

    default public void logClassMethod(String methodName, Object ... arguments) {
        StringValidator.the((Noun)io.nuov.validator.Nouns.ARGUMENT, (String)"methodName", (String)methodName).validate();
        ObjectValidator.the((Noun)io.nuov.validator.Nouns.ARGUMENT, (String)"arguments", (Object)arguments).validate();
        CollectionValidator.the((Noun)io.nuov.validator.Nouns.ARGUMENT, (String)"arguments", Arrays.asList(arguments)).validate();
        String method = String.format(methodName, arguments);
        if (method.compareTo(methodName) == 0) {
            throw new IllegalArgumentException(Sentence.the((SingularNoun)Nouns.ARGUMENT, (String)"methodName", (Object)methodName).isNot(Superlatives.VALID).period());
        }
        String canonicalClassName = this.getClass().getCanonicalName();
        String message = String.format("%s.%s", canonicalClassName, method);
        this.getLogger().debug(message);
    }

    default public void logInterfaceMethod(Class<?> interfaceClass, String methodName) {
        ObjectValidator.the((Noun)io.nuov.validator.Nouns.ARGUMENT, (String)"interfaceClass", interfaceClass).validate();
        StringValidator.the((Noun)io.nuov.validator.Nouns.ARGUMENT, (String)"methodName", (String)methodName).validate();
        String canonicalInterfaceName = interfaceClass.getCanonicalName();
        String canonicalClassName = this.getClass().getCanonicalName();
        String message = String.format("((%s) %s).%s", canonicalInterfaceName, canonicalClassName, methodName);
        this.getLogger().debug(message);
    }

    default public void logInterfaceMethod(Class<?> interfaceClass, String methodName, Object ... arguments) {
        ObjectValidator.the((Noun)io.nuov.validator.Nouns.ARGUMENT, (String)"interfaceClass", interfaceClass).validate();
        StringValidator.the((Noun)io.nuov.validator.Nouns.ARGUMENT, (String)"methodName", (String)methodName).validate();
        CollectionValidator.the((Noun)io.nuov.validator.Nouns.ARGUMENT, (String)"arguments", Arrays.asList(arguments)).validate();
        String method = String.format(methodName, arguments);
        if (method.compareTo(methodName) == 0) {
            throw new IllegalArgumentException(Sentence.the((SingularNoun)Nouns.ARGUMENT, (String)"methodName", (Object)methodName).isNot(Superlatives.VALID).period());
        }
        String canonicalInterfaceName = interfaceClass.getCanonicalName();
        String canonicalClassName = this.getClass().getCanonicalName();
        String message = String.format("((%s) %s).%s", canonicalInterfaceName, canonicalClassName, method);
        this.getLogger().debug(message);
    }
}

