/*
 * Decompiled with CFR 0.152.
 */
package io.nuov.cast;

import io.nuov.cast.PrecisionStatement;
import io.nuov.sentence.Nouns;
import io.nuov.sentence.SingularNoun;
import io.nuov.sentence.Superlative;
import io.nuov.sentence.Superlatives;
import io.nuov.validator.Noun;
import io.nuov.validator.ObjectValidator;
import io.nuov.validator.StringValidator;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class PrecisionCast {
    static BigDecimal getBigDecimal(SingularNoun noun, String name, Superlative superlative, String value) {
        ObjectValidator.the((Noun)io.nuov.validator.Nouns.ARGUMENT, (String)"noun", (Object)noun).validate();
        StringValidator.the((Noun)io.nuov.validator.Nouns.ARGUMENT, (String)"name", (String)name).validate();
        ObjectValidator.the((Noun)io.nuov.validator.Nouns.ARGUMENT, (String)"superlative", (Object)superlative).validate();
        if (value == null) {
            return null;
        }
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException ignored) {
            String statement = PrecisionStatement.the(noun, name, value).canNotBeCastTo(superlative).period();
            throw noun.equals(Nouns.ARGUMENT) ? new IllegalArgumentException(statement) : new IllegalStateException(statement);
        }
    }

    public static Byte getByte(SingularNoun noun, String name, Double value) {
        return value != null ? PrecisionCast.getByte(noun, name, value.toString()) : null;
    }

    public static Byte getByte(SingularNoun noun, String name, Float value) {
        return value != null ? PrecisionCast.getByte(noun, name, value.toString()) : null;
    }

    public static Byte getByte(SingularNoun noun, String name, Integer value) {
        return value != null ? PrecisionCast.getByte(noun, name, value.toString()) : null;
    }

    public static Byte getByte(SingularNoun noun, String name, Long value) {
        return value != null ? PrecisionCast.getByte(noun, name, value.toString()) : null;
    }

    public static Byte getByte(SingularNoun noun, String name, Short value) {
        return value != null ? PrecisionCast.getByte(noun, name, value.toString()) : null;
    }

    public static Byte getByte(SingularNoun noun, String name, String value) {
        byte byteValue;
        Superlative superlative = Superlatives.A_BYTE;
        BigDecimal bigDecimal = PrecisionCast.getBigDecimal(noun, name, superlative, value);
        if (bigDecimal == null) {
            return null;
        }
        try {
            byteValue = bigDecimal.byteValueExact();
        }
        catch (ArithmeticException ignored) {
            String statement = PrecisionStatement.the(noun, name, value).canNotBeCastTo(superlative).period();
            throw noun.equals(Nouns.ARGUMENT) ? new IllegalArgumentException(statement) : new IllegalStateException(statement);
        }
        PrecisionCast.validate(noun, name, superlative, value, Byte.toString(byteValue));
        return byteValue;
    }

    public static Double getDouble(SingularNoun noun, String name, Byte value) {
        return value != null ? PrecisionCast.getDouble(noun, name, value.toString()) : null;
    }

    public static Double getDouble(SingularNoun noun, String name, Float value) {
        return value != null ? PrecisionCast.getDouble(noun, name, value.toString()) : null;
    }

    public static Double getDouble(SingularNoun noun, String name, Integer value) {
        return value != null ? PrecisionCast.getDouble(noun, name, value.toString()) : null;
    }

    static Double getDouble(SingularNoun noun, String name, Long value) {
        return value != null ? PrecisionCast.getDouble(noun, name, value.toString()) : null;
    }

    public static Double getDouble(SingularNoun noun, String name, Short value) {
        return value != null ? PrecisionCast.getDouble(noun, name, value.toString()) : null;
    }

    public static Double getDouble(SingularNoun noun, String name, String value) {
        double doubleValue;
        Superlative superlative = Superlatives.A_DOUBLE;
        BigDecimal bigDecimal = PrecisionCast.getBigDecimal(noun, name, superlative, value);
        if (bigDecimal == null) {
            return null;
        }
        try {
            doubleValue = bigDecimal.doubleValue();
        }
        catch (ArithmeticException ignored) {
            String statement = PrecisionStatement.the(noun, name, value).canNotBeCastTo(superlative).period();
            throw noun.equals(Nouns.ARGUMENT) ? new IllegalArgumentException(statement) : new IllegalStateException(statement);
        }
        PrecisionCast.validate(noun, name, superlative, value, Double.toString(doubleValue));
        return doubleValue;
    }

    public static Float getFloat(SingularNoun noun, String name, Byte value) {
        return value != null ? PrecisionCast.getFloat(noun, name, value.toString()) : null;
    }

    public static Float getFloat(SingularNoun noun, String name, Double value) {
        return value != null ? PrecisionCast.getFloat(noun, name, value.toString()) : null;
    }

    public static Float getFloat(SingularNoun noun, String name, Integer value) {
        return value != null ? PrecisionCast.getFloat(noun, name, value.toString()) : null;
    }

    static Float getFloat(SingularNoun noun, String name, Long value) {
        return value != null ? PrecisionCast.getFloat(noun, name, value.toString()) : null;
    }

    public static Float getFloat(SingularNoun noun, String name, Short value) {
        return value != null ? PrecisionCast.getFloat(noun, name, value.toString()) : null;
    }

    public static Float getFloat(SingularNoun noun, String name, String value) {
        float floatValue;
        Superlative superlative = Superlatives.A_FLOAT;
        BigDecimal bigDecimal = PrecisionCast.getBigDecimal(noun, name, superlative, value);
        if (bigDecimal == null) {
            return null;
        }
        try {
            floatValue = bigDecimal.floatValue();
        }
        catch (ArithmeticException ignored) {
            String statement = PrecisionStatement.the(noun, name, value).canNotBeCastTo(superlative).period();
            throw noun.equals(Nouns.ARGUMENT) ? new IllegalArgumentException(statement) : new IllegalStateException(statement);
        }
        PrecisionCast.validate(noun, name, superlative, value, Float.toString(floatValue));
        return Float.valueOf(floatValue);
    }

    public static Integer getInteger(SingularNoun noun, String name, Double value) {
        return value != null ? PrecisionCast.getInteger(noun, name, value.toString()) : null;
    }

    public static Integer getInteger(SingularNoun noun, String name, Float value) {
        return value != null ? PrecisionCast.getInteger(noun, name, value.toString()) : null;
    }

    public static Integer getInteger(SingularNoun noun, String name, Long value) {
        return value != null ? PrecisionCast.getInteger(noun, name, value.toString()) : null;
    }

    public static Integer getInteger(SingularNoun noun, String name, String value) {
        int integerValue;
        Superlative superlative = Superlatives.AN_INTEGER;
        BigDecimal bigDecimal = PrecisionCast.getBigDecimal(noun, name, superlative, value);
        if (bigDecimal == null) {
            return null;
        }
        try {
            integerValue = bigDecimal.intValueExact();
        }
        catch (ArithmeticException ignored) {
            String statement = PrecisionStatement.the(noun, name, value).canNotBeCastTo(superlative).period();
            throw noun.equals(Nouns.ARGUMENT) ? new IllegalArgumentException(statement) : new IllegalStateException(statement);
        }
        PrecisionCast.validate(noun, name, superlative, value, Integer.toString(integerValue));
        return integerValue;
    }

    public static Long getLong(SingularNoun noun, String name, Double value) {
        return value != null ? PrecisionCast.getLong(noun, name, value.toString()) : null;
    }

    public static Long getLong(SingularNoun noun, String name, Float value) {
        return value != null ? PrecisionCast.getLong(noun, name, value.toString()) : null;
    }

    public static Long getLong(SingularNoun noun, String name, String value) {
        long longValue;
        Superlative superlative = Superlatives.A_LONG;
        BigDecimal bigDecimal = PrecisionCast.getBigDecimal(noun, name, superlative, value);
        if (bigDecimal == null) {
            return null;
        }
        try {
            longValue = bigDecimal.longValueExact();
        }
        catch (ArithmeticException ignored) {
            String statement = PrecisionStatement.the(noun, name, value).canNotBeCastTo(superlative).period();
            throw noun.equals(Nouns.ARGUMENT) ? new IllegalArgumentException(statement) : new IllegalStateException(statement);
        }
        PrecisionCast.validate(noun, name, superlative, value, Long.toString(longValue));
        return longValue;
    }

    public static Short getShort(SingularNoun noun, String name, Double value) {
        return value != null ? PrecisionCast.getShort(noun, name, value.toString()) : null;
    }

    public static Short getShort(SingularNoun noun, String name, Float value) {
        return value != null ? PrecisionCast.getShort(noun, name, value.toString()) : null;
    }

    public static Short getShort(SingularNoun noun, String name, Integer value) {
        return value != null ? PrecisionCast.getShort(noun, name, value.toString()) : null;
    }

    public static Short getShort(SingularNoun noun, String name, Long value) {
        return value != null ? PrecisionCast.getShort(noun, name, value.toString()) : null;
    }

    public static Short getShort(SingularNoun noun, String name, String value) {
        short shortValue;
        Superlative superlative = Superlatives.A_SHORT;
        BigDecimal bigDecimal = PrecisionCast.getBigDecimal(noun, name, superlative, value);
        if (bigDecimal == null) {
            return null;
        }
        try {
            shortValue = bigDecimal.shortValueExact();
        }
        catch (ArithmeticException ignored) {
            String statement = PrecisionStatement.the(noun, name, value).canNotBeCastTo(superlative).period();
            throw noun.equals(Nouns.ARGUMENT) ? new IllegalArgumentException(statement) : new IllegalStateException(statement);
        }
        PrecisionCast.validate(noun, name, superlative, value, Short.toString(shortValue));
        return shortValue;
    }

    static void validate(SingularNoun noun, String name, Superlative superlative, String originalValue, String castValue) {
        ObjectValidator.the((Noun)io.nuov.validator.Nouns.ARGUMENT, (String)"noun", (Object)noun).validate();
        StringValidator.the((Noun)io.nuov.validator.Nouns.ARGUMENT, (String)"name", (String)name).validate();
        ObjectValidator.the((Noun)io.nuov.validator.Nouns.ARGUMENT, (String)"superlative", (Object)superlative).validate();
        StringValidator.the((Noun)io.nuov.validator.Nouns.ARGUMENT, (String)"originalValue", (String)originalValue).validate();
        StringValidator.the((Noun)io.nuov.validator.Nouns.ARGUMENT, (String)"castValue", (String)castValue).validate();
        BigDecimal bigDecimal1 = new BigDecimal(originalValue).setScale(32, RoundingMode.HALF_EVEN);
        BigDecimal bigDecimal2 = new BigDecimal(castValue).setScale(32, RoundingMode.HALF_EVEN);
        if (bigDecimal1.compareTo(bigDecimal2) != 0) {
            String statement = PrecisionStatement.the(noun, name, originalValue).canNotBeCastTo(superlative).precisionAddendum().period();
            throw noun.equals(Nouns.ARGUMENT) ? new IllegalArgumentException(statement) : new IllegalStateException(statement);
        }
    }
}

