"use strict";var guid=function(){function e(){return Math.floor(65536*(1+Math.random())).toString(16).substring(1)}return function(){return e()+e()+"-"+e()+"-"+e()+"-"+e()+"-"+e()+e()+e()}}();function capitalize(e){return!e||!e.length||e.length<1?e:e.charAt(0).toUpperCase()+e.slice(1)}!function(){var e=angular.module("nflowExplorer",["nflowExplorer.about","nflowExplorer.config","nflowExplorer.config.adal","nflowExplorer.components","nflowExplorer.frontPage","nflowExplorer.layout","nflowExplorer.search","nflowExplorer.executors","nflowExplorer.services","nflowExplorer.workflow","nflowExplorer.workflowDefinition","nflowExplorer.workflowStats","ngAnimate","ngCookies","ngResource","ngSanitize","ngTouch","ui.bootstrap","chart.js","AdalAngular","toastr","smart-table"]);e.run(["EndpointService","ExecutorService","$window","config",function(e,t,o,r){r.htmlTitle&&(o.document.title=r.htmlTitle),e.init(),t.start()}]),e.config(["toastrConfig",function(e){angular.extend(e,{preventOpenDuplicates:!0})}])}(),angular.module("nflowExplorer.about",[]).controller("AboutCtrl",["$scope","config",function(e,t){e.nflowUrl=function(){return t.nflowUrl},e.nflowApiDocs=function(){return t.nflowApiDocs}}]),angular.module("nflowExplorer.config",["nflowExplorer.config.console","nflowExplorer.config.routes","nflowExplorer.config.notificationFilter"]).constant("config",new Config),angular.module("nflowExplorer.config.console",[]).config(function(){var t=window.console=window.console||{};_.forEachRight(["assert","clear","count","debug","dir","dirxml","error","exception","group","groupCollapsed","groupEnd","info","log","markTimeline","profile","profileEnd","table","time","timeEnd","timeStamp","trace","warn"],function(e){t[e]||(t[e]=_.noop)})}),angular.module("nflowExplorer.config.routes",["nflowExplorer.services","ui.router"]).config(["$stateProvider","$urlRouterProvider",function(e,t){function o(e,t){return e.get(t).then(_.first)}function r(e){return e.loadCss()}r.$inject=["GraphService"],t.otherwise("/"),e.state("frontPageTab",{abstract:!0,template:"<div ui-view></div>"}),e.state("searchTab",{abstract:!0,template:"<div ui-view></div>"}),e.state("executorsTab",{abstract:!0,template:"<div ui-view></div>"}),e.state("aboutTab",{abstract:!0,template:"<div ui-view></div>"}),e.state("frontPage",{parent:"frontPageTab",url:"/",templateUrl:"app/front-page/frontPage.html",controller:"FrontPageCtrl as ctrl"}).state("search",{parent:"searchTab",url:"/search?type&state&status&businessKey&externalId&id&parentWorkflowId",templateUrl:"app/search/search.html",controller:"SearchCtrl as ctrl",resolve:{definitions:["WorkflowDefinitionService",function(e){return e.list()}]}}).state("executors",{parent:"executorsTab",url:"/executors",templateUrl:"app/executors/executors.html",controller:"ExecutorsCtrl as ctrl"}).state("about",{parent:"aboutTab",url:"/about",templateUrl:"app/about/about.html",controller:"AboutCtrl"}).state("workflow-stats",{parent:"frontPageTab",url:"/workflow-stats?type",templateUrl:"app/workflow-stats/workflowStats.html",controller:"RadiatorCtrl"}).state("workflow-definition",{parent:"frontPageTab",url:"/workflow-definition/:type",templateUrl:"app/workflow-definition/workflowDefinition.html",controller:"WorkflowDefinitionCtrl as ctrl",resolve:{loadCss:r,definition:["WorkflowDefinitionService","$stateParams",function(e,t){return o(e,t.type)}]}}).state("workflow",{parent:"searchTab",url:"/workflow/:id",templateUrl:"app/workflow/workflow.html",controller:"WorkflowCtrl as ctrl",resolve:{loadCss:r,workflow:["WorkflowService","$stateParams",function(e,t){return e.get(t.id)}],definition:["WorkflowDefinitionService","workflow",function(e,t){return o(e,t.type)}],parentWorkflow:["WorkflowService","workflow",function(e,t){if(t.parentWorkflowId)return e.get(t.parentWorkflowId)}],childWorkflows:["WorkflowService","$stateParams",function(e,t){return e.query({parentWorkflowId:t.id})}]}})}]),angular.module("nflowExplorer.config.adal",["nflowExplorer.config","AdalAngular"]).config(["config","$httpProvider","adalAuthenticationServiceProvider",function(e,t,o){e.adal&&e.adal.requireADLogin&&o.init(e.adal,t)}]),function(){var e=angular.module("nflowExplorer.config.notificationFilter",["toastr"]);e.service("httpNotificationInterceptor",["$q","$injector",function(r,n){return{responseError:function(e){var t=n.get("toastr"),o={timeOut:0};return-1===e.status?t.error("Check network connection, CORS settings and ensure that nFlow REST API is running","REST API request aborted by browser",o):401===e.status||403===e.status?t.error("Authentication failed",o):404===e.status?t.error("Check that your URL is valid","Page not found",o):500<=e.status&&t.error("Internal server error",o),r.reject(e)}}}]),e.config(["$httpProvider",function(e){e.interceptors.push("httpNotificationInterceptor")}])}(),angular.module("nflowExplorer.components",["nflowExplorer.components.endpointSelection","nflowExplorer.components.constants","nflowExplorer.components.customContent","nflowExplorer.components.filters","nflowExplorer.components.graph","nflowExplorer.components.util","nflowExplorer.components.svgPanZoom"]),function(){var e=angular.module("nflowExplorer.components.constants",[]);e.constant("WorkflowStateType",{START:"start",MANUAL:"manual",NORMAL:"normal",END:"end",ERROR:"error"}),e.constant("WorkflowInstanceStatus",{CREATED:"created",IN_PROGRESS:"inProgress",FINISHED:"finished",MANUAL:"manual",EXECUTING:"executing"})}(),function(){var e=angular.module("nflowExplorer.components.customContent",[]);e.directive("customContent",function(){return{restrict:"E",replace:!0,scope:{func:"&"},bindToController:!0,controller:"CustomContentCtrl as ctrl",templateUrl:"app/components/customContent.html"}}),e.controller("CustomContentCtrl",function(){var t=this;t.$onInit=function(){if(t.func&&"function"==typeof t.func)try{var e=t.func();if(!e)return void(t.content="");if("string"==typeof e)return void(t.content=e);e.then(function(e){t.content=e}).catch(function(e){console.error("customContent function returned rejecting Promise",e),t.content=""})}catch(e){console.error("customContent function threw exception",e),t.content=""}}})}(),angular.module("nflowExplorer.components.filters",[]).filter("reverse",function(){return function(e){return e?e.slice().reverse():[]}}).filter("fromNow",function(){return function(t){if(!t)return"";try{return moment(t).fromNow()}catch(e){return t}}}).filter("fromNowOrNever",function(){return function(t){if(!t)return"never";try{return moment(t).fromNow()}catch(e){return t}}}).filter("prettyPrintJson",function(){return function(t){try{return JSON.stringify(t,void 0,2)}catch(e){return t}}}).filter("nullToZero",function(){return function(e){return e||0}}),angular.module("nflowExplorer.components.graph",["nflowExplorer.components.svgPanZoom"]).factory("Graph",["svgPanZoom",function(l){return{setNodeSelected:function(e,t,o){function r(e){d3.select(e).classed("selected",o)}_.each(e.nodeEdges(t),function(e){r("#"+a(e.v,e.w))}),r("#"+c(t))},markCurrentState:function(e){d3.select("#"+c(e.state)).classed("current-state",!0)},workflowDefinitionGraph:function(o,n){var i=(new dagreD3.graphlib.Graph).setGraph({});return function(){function t(o,t){return{rx:5,ry:5,class:function(){var e="node-"+(_.includes(["start","manual","end","error","wait"],o.type)?o.type:"normal");t&&t.state!==o.id&&_.isUndefined(_.find(t.actions,function(e){return e.state===o.id}))&&(e+=" node-passive");return e}(),retries:_.reduce(_.result(t,"actions"),function(e,t){return t.state===o.id&&0<t.retryNo?e+1:e},0),state:o,label:o.id,id:c(o.id),shape:"rect"}}_.forEach(o.states,function(e){i.setNode(e.id,t(e,n))}),(_.result(n,"actions")||[]).filter(function(e){return!i.hasNode(e.state)}).forEach(function(e){i.setNode(e.state,t({id:e.state},n))})}(),function(){_.forEach(o.states,function(t){_.forEach(t.transitions,function(e){r(t.id,e,"normal")});var e=t.onFailure||o.onError;"end"!==t.type&&e!==t.id&&r(t.id,e,"error")}),n&&function(){var o=null,e=n.actions.slice().reverse();e.push({state:n.state}),_.each(e,function(e){if(o&&o!==e.state)if(i.hasEdge(o,e.state)){var t=i.edge(o,e.state);t.class=t.class+" active"}else r(o,e.state,"unexpected");o=e.state})}();function r(e,t,o){i.setEdge(e,t,{id:a(e,t),class:"edge-"+o,arrowheadClass:"arrowhead-"+o,curve:d3.curveBasis})}}(),i},drawWorkflowDefinition:function(e,t,o,r){var n=function(e,t){var o=d3.select(e);return o.selectAll("*").remove(),o.append("style").attr("type","text/css").text(t),o.classed("svg-content-responsive",!0),o}(t,r);n.attr("preserveAspectRatio","xMinYMin meet");var i=n.append("g");(new dagreD3.render)(i,e),function(e,i,t){var o=d3.select(e).selectAll(".nodes > g");o.append("title").text(function(e){return t=i.node(e).state,_.capitalize(t.type)+" state\n"+t.description;var t}),o.attr("id",function(e){return c(e)}),o.attr("class",function(e){return i.node(e).class}),o.on("click",function(e){t(e)}),function(){var n={};o.selectAll("rect").each(function(e){var t=d3.select(this);n[e]={x:t.attr("x"),y:t.attr("y")}}),o.append("g").each(function(e){var t=i.node(e);if(0<t.retries){var o=n[e],r=d3.select(this);r.attr("transform","translate("+-o.x+",-4)"),r.append("ellipse").attr("cx",10).attr("cy",-5).attr("rx",20).attr("ry",10).attr("class","retry-indicator"),r.append("text").append("tspan").text(t.retries),r.append("title").text("State was retried "+t.retries+" times.")}})}()}(t,e,o);var a=function(e,t,o){var r=e.graph().height/e.graph().width,n=parseInt(t.style("width").replace(/px/,"")),i=Math.min(n/e.graph().width,1),a=Math.min(n*r,e.graph().width*r);1!==i&&(a=Math.max(a,400));return t.attr("height",a),o.attr("transform","scale("+i+")"),1!==i}(e,n,i);l(t,{center:!1,controlIconsEnabled:a,dblClickZoomEnabled:a,fit:!0,maxZoom:100,minZoom:.01,mouseWheelZoomEnabled:!1,panEnabled:a,zoomEnabled:a}).zoomOut(.01)},downloadDataUrl:s,downloadImage:function(e,t,o,r){console.info("Downloading image",o,r);var n=document.createElement("canvas"),i=n.getContext("2d");n.width=e[0],n.height=e[1];var a=new Image;a.width=n.width,a.height=n.height,a.onload=function(){i.drawImage(a,0,0,this.width,this.height),s(n.toDataURL(r),o)},a.onerror=function(e){console.error("Image downloading failed",e)},a.src=t}};function s(e,t){var o=document.createElement("a");"download"in o?(console.debug("Download via a.href,a.download"),o.download=t,o.href=e,o.click()):(console.debug("Download via location.href"),location.href=e)}function c(e){return"node_"+e}function a(e,t){return"edge-"+e+"-"+t}}]),angular.module("nflowExplorer.components.util",[]).directive("emptyToNull",function(){return{restrict:"A",require:"ngModel",link:function(e,t,o,r){r.$parsers.push(function(e){return""===e?null:e})}}}),angular.module("nflowExplorer.components.svgPanZoom",[]).factory("svgPanZoom",["$window",function(e){return e.svgPanZoom?e.svgPanZoom:(console.error("Failed to load svgPanZoom"),function(){})}]),function(){var e=angular.module("nflowExplorer.components.endpointSelection",[]);e.directive("endpointSelection",function(){return{scope:{},bindToController:!0,restrict:"E",controller:"EndpointSelectionCtrl as ctrl",templateUrl:"app/components/endpointSelection/endpointSelection.html"}}),e.controller("EndpointSelectionCtrl",["config","EndpointService",function(e,t){this.endpoints=e.nflowEndpoints,this.selectedEndpoint=t.currentEndpoint(),this.endpointChange=function(e){t.selectEndpoint(e)}}])}(),angular.module("nflowExplorer.executors",["nflowExplorer.executors.executorTable","nflowExplorer.services"]).controller("ExecutorsCtrl",["ExecutorService",function(e){this.executors=e.executors}]),function(){var e=angular.module("nflowExplorer.executors.executorTable",["nflowExplorer.services","nflowExplorer.components"]);e.directive("executorTable",function(){return{restrict:"E",replace:!0,scope:{executors:"="},bindToController:!0,controller:"ExecutorTableCtrl as ctrl",templateUrl:"app/executors/executorTable.html"}}),e.controller("ExecutorTableCtrl",["Time",function(o){this.executorClass=function(e,t){if(t=t||o.currentMoment(),e.stopped)return;if(!e.expires){if(moment(e.started).add(1,"days").isBefore(t))return;return moment(e.started).add(1,"hours").isBefore(t)?"warning":"success"}if(moment(e.active).add(1,"days").isBefore(t))return;if(moment(e.expires).isBefore(t))return"warning";return"success"},this.isActive=function(e){var t=o.currentMoment().add(-24,"hours");{if(!e.expires)return moment(e.started).isAfter(t);if(moment(e.expires).isBefore(t))return!1}return!0}}])}(),angular.module("nflowExplorer.frontPage",["nflowExplorer.frontPage.definitionList","nflowExplorer.services"]).controller("FrontPageCtrl",["WorkflowDefinitionService",function(e){var t=this;e.list().then(function(e){t.definitions=e})}]),function(){var e=angular.module("nflowExplorer.frontPage.definitionList",[]);e.directive("definitionList",function(){return{restrict:"E",replace:!0,scope:{definitions:"="},bindToController:!0,controller:"DefinitionListCtrl as ctrl",templateUrl:"app/front-page/definitionList.html"}}),e.controller("DefinitionListCtrl",["$scope","$location",function(e,t){e.showDefinition=function(e){t.path("workflow-definition/"+e)}}])}(),function(){var e=angular.module("nflowExplorer.layout",["nflowExplorer.config"]);e.directive("layout",function(){return{restrict:"E",replace:"true",templateUrl:"app/layout/layout.html"}}),e.directive("pageHeader",function(){return{restrict:"E",replace:"true",templateUrl:"app/layout/header.html",controller:"PageHeaderCtrl as ctrl"}}),e.directive("pageFooter",["config",function(e){return e.hideFooter?{}:{restrict:"E",replace:"true",templateUrl:"app/layout/footer.html"}}]),e.controller("PageHeaderCtrl",["$location","$state","$window","config",function(e,t,o,r){var n=this;function i(e,t){for(var o=t.location.search.substring(1).split("&"),r=0;r<o.length;r++){var n=o[r].split("=");if(n[0]===e)return decodeURIComponent(n[1])}}n.radiator=!!e.search().radiator,n.isFrontPageTabActive=function(){return t.includes("frontPageTab")},n.isExecutorsTabActive=function(){return t.includes("executorsTab")},n.isSearchTabActive=function(){return t.includes("searchTab")},n.isAboutTabActive=function(){return t.includes("aboutTab")},n.returnUrl=i("returnUrl",o),n.returnUrlLabel=i("returnUrlLabel",o)||"Back",n.nflowLogoFile=r.nflowLogoFile||"images/nflow_logo.65aab8a3.svg"}])}(),angular.module("nflowExplorer.search.criteriaModel",[]).factory("CriteriaModel",function(){var o={model:{}};return o.initialize=function(e,t){angular.copy({},o.model),o.model.definition=function(t,e){return n(_.find(e,function(e){return e.type===t}))}(e.type,t),o.model.state=r(e.stateId,o.model.definition),o.model.status=n(e.status),o.model.businessKey=n(e.businessKey),o.model.externalId=n(e.externalId),o.model.id=n(e.id),o.model.parentWorkflowId=n(e.parentWorkflowId),o.allDefinitions="all"===e.type},o.toQuery=function(){var e={};return e.type=_.result(o.model.definition,"type"),e.state=_.result(o.model.state,"id"),_.defaults(e,_.omit(o.model,["definition","state"])),t(e)},o.isEmpty=function(){return _.isEmpty(t(o.model))&&!o.allDefinitions},o.onDefinitionChange=function(){o.model.state=r(_.result(o.model.state,"id"),o.model.definition)},o;function r(t,e){return e?n(_.find(e.states,function(e){return e.id===t})):null}function t(e){return _.omitBy(e,function(e){return _.isUndefined(e)||_.isNull(e)})}function n(e){return e||null}}),angular.module("nflowExplorer.search",["nflowExplorer.search.criteriaModel","nflowExplorer.search.searchForm","nflowExplorer.search.searchResult"]).controller("SearchCtrl",["$stateParams","definitions","CriteriaModel",function(e,t,o){var r=this;function n(e){try{return parseInt(e)}catch(e){return}}r.definitions=t,r.results=void 0,r.hasResults=function(){return void 0!==r.results},o.initialize({type:e.type,stateId:e.state,status:e.status,businessKey:e.businessKey,externalId:e.externalId,id:n(e.id),parentWorkflowId:n(e.parentWorkflowId)},t)}]),function(){var e=angular.module("nflowExplorer.search.searchForm",["nflowExplorer.search.criteriaModel","nflowExplorer.services","nflowExplorer.components"]);e.directive("searchForm",function(){return{restrict:"E",replace:!0,scope:{results:"=",definitions:"="},bindToController:!0,controller:"SearchFormCtrl",controllerAs:"ctrl",templateUrl:"app/search/searchForm.html"}}),e.controller("SearchFormCtrl",["$state","$timeout","CriteriaModel","WorkflowService","WorkflowInstanceStatus",function(e,o,r,n,t){var i=this;function a(){var e=o(function(){i.showIndicator=!0},500);function t(){o.cancel(e),i.showIndicator=!1}n.query(r.toQuery()).then(function(e){i.results=e,t()}).catch(t)}i.showIndicator=!1,i.instanceStatuses=_.values(t),i.model=r.model,i.search=function(){e.go("search",{type:i.model.definition&&i.model.definition.type||"all",state:i.model.state&&i.model.state.id,status:i.model.status,businessKey:i.model.businessKey,externalId:i.model.externalId,id:i.model.id,parentWorkflowId:i.model.parentWorkflowId},{reload:!0})},i.executeSearch=a,i.onTypeChange=r.onDefinitionChange,i.wildCardTooltip="Use % to replace many characters and _ to replace a single character",r.isEmpty()||a()}])}(),function(){var e=angular.module("nflowExplorer.search.searchResult",["nflowExplorer.components"]);e.directive("searchResult",function(){return{restrict:"E",replace:!0,scope:{results:"=",definitions:"="},bindToController:!0,controller:"SearchResultCtrl as ctrl",templateUrl:"app/search/searchResult.html"}}),e.controller("SearchResultCtrl",["WorkflowStateType",function(e){var r=this;r.getStateClass=function(t){if(!t)return"";var e=_.find(r.definitions,function(e){return e.type===t.type});if(e){var o=_.find(e.states,function(e){return e.id===t.state});if(o)return o.id===e.onError?"danger":n[o.type]||""}return""};var n={};n[e.NORMAL]="info",n[e.MANUAL]="warning",n[e.END]="success",n[e.ERROR]="danger"}])}(),angular.module("nflowExplorer.services",["nflowExplorer.config","nflowExplorer.services.EndpointService","nflowExplorer.services.ExecutorService","nflowExplorer.services.GraphService","nflowExplorer.services.Time","nflowExplorer.services.WorkflowDefinitionService","nflowExplorer.services.WorkflowService","nflowExplorer.services.WorkflowStatsPoller"]),angular.module("nflowExplorer.services.RestHelper",["nflowExplorer.config","ngResource"]).factory("RestHelper",["config","$resource",function(r,n){var e={query:function(e,t){return n(r.nflowUrl+e.path,t,{query:{method:"GET",isArray:!0,cache:e.cache,withCredentials:!!r.withCredentials}}).query().$promise},get:function(e,t,o){return n(r.nflowUrl+e.path,o,{query:{method:"GET",cache:e.cache,withCredentials:!!r.withCredentials}}).get(t).$promise},update:function(e,t){return n(r.nflowUrl+e,null,{update:{method:"PUT",withCredentials:!!r.withCredentials}}).update(t).$promise}};return e}]),angular.module("nflowExplorer.services.EndpointService",["nflowExplorer.config"]).service("EndpointService",["config","$window","$state",function(o,r,n){var t=this;function i(e){if(e){var t=o.selectedEndpoint&&o.selectedEndpoint.id!==e.id;o.selectedEndpoint=e,o.nflowUrl=e.apiUrl,o.nflowApiDocs=e.docUrl,o.withCredentials=e.withCredentials;try{r.localStorage.setItem("nflow.endpoint",e.id)}catch(e){}t&&(n.go("frontPage"),r.location.reload())}}function e(e){e?i(_.find(t.availableEndpoints(),{id:e})):i(_.first(o.nflowEndpoints))}t.currentEndpoint=function(){return o.selectedEndpoint},t.selectEndpoint=e,t.availableEndpoints=function(){return o.nflowEndpoints},t.init=function(){var t;try{t=r.localStorage.getItem("nflow.endpoint")}catch(e){t=r.sessionStorage.getItem("nflow.endpoint")}e(t)}}]),angular.module("nflowExplorer.services.ExecutorService",["nflowExplorer.config","nflowExplorer.services.RestHelper"]).service("ExecutorService",["config","RestHelper","$interval",function(e,t,o){var r=!1,n=this;function i(){console.info("Fetching executors"),n.list().then(function(e){angular.copy(e,n.executors)})}n.list=function(){return t.query({path:"/v1/workflow-executor"})},n.start=function(){r||(r=!0,console.info("Start executor poller with period ",e.radiator.pollPeriod," seconds"),i(),o(i,1e3*e.radiator.pollPeriod));console.info("Executor poller already started")},n.executors=[]}]),angular.module("nflowExplorer.services.GraphService",["nflowExplorer.config"]).service("GraphService",["config","$q","$http","$rootScope",function(e,o,r,n){this.loadCss=function(){var t=o.defer();return r.get("styles/data/graph.css",{withCredentials:!!e.withCredentials}).then(function(e){n.graph={},n.graph.css=e.data,t.resolve()},function(){console.warn("Failed to load graph.css"),n.graph={},t.resolve()}),t.promise}}]),angular.module("nflowExplorer.services.Time",[]).service("Time",function(){this.currentMoment=function(){return moment()}}),angular.module("nflowExplorer.services.WorkflowDefinitionService",["nflowExplorer.services.RestHelper"]).service("WorkflowDefinitionService",["config","RestHelper","$cacheFactory",function(e,t,o){this.get=function(e){return t.query({path:"/v1/workflow-definition",cache:r},{type:e})},this.list=function(){return t.query({path:"/v1/workflow-definition",cache:n})},this.getStats=function(e){return t.get({path:"/v1/statistics/workflow/:type"},{type:e},{type:"@type"})};var r=o("workflow-definition");var n=o("workflow-definition-list")}]),angular.module("nflowExplorer.services.WorkflowStatsPoller",["nflowExplorer.services.WorkflowDefinitionService"]).service("WorkflowStatsPoller",["$rootScope","config","$interval","WorkflowDefinitionService",function(o,n,t,e){var i={};function r(e,t,o){var r=i[e].data;for(r.push([t,o]);r.length>n.maxHistorySize;)r.shift()}function a(t){e.getStats(t).then(function(e){console.info("Fetched statistics for "+t),r(t,new Date,e),i[t].latest=e,o.$broadcast("workflowStatsUpdated",t)}).catch(function(){console.error("Fetching workflow "+t+" stats failed"),r(t,new Date,{}),o.$broadcast("workflowStatsUpdated",t)})}this.start=function(e){return!i[e]&&(i[e]={},i[e].data=[],console.info("Start stats poller for "+e+" with period "+n.radiator.pollPeriod+" seconds"),a(e),i[e].poller=t(function(){a(e)},1e3*n.radiator.pollPeriod),!0)},this.stop=function(e){i[e]&&(console.info("Stop stats poller for "+e),t.cancel(i[e].poller),i[e]=void 0)},this.getLatest=function(e){if(i[e])return i[e].latest}}]),angular.module("nflowExplorer.services.WorkflowService",["nflowExplorer.config","nflowExplorer.services.RestHelper"]).service("WorkflowService",["config","RestHelper",function(e,o){this.get=function(e){return o.get({path:"/v1/workflow-instance/id/"+e+"?include=actions,currentStateVariables,actionStateVariables"})},this.update=function(e,t){return o.update("/v1/workflow-instance/id/"+e,t)},this.query=function(e){return o.query({path:"/v1/workflow-instance"},e)},this.signal=function(e,t){return o.update("/v1/workflow-instance/"+e+"/signal",t)}}]),angular.module("nflowExplorer.workflow",["nflowExplorer.workflow.graph","nflowExplorer.workflow.info","nflowExplorer.workflow.tabs","nflowExplorer.services.WorkflowService"]).controller("WorkflowCtrl",["workflow","definition","parentWorkflow","childWorkflows","$scope","config","$interval","WorkflowService",function(e,t,o,r,n,i,a,l){var s=this;s.workflow=e,s.parentWorkflow=o,s.definition=t,s.childWorkflows=r,s.poller=a(function(){var e;e=s.workflow.id,console.log("Fetching workflow id "+e),l.get(e).then(function(t){l.query({parentWorkflowId:t.id}).then(function(e){s.workflow=t,s.childWorkflows=e})})},1e3*i.radiator.pollPeriod),n.$on("$destroy",function(){console.log("Stop polling workflow id "+s.workflow.id),a.cancel(s.poller)})}]),function(){var e=angular.module("nflowExplorer.workflow.graph",[]);e.directive("workflowGraph",function(){return{restrict:"E",replace:!0,scope:{definition:"=",workflow:"="},controller:"WorkflowGraphCtrl",controllerAs:"ctrl",template:'<div class="svg-container"><svg id="workflowSvg"/></div>'}}),e.controller("WorkflowGraphCtrl",["$rootScope","WorkflowGraphApi","Graph","$scope",function(l,s,c,e){var t,o=this;o.definition=e.definition,o.workflow=e.workflow,t=function(e,t){var o,r=e,n=t,i=c.workflowDefinitionGraph(r,n),a={};return a.drawWorkflowDefinition=function(){c.drawWorkflowDefinition(i,"#workflowSvg",s.onSelectNode,l.graph.css),c.markCurrentState(n)},a.nodeSelected=function(e){console.debug("Selecting node "+e),o&&c.setNodeSelected(i,o,!1),i.hasNode(e)&&(c.setNodeSelected(i,e,!0),o=e)},a}(o.definition,o.workflow),s.registerOnSelectNodeListener(t.nodeSelected),t.drawWorkflowDefinition()}]),e.factory("WorkflowGraphApi",function(){var o=[],e={onSelectNode:function(t){_.forEach(o,function(e){e(t)})},registerOnSelectNodeListener:function(e){o.push(e)}};return e})}(),function(){var e=angular.module("nflowExplorer.workflow.info",["nflowExplorer.components","nflowExplorer.workflow.graph"]);e.directive("workflowInfo",function(){return{restrict:"E",replace:!0,scope:{workflow:"=",parentWorkflow:"=",childWorkflows:"=",definition:"="},bindToController:!0,controller:"WorkflowInfoCtrl",controllerAs:"ctrl",templateUrl:"app/workflow/workflowInfo.html"}}),e.controller("WorkflowInfoCtrl",["WorkflowGraphApi","config",function(e,t){var o=this;o.currentStateTime=function(){return _.result(o,"modified","")},o.selectAction=e.onSelectNode,o.contentGenerator=t.customInstanceContent}])}(),function(){var e=angular.module("nflowExplorer.workflow.tabs",["nflowExplorer.workflow.tabs.actionHistory","nflowExplorer.workflow.tabs.stateVariables","nflowExplorer.workflow.tabs.manageState","nflowExplorer.workflow.tabs.manageVariables","nflowExplorer.workflow.tabs.manageSignal"]);e.directive("workflowTabs",function(){return{restrict:"E",replace:!0,scope:{definition:"=",workflow:"=",childWorkflows:"="},bindToController:!0,controller:"WorkflowTabsCtrl",controllerAs:"ctrl",templateUrl:"app/workflow/workflowTabs.html"}}),e.controller("WorkflowTabsCtrl",function(){})}(),function(){var e=angular.module("nflowExplorer.workflow.tabs.actionHistory",["nflowExplorer.workflow.graph"]);e.directive("workflowTabActionHistory",function(){return{restrict:"E",replace:!0,scope:{workflow:"=",childWorkflows:"="},bindToController:!0,controller:"WorkflowTabActionHistoryCtrl",controllerAs:"ctrl",templateUrl:"app/workflow/tabs/actionHistory.html"}}),e.controller("WorkflowTabActionHistoryCtrl",["WorkflowGraphApi",function(e){var t=this;t.selectAction=e.onSelectNode,t.duration=function(e){var t=moment(e.executionStartTime),o=moment(e.executionEndTime);if(!t||!o)return"-";var r=moment.duration(o.diff(t));if(r<1e3)return r+" msec";return r.humanize()},t.childWorkflowFromAction=function(e){return _.filter(t.childWorkflows,{parentActionId:e.id})}}])}(),function(){var e=angular.module("nflowExplorer.workflow.tabs.manageState",["nflowExplorer.workflow.graph","nflowExplorer.services","ui.router"]);e.directive("workflowTabManageState",function(){return{restrict:"E",replace:!0,scope:{definition:"=",workflow:"="},controller:"WorkflowManageStateCtrl",controllerAs:"ctrl",templateUrl:"app/workflow/tabs/manageState.html"}}),e.controller("WorkflowManageStateCtrl",["$state","WorkflowService","WorkflowGraphApi","$scope","toastr",function(e,o,t,r,n){var i={timeUnits:["minutes","hours","days"]};i.timeUnit=i.timeUnits[0],i.duration=0;var a=this;function l(t){i.nextState=_.first(_.filter(a.definition.states,function(e){return e.id===t}))}function s(){n.success("Workflow instance state updated"),e.reload()}function c(){n.error("Workflow instance state update failed")}a.model=i,a.definition=r.definition,a.workflow=r.workflow,a.updateWorkflow=function(){console.info("updateWorkflow()",i);var e=moment(new Date),t={};i.nextState&&(t.state=i.nextState.id);_.isNumber(i.duration)&&i.timeUnit&&(t.nextActivationTime=e.add(moment.duration(i.duration,i.timeUnit)));i.actionDescription&&(t.actionDescription=i.actionDescription);o.update(a.workflow.id,t).then(s,c)},r.safeApply=function(e){var t=this.$root.$$phase;"$apply"===t||"$digest"===t?e&&"function"==typeof e&&e():this.$apply(e)},l(a.workflow.state),t.registerOnSelectNodeListener(function(e){r.safeApply(function(){l(e)})})}])}(),function(){var e=angular.module("nflowExplorer.workflow.tabs.manageVariables",["nflowExplorer.services","ui.router"]);e.directive("workflowTabManageVariables",function(){return{restrict:"E",replace:!0,scope:{definition:"=",workflow:"="},bindToController:!0,controller:"WorkflowManageVariablesCtrl",controllerAs:"ctrl",templateUrl:"app/workflow/tabs/manageVariables.html"}}),e.controller("WorkflowManageVariablesCtrl",["$state","WorkflowService","toastr",function(e,t,o){var r={},n=this;function i(){o.success("Workflow instance variables updated"),e.reload()}function a(){o.error("Workflow instance variables update failed")}n.model=r,n.updateWorkflow=function(){console.info("updateWorkflow()",r);var e={};r.variableName&&r.variableValue&&(e.stateVariables={},e.stateVariables[r.variableName]=r.variableValue);r.actionDescription&&(e.actionDescription=r.actionDescription);t.update(n.workflow.id,e).then(i,a)}}])}(),function(){var e=angular.module("nflowExplorer.workflow.tabs.manageSignal",["nflowExplorer.services","ui.router"]);e.directive("workflowTabManageSignal",function(){return{restrict:"E",replace:!0,scope:{definition:"=",workflow:"="},bindToController:!0,controller:"WorkflowManageSignalCtrl",controllerAs:"ctrl",templateUrl:"app/workflow/tabs/manageSignal.html"}}),e.controller("WorkflowManageSignalCtrl",["$state","WorkflowService","toastr",function(e,t,o){var r={},n=this;function i(){o.success("Workflow instance signal updated"),e.reload()}function a(){o.error("Workflow instance signal update failed")}n.model=r,n.signalWorkflow=function(){var e={signal:r.signal.value,reason:r.signalReason};t.signal(n.workflow.id,e).then(i,a)}}])}(),function(){var e=angular.module("nflowExplorer.workflow.tabs.stateVariables",[]);e.directive("workflowTabStateVariables",function(){return{restrict:"E",replace:!0,scope:{workflow:"="},bindToController:!0,controller:"WorkflowTabStateVariablesCtrl",controllerAs:"ctrl",templateUrl:"app/workflow/tabs/stateVariables.html"}}),e.controller("WorkflowTabStateVariablesCtrl",function(){})}(),angular.module("nflowExplorer.workflowDefinition",["nflowExplorer.workflowDefinition.tabs"]).controller("WorkflowDefinitionCtrl",["definition","config",function(e,t){this.definition=e,this.contentGenerator=t.customDefinitionContent}]),function(){var e=angular.module("nflowExplorer.workflowDefinition.graph",[]);e.directive("workflowDefinitionGraph",function(){return{restrict:"E",replace:!0,scope:{definition:"="},controller:"WorkflowDefinitionGraphCtrl",controllerAs:"ctrl",templateUrl:"app/workflow-definition/workflowDefinitionGraph.html"}}),e.controller("WorkflowDefinitionGraphCtrl",["$rootScope","$scope","WorkflowDefinitionGraphApi","Graph",function(t,e,n,i){var a,o,r=this;r.saveSvg=function(){console.info("Save SVG"),o.save(function(){i.downloadDataUrl(a.dataUrl(),r.definition.type+".svg")})},r.definition=e.definition,function(){a=function(){var t="#dagreSvg",o=$(t).width()/$(t).height(),e={};return e.selector=t,e.dataUrl=function(){var e=d3.select(t).attr("version",1.1).node().outerHTML;return"data:image/svg+xml;base64,"+btoa(e)},e.size=function(){var e=$(t).height();return[e*o,e]},e}(),o=function(e){var o=i.workflowDefinitionGraph(e),r={};return r.drawWorkflowDefinition=function(){i.drawWorkflowDefinition(o,a.selector,n.onSelectNode,t.graph.css)},r.nodeSelected=function(e){var t=n.selectedNode;console.debug("Selecting node "+e),t&&i.setNodeSelected(o,t,!1),e&&i.setNodeSelected(o,e,!0)},r.save=function(e){var t=n.selectedNode;r.nodeSelected(null),e(),r.nodeSelected(t)},r}(r.definition),n.initialize(o.nodeSelected);var e=(new Date).getTime();o.drawWorkflowDefinition(),console.debug("Rendering dagre graph took",(new Date).getTime()-e,"ms")}()}]),e.factory("WorkflowDefinitionGraphApi",["$timeout",function(t){var o=_.noop,r={initialize:function(e){o=e},onSelectNode:function(e){t(function(){o(e),r.selectedNode=e})},selectedNode:void 0};return r}])}(),function(){var e=angular.module("nflowExplorer.workflowDefinition.tabs",["nflowExplorer.workflowDefinition.tabs.workflowStatisticsTable","nflowExplorer.workflowDefinition.tabs.workflowSignalsTable"]);e.directive("workflowDefinitionTabs",function(){return{restrict:"E",replace:!0,scope:{definition:"="},controller:"WorkflowDefinitionTabsCtrl",controllerAs:"ctrl",templateUrl:"app/workflow-definition/workflowDefinitionTabs.html"}}),e.controller("WorkflowDefinitionTabsCtrl",["$rootScope","$scope","WorkflowDefinitionGraphApi","WorkflowStatsPoller",function(e,o,t,r){var a=this;function n(e){if(o.stats=r.getLatest(e),a.definition){if(o.stats){var t=o.stats.stateStatistics||{};o.labels=function(o){var r=[];_.forEach(_.keys(o),function(e){var t=o[e];(t.created.allInstances||t.created.queuedInstances||t.inProgress.allInstances||t.inProgress.queuedInstances||t.executing.allInstances||t.manual.allInstances)&&r.push(e)});var e=_.map(_.reject(a.definition.states,{type:"end"}),"id"),t=_.union(r,e);return t.sort(),t}(t),o.data=function(e,t){for(var o=function e(t){var o=[];for(var r=0;r<t[0];++r)o.push(1===t.length?0:e(t.slice(1)));return o}([a._metaStatuses.length,e.length]),r=0;r<e.length;r++){var n=t[e[r]];if(n)for(var i=0;i<a._metaStatuses.length;i++)"sleeping"===a._metaStatuses[i]?o[i][r]=n.created.allInstances-n.created.queuedInstances+(n.inProgress.allInstances-n.inProgress.queuedInstances):"queued"===a._metaStatuses[i]?o[i][r]=n.created.queuedInstances+n.inProgress.queuedInstances:"manual"===a._metaStatuses[i]?o[i][r]=n.manual.allInstances:"executing"===a._metaStatuses[i]?o[i][r]=n.executing.allInstances:console.error("Unknown metastatus "+a._metaStatuses[i])}return o}(o.labels,t)}}else console.debug("Definition not loaded yet")}a._metaStatuses=["sleeping","queued","executing","manual"],a.selectNode=t.onSelectNode,a.isStateSelected=function(e){return e.id===t.selectedNode},a.startRadiator=function(){e.$broadcast("startRadiator")},a.definition=o.definition,o.type="StackedBar",o.series=a._metaStatuses,o.options={scales:{xAxes:[{stacked:!0,ticks:{min:0,stepSize:1}}],yAxes:[{stacked:!0}]}},o.stats={},n(a.definition.type),r.start(a.definition.type),o.$on("workflowStatsUpdated",function(e,t){t===a.definition.type&&n(t)}),o.$on("$destroy",function(){r.stop(a.definition.type)})}])}(),function(){var e=angular.module("nflowExplorer.workflowDefinition.tabs.workflowSignalsTable",[]);e.directive("workflowSignalsTable",function(){return{restrict:"E",replace:!0,scope:{definition:"="},bindToController:!0,controller:"WorkflowSignalsTable",controllerAs:"ctrl",templateUrl:"app/workflow-definition/tabs/workflowSignalsTable.html"}}),e.controller("WorkflowSignalsTable",function(){})}(),function(){var e=angular.module("nflowExplorer.workflowDefinition.tabs.workflowStatisticsTable",["nflowExplorer.workflowDefinition.graph"]);e.directive("workflowStatisticsTable",function(){return{restrict:"E",replace:!0,scope:{definition:"="},controller:"WorkflowStatisticsTable",controllerAs:"ctrl",templateUrl:"app/workflow-definition/tabs/workflowStatisticsTable.html"}}),e.controller("WorkflowStatisticsTable",["WorkflowDefinitionGraphApi","WorkflowStatsPoller","$scope",function(t,o,r){function n(o){o.stateStatisticsTotal={allInstances:0,created:{allInstances:0,queuedInstances:0},inProgress:{allInstances:0,queuedInstances:0},executing:{allInstances:0},manual:{allInstances:0},finished:{allInstances:0}},_.forEach(_.keys(o.stateStatistics),function(e){var t=o.stateStatistics[e];o.stateStatisticsTotal.allInstances+=t.created.allInstances+t.inProgress.allInstances+t.manual.allInstances+t.executing.allInstances+t.finished.allInstances,o.stateStatisticsTotal.created.allInstances+=t.created.allInstances,o.stateStatisticsTotal.created.queuedInstances+=t.created.queuedInstances,o.stateStatisticsTotal.inProgress.allInstances+=t.inProgress.allInstances,o.stateStatisticsTotal.inProgress.queuedInstances+=t.inProgress.queuedInstances,o.stateStatisticsTotal.executing.allInstances+=t.executing.allInstances,o.stateStatisticsTotal.manual.allInstances+=t.manual.allInstances,o.stateStatisticsTotal.finished.allInstances+=t.finished.allInstances})}r.isStateSelected=function(e){return e.id===t.selectedNode},r.selectNode=t.onSelectNode,r.stats=o.getLatest(r.definition.type)||{},n(r.stats),r.$on("workflowStatsUpdated",function(e,t){t===r.definition.type&&(r.stats=o.getLatest(t),n(r.stats))})}])}(),angular.module("nflowExplorer.workflowStats",[]).controller("WorkflowStatsCtrl",["$scope","$rootScope","$interval","WorkflowDefinitionService","$stateParams","config",function(s,c,e,t,o,r){s.type=o.type;var n=r.maxHistorySize;function i(){c.radiator&&c.radiator.radiatorStatsTask&&e.cancel(c.radiator.radiatorStatsTask),c.radiator={},c.radiator.type=s.type,c.radiator.stateChart={},c.radiator.stateChart.data=[],s.graphs={}}function f(e){return _.reduce(e,function(e,t){return t?e+t:e},0)}function u(e,t){var o=document.getElementById(e);if(o){var r=["timestamp"].concat(t.labels);if(s.graphs[e])s.graphs[e].updateOptions({file:t.dataArray,labels:r});else{var n={axisLabelFontSize:13,responsive:!0,stackedGraph:!0,legend:"always",labelsDiv:e+"Legend",labelsSeparateLines:!0,labels:r,axes:{x:{axisLabelWidth:55}}};s.graphs[e]=new Dygraph(o,t.dataArray,n)}}}function a(e,t){var o=c.radiator.stateChart.data;for(o.push([e,t]);o.length>n;)o.shift()}function l(){var e,t,n,o,a,r,l,i=(e=c.radiator.stateChart.data,_.reduce(e,function(e,t){return _.map(t[1],function(e,t){return t})},{}).sort());t=i,i=_.filter(t,function(t){var e=_.first(_.filter(s.definition.states,function(e){return e.id===t}));return!e||"end"!==e.type}),u("stateChart",(n=i,o=c.radiator.stateChart.data,{dataArray:_.map(o,function(e){var t=e[0],o=e[1],r=_.map(n,function(e){if(o){var t=o[e];return t?f(_.map(_.values(t),function(e){return e.allInstances})):0}});return[t].concat(r)}),labels:n})),u("executionChart",(a=i,r=c.radiator.stateChart.data,l=["executing","manual"],{dataArray:_.map(r,function(e){var t,o,r=e[0],n=e[1],i=_.map(l,function(o){return f(_.map(a,function(e){if(n){var t=n[e];return t&&t[o]?t[o].allInstances:0}}))});return t=f(_.map(n,function(e){return(e.created?e.created.queuedInstances:0)+(e.inProgress?e.inProgress.queuedInstances:0)})),o=f(_.map(n,function(e){return(e.created?e.created.allInstances-e.created.queuedInstances:0)+(e.inProgress?e.inProgress.allInstances-e.inProgress.queuedInstances:0)})),[r].concat([t,o]).concat(i)}),labels:_.map(["queued","sleeping","executing","manual"],_.startCase)}))}function d(){t.getStats(s.type).then(function(e){console.info("Fetching statistics",e),a(new Date,e.stateStatistics),l()}).catch(function(e){console.error(e),a(new Date,{}),l()})}s.definition={},s.definition.states=[],s.graphs||(s.graphs={}),c.radiator&&c.radiator.type===s.type||i(),t.get(s.type).then(function(e){s.definition=_.first(e)}),s.$on("$destroy",function(){s.graphs={}}),s.$on("startRadiator",function(){d(),c.radiator.radiatorStatsTask||(c.radiator.radiatorStatsTask=e(d,1e3*r.radiator.pollPeriod))})}]);