/*
 * Decompiled with CFR 0.152.
 */
package org.pegdown;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.pegdown.DefaultVerbatimSerializer;
import org.pegdown.LinkRenderer;
import org.pegdown.Printer;
import org.pegdown.VerbatimSerializer;
import org.pegdown.ast.AbbreviationNode;
import org.pegdown.ast.AutoLinkNode;
import org.pegdown.ast.BlockQuoteNode;
import org.pegdown.ast.BulletListNode;
import org.pegdown.ast.CodeNode;
import org.pegdown.ast.DefinitionListNode;
import org.pegdown.ast.DefinitionNode;
import org.pegdown.ast.DefinitionTermNode;
import org.pegdown.ast.ExpImageNode;
import org.pegdown.ast.ExpLinkNode;
import org.pegdown.ast.HeaderNode;
import org.pegdown.ast.HtmlBlockNode;
import org.pegdown.ast.InlineHtmlNode;
import org.pegdown.ast.ListItemNode;
import org.pegdown.ast.MailLinkNode;
import org.pegdown.ast.Node;
import org.pegdown.ast.OrderedListNode;
import org.pegdown.ast.ParaNode;
import org.pegdown.ast.QuotedNode;
import org.pegdown.ast.RefImageNode;
import org.pegdown.ast.RefLinkNode;
import org.pegdown.ast.ReferenceNode;
import org.pegdown.ast.RootNode;
import org.pegdown.ast.SimpleNode;
import org.pegdown.ast.SpecialTextNode;
import org.pegdown.ast.StrikeNode;
import org.pegdown.ast.StrongEmphSuperNode;
import org.pegdown.ast.SuperNode;
import org.pegdown.ast.TableBodyNode;
import org.pegdown.ast.TableCaptionNode;
import org.pegdown.ast.TableCellNode;
import org.pegdown.ast.TableColumnNode;
import org.pegdown.ast.TableHeaderNode;
import org.pegdown.ast.TableNode;
import org.pegdown.ast.TableRowNode;
import org.pegdown.ast.TextNode;
import org.pegdown.ast.VerbatimNode;
import org.pegdown.ast.Visitor;
import org.pegdown.ast.WikiLinkNode;
import org.pegdown.plugins.ToHtmlSerializerPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToHtmlSerializer
implements Visitor {
    protected Printer printer = new Printer();
    protected final Map<String, ReferenceNode> references = new HashMap<String, ReferenceNode>();
    protected final Map<String, String> abbreviations = new HashMap<String, String>();
    protected final LinkRenderer linkRenderer;
    protected final List<ToHtmlSerializerPlugin> plugins;
    protected TableNode currentTableNode;
    protected int currentTableColumn;
    protected boolean inTableHeader;
    protected Map<String, VerbatimSerializer> verbatimSerializers;

    public ToHtmlSerializer(LinkRenderer linkRenderer) {
        this(linkRenderer, Collections.emptyList());
    }

    public ToHtmlSerializer(LinkRenderer linkRenderer, List<ToHtmlSerializerPlugin> plugins) {
        this.linkRenderer = linkRenderer;
        this.plugins = plugins;
        this.verbatimSerializers = Collections.singletonMap("DEFAULT", DefaultVerbatimSerializer.INSTANCE);
    }

    public ToHtmlSerializer(LinkRenderer linkRenderer, Map<String, VerbatimSerializer> verbatimSerializers) {
        this(linkRenderer, verbatimSerializers, Collections.emptyList());
    }

    public ToHtmlSerializer(LinkRenderer linkRenderer, Map<String, VerbatimSerializer> verbatimSerializers, List<ToHtmlSerializerPlugin> plugins) {
        this.linkRenderer = linkRenderer;
        this.verbatimSerializers = new HashMap<String, VerbatimSerializer>(verbatimSerializers);
        if (!this.verbatimSerializers.containsKey("DEFAULT")) {
            this.verbatimSerializers.put("DEFAULT", DefaultVerbatimSerializer.INSTANCE);
        }
        this.plugins = plugins;
    }

    public String toHtml(RootNode astRoot) {
        Preconditions.checkArgNotNull(astRoot, "astRoot");
        astRoot.accept(this);
        return this.printer.getString();
    }

    @Override
    public void visit(RootNode node) {
        for (ReferenceNode refNode : node.getReferences()) {
            this.visitChildren(refNode);
            this.references.put(this.normalize(this.printer.getString()), refNode);
            this.printer.clear();
        }
        for (AbbreviationNode abbrNode : node.getAbbreviations()) {
            this.visitChildren(abbrNode);
            String abbr = this.printer.getString();
            this.printer.clear();
            abbrNode.getExpansion().accept(this);
            String expansion = this.printer.getString();
            this.abbreviations.put(abbr, expansion);
            this.printer.clear();
        }
        this.visitChildren(node);
    }

    @Override
    public void visit(AbbreviationNode node) {
    }

    @Override
    public void visit(AutoLinkNode node) {
        this.printLink(this.linkRenderer.render(node));
    }

    @Override
    public void visit(BlockQuoteNode node) {
        this.printIndentedTag(node, "blockquote");
    }

    @Override
    public void visit(BulletListNode node) {
        this.printIndentedTag(node, "ul");
    }

    @Override
    public void visit(CodeNode node) {
        this.printTag(node, "code");
    }

    @Override
    public void visit(DefinitionListNode node) {
        this.printIndentedTag(node, "dl");
    }

    @Override
    public void visit(DefinitionNode node) {
        this.printTag(node, "dd");
    }

    @Override
    public void visit(DefinitionTermNode node) {
        this.printTag(node, "dt");
    }

    @Override
    public void visit(ExpImageNode node) {
        String text = this.printChildrenToString(node);
        this.printImageTag(this.linkRenderer.render(node, text));
    }

    @Override
    public void visit(ExpLinkNode node) {
        String text = this.printChildrenToString(node);
        this.printLink(this.linkRenderer.render(node, text));
    }

    @Override
    public void visit(HeaderNode node) {
        this.printTag(node, "h" + node.getLevel());
    }

    @Override
    public void visit(HtmlBlockNode node) {
        String text = node.getText();
        if (text.length() > 0) {
            this.printer.println();
        }
        this.printer.print(text);
    }

    @Override
    public void visit(InlineHtmlNode node) {
        this.printer.print(node.getText());
    }

    @Override
    public void visit(ListItemNode node) {
        this.printer.println();
        this.printTag(node, "li");
    }

    @Override
    public void visit(MailLinkNode node) {
        this.printLink(this.linkRenderer.render(node));
    }

    @Override
    public void visit(OrderedListNode node) {
        this.printIndentedTag(node, "ol");
    }

    @Override
    public void visit(ParaNode node) {
        this.printTag(node, "p");
    }

    @Override
    public void visit(QuotedNode node) {
        switch (node.getType()) {
            case DoubleAngle: {
                this.printer.print("&laquo;");
                this.visitChildren(node);
                this.printer.print("&raquo;");
                break;
            }
            case Double: {
                this.printer.print("&ldquo;");
                this.visitChildren(node);
                this.printer.print("&rdquo;");
                break;
            }
            case Single: {
                this.printer.print("&lsquo;");
                this.visitChildren(node);
                this.printer.print("&rsquo;");
            }
        }
    }

    @Override
    public void visit(ReferenceNode node) {
    }

    @Override
    public void visit(RefImageNode node) {
        String text = this.printChildrenToString(node);
        String key = node.referenceKey != null ? this.printChildrenToString(node.referenceKey) : text;
        ReferenceNode refNode = this.references.get(this.normalize(key));
        if (refNode == null) {
            this.printer.print("![").print(text).print(']');
            if (node.separatorSpace != null) {
                this.printer.print(node.separatorSpace).print('[');
                if (node.referenceKey != null) {
                    this.printer.print(key);
                }
                this.printer.print(']');
            }
        } else {
            this.printImageTag(this.linkRenderer.render(node, refNode.getUrl(), refNode.getTitle(), text));
        }
    }

    @Override
    public void visit(RefLinkNode node) {
        String text = this.printChildrenToString(node);
        String key = node.referenceKey != null ? this.printChildrenToString(node.referenceKey) : text;
        ReferenceNode refNode = this.references.get(this.normalize(key));
        if (refNode == null) {
            this.printer.print('[').print(text).print(']');
            if (node.separatorSpace != null) {
                this.printer.print(node.separatorSpace).print('[');
                if (node.referenceKey != null) {
                    this.printer.print(key);
                }
                this.printer.print(']');
            }
        } else {
            this.printLink(this.linkRenderer.render(node, refNode.getUrl(), refNode.getTitle(), text));
        }
    }

    @Override
    public void visit(SimpleNode node) {
        switch (node.getType()) {
            case Apostrophe: {
                this.printer.print("&rsquo;");
                break;
            }
            case Ellipsis: {
                this.printer.print("&hellip;");
                break;
            }
            case Emdash: {
                this.printer.print("&mdash;");
                break;
            }
            case Endash: {
                this.printer.print("&ndash;");
                break;
            }
            case HRule: {
                this.printer.println().print("<hr/>");
                break;
            }
            case Linebreak: {
                this.printer.print("<br/>");
                break;
            }
            case Nbsp: {
                this.printer.print("&nbsp;");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void visit(StrongEmphSuperNode node) {
        if (node.isClosed()) {
            if (node.isStrong()) {
                this.printTag(node, "strong");
            } else {
                this.printTag(node, "em");
            }
        } else {
            this.printer.print(node.getChars());
            this.visitChildren(node);
        }
    }

    @Override
    public void visit(StrikeNode node) {
        this.printTag(node, "del");
    }

    @Override
    public void visit(TableBodyNode node) {
        this.printIndentedTag(node, "tbody");
    }

    @Override
    public void visit(TableCaptionNode node) {
        this.printer.println().print("<caption>");
        this.visitChildren(node);
        this.printer.print("</caption>");
    }

    @Override
    public void visit(TableCellNode node) {
        String tag = this.inTableHeader ? "th" : "td";
        List<TableColumnNode> columns = this.currentTableNode.getColumns();
        TableColumnNode column = columns.get(Math.min(this.currentTableColumn, columns.size() - 1));
        this.printer.println().print('<').print(tag);
        column.accept(this);
        if (node.getColSpan() > 1) {
            this.printer.print(" colspan=\"").print(Integer.toString(node.getColSpan())).print('\"');
        }
        this.printer.print('>');
        this.visitChildren(node);
        this.printer.print('<').print('/').print(tag).print('>');
        this.currentTableColumn += node.getColSpan();
    }

    @Override
    public void visit(TableColumnNode node) {
        switch (node.getAlignment()) {
            case None: {
                break;
            }
            case Left: {
                this.printer.print(" align=\"left\"");
                break;
            }
            case Right: {
                this.printer.print(" align=\"right\"");
                break;
            }
            case Center: {
                this.printer.print(" align=\"center\"");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void visit(TableHeaderNode node) {
        this.inTableHeader = true;
        this.printIndentedTag(node, "thead");
        this.inTableHeader = false;
    }

    @Override
    public void visit(TableNode node) {
        this.currentTableNode = node;
        this.printIndentedTag(node, "table");
        this.currentTableNode = null;
    }

    @Override
    public void visit(TableRowNode node) {
        this.currentTableColumn = 0;
        this.printIndentedTag(node, "tr");
    }

    @Override
    public void visit(VerbatimNode node) {
        VerbatimSerializer serializer = this.lookupSerializer(node.getType());
        serializer.serialize(node, this.printer);
    }

    private VerbatimSerializer lookupSerializer(String type) {
        if (type != null && this.verbatimSerializers.containsKey(type)) {
            return this.verbatimSerializers.get(type);
        }
        return this.verbatimSerializers.get("DEFAULT");
    }

    @Override
    public void visit(WikiLinkNode node) {
        this.printLink(this.linkRenderer.render(node));
    }

    @Override
    public void visit(TextNode node) {
        if (this.abbreviations.isEmpty()) {
            this.printer.print(node.getText());
        } else {
            this.printWithAbbreviations(node.getText());
        }
    }

    @Override
    public void visit(SpecialTextNode node) {
        this.printer.printEncoded(node.getText());
    }

    @Override
    public void visit(SuperNode node) {
        this.visitChildren(node);
    }

    @Override
    public void visit(Node node) {
        for (ToHtmlSerializerPlugin plugin : this.plugins) {
            if (!plugin.visit(node, this, this.printer)) continue;
            return;
        }
        throw new RuntimeException("Don't know how to handle node " + node);
    }

    protected void visitChildren(SuperNode node) {
        for (Node child : node.getChildren()) {
            child.accept(this);
        }
    }

    protected void printTag(TextNode node, String tag) {
        this.printer.print('<').print(tag).print('>');
        this.printer.printEncoded(node.getText());
        this.printer.print('<').print('/').print(tag).print('>');
    }

    protected void printTag(SuperNode node, String tag) {
        this.printer.print('<').print(tag).print('>');
        this.visitChildren(node);
        this.printer.print('<').print('/').print(tag).print('>');
    }

    protected void printIndentedTag(SuperNode node, String tag) {
        this.printer.println().print('<').print(tag).print('>').indent(2);
        this.visitChildren(node);
        this.printer.indent(-2).println().print('<').print('/').print(tag).print('>');
    }

    protected void printImageTag(LinkRenderer.Rendering rendering) {
        this.printer.print("<img");
        this.printAttribute("src", rendering.href);
        this.printAttribute("alt", rendering.text);
        for (LinkRenderer.Attribute attr : rendering.attributes) {
            this.printAttribute(attr.name, attr.value);
        }
        this.printer.print("\"/>");
    }

    protected void printLink(LinkRenderer.Rendering rendering) {
        this.printer.print('<').print('a');
        this.printAttribute("href", rendering.href);
        for (LinkRenderer.Attribute attr : rendering.attributes) {
            this.printAttribute(attr.name, attr.value);
        }
        this.printer.print('>').print(rendering.text).print("</a>");
    }

    private void printAttribute(String name, String value) {
        this.printer.print(' ').print(name).print('=').print('\"').print(value).print('\"');
    }

    protected String printChildrenToString(SuperNode node) {
        Printer priorPrinter = this.printer;
        this.printer = new Printer();
        this.visitChildren(node);
        String result = this.printer.getString();
        this.printer = priorPrinter;
        return result;
    }

    protected String normalize(String string) {
        StringBuilder sb = new StringBuilder();
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': {
                    continue block3;
                }
                default: {
                    sb.append(Character.toLowerCase(c));
                }
            }
        }
        return sb.toString();
    }

    protected void printWithAbbreviations(String string) {
        TreeMap<Integer, Map.Entry<String, String>> expansions = null;
        for (Map.Entry<String, String> entry : this.abbreviations.entrySet()) {
            int sx;
            String abbr = entry.getKey();
            int ix = 0;
            while ((sx = string.indexOf(abbr, ix)) != -1) {
                ix = sx + abbr.length();
                if (sx > 0 && Character.isLetterOrDigit(string.charAt(sx - 1)) || ix < string.length() && Character.isLetterOrDigit(string.charAt(ix))) continue;
                if (expansions == null) {
                    expansions = new TreeMap<Integer, Map.Entry<String, String>>();
                }
                expansions.put(sx, entry);
            }
        }
        if (expansions != null) {
            int ix = 0;
            for (Map.Entry entry : expansions.entrySet()) {
                int sx = (Integer)entry.getKey();
                String abbr = (String)((Map.Entry)entry.getValue()).getKey();
                String expansion = (String)((Map.Entry)entry.getValue()).getValue();
                this.printer.printEncoded(string.substring(ix, sx));
                this.printer.print("<abbr");
                if (StringUtils.isNotEmpty(expansion)) {
                    this.printer.print(" title=\"");
                    this.printer.printEncoded(expansion);
                    this.printer.print('\"');
                }
                this.printer.print('>');
                this.printer.printEncoded(abbr);
                this.printer.print("</abbr>");
                ix = sx + abbr.length();
            }
            this.printer.print(string.substring(ix));
        } else {
            this.printer.print(string);
        }
    }
}

