/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.hv;

import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.constraints.SafeHtml;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Parser;
import org.jsoup.safety.Cleaner;
import org.jsoup.safety.Whitelist;

@Deprecated
public class SafeHtmlValidator
implements ConstraintValidator<SafeHtml, CharSequence> {
    private Whitelist whitelist;
    private String baseURI;

    @Override
    public void initialize(SafeHtml safeHtmlAnnotation) {
        switch (safeHtmlAnnotation.whitelistType()) {
            case BASIC: {
                this.whitelist = Whitelist.basic();
                break;
            }
            case BASIC_WITH_IMAGES: {
                this.whitelist = Whitelist.basicWithImages();
                break;
            }
            case NONE: {
                this.whitelist = Whitelist.none();
                break;
            }
            case RELAXED: {
                this.whitelist = Whitelist.relaxed();
                break;
            }
            case SIMPLE_TEXT: {
                this.whitelist = Whitelist.simpleText();
            }
        }
        this.baseURI = safeHtmlAnnotation.baseURI();
        this.whitelist.addTags(safeHtmlAnnotation.additionalTags());
        for (SafeHtml.Tag tag : safeHtmlAnnotation.additionalTagsWithAttributes()) {
            this.whitelist.addTags(tag.name());
            if (tag.attributes().length > 0) {
                this.whitelist.addAttributes(tag.name(), tag.attributes());
            }
            for (SafeHtml.Attribute attribute : tag.attributesWithProtocols()) {
                this.whitelist.addAttributes(tag.name(), attribute.name());
                if (attribute.protocols().length <= 0) continue;
                this.whitelist.addProtocols(tag.name(), attribute.name(), attribute.protocols());
            }
        }
    }

    @Override
    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        return new Cleaner(this.whitelist).isValid(this.getFragmentAsDocument(value));
    }

    private Document getFragmentAsDocument(CharSequence value) {
        Document fragment = Jsoup.parse(value.toString(), this.baseURI, Parser.xmlParser());
        Document document = Document.createShell(this.baseURI);
        List<Node> childNodes = fragment.childNodes();
        for (Node node : childNodes) {
            document.body().appendChild(node.clone());
        }
        return document;
    }
}

