/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.message.DbException;
import org.h2.result.LazyResult;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.ColumnNamer;
import org.h2.value.Value;

public class SelectUnion
extends Query {
    private final UnionType unionType;
    final Query left;
    final Query right;
    private boolean isPrepared;
    private boolean checkInit;
    private boolean isForUpdate;

    public SelectUnion(Session session, UnionType unionType, Query query2, Query query3) {
        super(session);
        this.unionType = unionType;
        this.left = query2;
        this.right = query3;
    }

    @Override
    public boolean isUnion() {
        return true;
    }

    @Override
    public void prepareJoinBatch() {
        this.left.prepareJoinBatch();
        this.right.prepareJoinBatch();
    }

    public UnionType getUnionType() {
        return this.unionType;
    }

    public Query getLeft() {
        return this.left;
    }

    public Query getRight() {
        return this.right;
    }

    private Value[] convert(Value[] valueArray, int n) {
        Value[] valueArray2 = n == valueArray.length ? valueArray : new Value[n];
        for (int i = 0; i < n; ++i) {
            Expression expression = (Expression)this.expressions.get(i);
            valueArray2[i] = valueArray[i].convertTo(expression.getType(), this.session, false, null);
        }
        return valueArray2;
    }

    public LocalResult getEmptyResult() {
        int n = this.left.getColumnCount();
        return this.createLocalResult(n);
    }

    @Override
    protected ResultInterface queryWithoutCache(int n, ResultTarget resultTarget) {
        Query.OffsetFetch offsetFetch = this.getOffsetFetch(n);
        long l = offsetFetch.offset;
        int n2 = offsetFetch.fetch;
        boolean bl = offsetFetch.fetchPercent;
        Database database = this.session.getDatabase();
        if (database.getSettings().optimizeInsertFromSelect && this.unionType == UnionType.UNION_ALL && resultTarget != null && this.sort == null && !this.distinct && n2 < 0 && l == 0L) {
            this.left.query(0, resultTarget);
            this.right.query(0, resultTarget);
            return null;
        }
        int n3 = this.left.getColumnCount();
        if (!(!this.session.isLazyQueryExecution() || this.unionType != UnionType.UNION_ALL || this.distinct || this.sort != null || this.randomAccessResult || this.isForUpdate || l != 0L || bl || this.withTies || !this.isReadOnly() || n2 == 0)) {
            LazyResultUnion lazyResultUnion = new LazyResultUnion(this.expressionArray, n3);
            if (n2 > 0) {
                lazyResultUnion.setLimit(n2);
            }
            return lazyResultUnion;
        }
        LocalResult localResult = this.createLocalResult(n3);
        if (this.sort != null) {
            localResult.setSortOrder(this.sort);
        }
        if (this.distinct) {
            this.left.setDistinctIfPossible();
            this.right.setDistinctIfPossible();
            localResult.setDistinct();
        }
        switch (this.unionType) {
            case UNION: 
            case EXCEPT: {
                this.left.setDistinctIfPossible();
                this.right.setDistinctIfPossible();
                localResult.setDistinct();
                break;
            }
            case UNION_ALL: {
                break;
            }
            case INTERSECT: {
                this.left.setDistinctIfPossible();
                this.right.setDistinctIfPossible();
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
        ResultInterface resultInterface = this.left.query(0);
        ResultInterface resultInterface2 = this.right.query(0);
        resultInterface.reset();
        resultInterface2.reset();
        switch (this.unionType) {
            case UNION: 
            case UNION_ALL: {
                while (resultInterface.next()) {
                    localResult.addRow(this.convert(resultInterface.currentRow(), n3));
                }
                while (resultInterface2.next()) {
                    localResult.addRow(this.convert(resultInterface2.currentRow(), n3));
                }
                break;
            }
            case EXCEPT: {
                while (resultInterface.next()) {
                    localResult.addRow(this.convert(resultInterface.currentRow(), n3));
                }
                while (resultInterface2.next()) {
                    localResult.removeDistinct(this.convert(resultInterface2.currentRow(), n3));
                }
                break;
            }
            case INTERSECT: {
                LocalResult localResult2 = this.createLocalResult(n3);
                localResult2.setDistinct();
                while (resultInterface.next()) {
                    localResult2.addRow(this.convert(resultInterface.currentRow(), n3));
                }
                while (resultInterface2.next()) {
                    Value[] valueArray = this.convert(resultInterface2.currentRow(), n3);
                    if (!localResult2.containsDistinct(valueArray)) continue;
                    localResult.addRow(valueArray);
                }
                localResult2.close();
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
        resultInterface.close();
        resultInterface2.close();
        return this.finishResult(localResult, l, n2, bl, resultTarget);
    }

    private LocalResult createLocalResult(int n) {
        return this.session.getDatabase().getResultFactory().create(this.session, this.expressionArray, n, n);
    }

    @Override
    public void init() {
        if (this.checkInit) {
            DbException.throwInternalError();
        }
        this.checkInit = true;
        this.left.init();
        this.right.init();
        int n = this.left.getColumnCount();
        if (n != this.right.getColumnCount()) {
            throw DbException.get(21002);
        }
        ArrayList<Expression> arrayList = this.left.getExpressions();
        this.expressions = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Expression expression = arrayList.get(i);
            this.expressions.add(expression);
        }
        this.visibleColumnCount = n;
        if (this.withTies && !this.hasOrder()) {
            throw DbException.get(90122);
        }
    }

    @Override
    public void prepare() {
        if (this.isPrepared) {
            return;
        }
        if (!this.checkInit) {
            DbException.throwInternalError("not initialized");
        }
        this.isPrepared = true;
        this.left.prepare();
        this.right.prepare();
        int n = this.left.getColumnCount();
        this.expressions = new ArrayList(n);
        ArrayList<Expression> arrayList = this.left.getExpressions();
        ArrayList<Expression> arrayList2 = this.right.getExpressions();
        ColumnNamer columnNamer = new ColumnNamer(this.session);
        for (int i = 0; i < n; ++i) {
            Expression expression = arrayList.get(i);
            Expression expression2 = arrayList2.get(i);
            String string = columnNamer.getColumnName(expression, i, expression.getAlias());
            Column column = new Column(string, Value.getHigherType(expression.getType(), expression2.getType()));
            ExpressionColumn expressionColumn = new ExpressionColumn(this.session.getDatabase(), column);
            this.expressions.add(expressionColumn);
        }
        if (this.orderList != null) {
            SelectUnion.initOrder(this.session, this.expressions, null, this.orderList, this.getColumnCount(), true, null);
            this.sort = this.prepareOrder(this.orderList, this.expressions.size());
            this.orderList = null;
        }
        this.resultColumnCount = this.expressions.size();
        this.expressionArray = this.expressions.toArray(new Expression[0]);
    }

    @Override
    public double getCost() {
        return this.left.getCost() + this.right.getCost();
    }

    @Override
    public HashSet<Table> getTables() {
        HashSet<Table> hashSet = this.left.getTables();
        hashSet.addAll(this.right.getTables());
        return hashSet;
    }

    @Override
    public void setForUpdate(boolean bl) {
        this.left.setForUpdate(bl);
        this.right.setForUpdate(bl);
        this.isForUpdate = bl;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.left.mapColumns(columnResolver, n);
        this.right.mapColumns(columnResolver, n);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.right.setEvaluatable(tableFilter, bl);
    }

    @Override
    public void addGlobalCondition(Parameter parameter, int n, int n2) {
        this.addParameter(parameter);
        switch (this.unionType) {
            case UNION: 
            case UNION_ALL: 
            case INTERSECT: {
                this.left.addGlobalCondition(parameter, n, n2);
                this.right.addGlobalCondition(parameter, n, n2);
                break;
            }
            case EXCEPT: {
                this.left.addGlobalCondition(parameter, n, n2);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
    }

    @Override
    public String getPlanSQL(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(').append(this.left.getPlanSQL(bl)).append(')');
        switch (this.unionType) {
            case UNION_ALL: {
                stringBuilder.append("\nUNION ALL\n");
                break;
            }
            case UNION: {
                stringBuilder.append("\nUNION\n");
                break;
            }
            case INTERSECT: {
                stringBuilder.append("\nINTERSECT\n");
                break;
            }
            case EXCEPT: {
                stringBuilder.append("\nEXCEPT\n");
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
        stringBuilder.append('(').append(this.right.getPlanSQL(bl)).append(')');
        this.appendEndOfQueryToSQL(stringBuilder, bl, this.expressions.toArray(new Expression[0]));
        if (this.sampleSizeExpr != null) {
            stringBuilder.append("\nSAMPLE_SIZE ");
            this.sampleSizeExpr.getUnenclosedSQL(stringBuilder, bl);
        }
        if (this.isForUpdate) {
            stringBuilder.append("\nFOR UPDATE");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor);
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.left.updateAggregate(session, n);
        this.right.updateAggregate(session, n);
    }

    @Override
    public void fireBeforeSelectTriggers() {
        this.left.fireBeforeSelectTriggers();
        this.right.fireBeforeSelectTriggers();
    }

    @Override
    public boolean allowGlobalConditions() {
        return this.left.allowGlobalConditions() && this.right.allowGlobalConditions();
    }

    private final class LazyResultUnion
    extends LazyResult {
        int columnCount;
        ResultInterface l;
        ResultInterface r;
        boolean leftDone;
        boolean rightDone;

        LazyResultUnion(Expression[] expressionArray, int n) {
            super(expressionArray);
            this.columnCount = n;
        }

        @Override
        public int getVisibleColumnCount() {
            return this.columnCount;
        }

        @Override
        protected Value[] fetchNextRow() {
            if (this.rightDone) {
                return null;
            }
            if (!this.leftDone) {
                if (this.l == null) {
                    this.l = SelectUnion.this.left.query(0);
                    this.l.reset();
                }
                if (this.l.next()) {
                    return this.l.currentRow();
                }
                this.leftDone = true;
            }
            if (this.r == null) {
                this.r = SelectUnion.this.right.query(0);
                this.r.reset();
            }
            if (this.r.next()) {
                return this.r.currentRow();
            }
            this.rightDone = true;
            return null;
        }

        @Override
        public void close() {
            super.close();
            if (this.l != null) {
                this.l.close();
            }
            if (this.r != null) {
                this.r.close();
            }
        }

        @Override
        public void reset() {
            super.reset();
            if (this.l != null) {
                this.l.reset();
            }
            if (this.r != null) {
                this.r.reset();
            }
            this.leftDone = false;
            this.rightDone = false;
        }
    }

    public static enum UnionType {
        UNION,
        UNION_ALL,
        EXCEPT,
        INTERSECT;

    }
}

