/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.h2.command.Prepared;
import org.h2.command.dml.SelectOrderBy;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.expression.Alias;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.expression.function.FunctionCall;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.SortOrder;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableView;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;

public abstract class Query
extends Prepared {
    ArrayList<Expression> expressions;
    Expression[] expressionArray;
    ArrayList<SelectOrderBy> orderList;
    SortOrder sort;
    Expression limitExpr;
    boolean fetchPercent;
    boolean withTies;
    Expression offsetExpr;
    Expression sampleSizeExpr;
    boolean distinct;
    boolean randomAccessResult;
    int visibleColumnCount;
    int resultColumnCount;
    private boolean noCache;
    private int lastLimit;
    private long lastEvaluated;
    private ResultInterface lastResult;
    private Value[] lastParameters;
    private boolean cacheableChecked;
    private boolean neverLazy;

    Query(Session session) {
        super(session);
    }

    public void setNeverLazy(boolean bl) {
        this.neverLazy = bl;
    }

    public boolean isNeverLazy() {
        return this.neverLazy;
    }

    public abstract boolean isUnion();

    public abstract void prepareJoinBatch();

    @Override
    public ResultInterface queryMeta() {
        LocalResult localResult = this.session.getDatabase().getResultFactory().create(this.session, this.expressionArray, this.visibleColumnCount, this.resultColumnCount);
        localResult.done();
        return localResult;
    }

    protected abstract ResultInterface queryWithoutCache(int var1, ResultTarget var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultInterface queryWithoutCacheLazyCheck(int n, ResultTarget resultTarget) {
        boolean bl;
        boolean bl2 = bl = this.neverLazy && this.session.isLazyQueryExecution();
        if (bl) {
            this.session.setLazyQueryExecution(false);
        }
        try {
            ResultInterface resultInterface = this.queryWithoutCache(n, resultTarget);
            return resultInterface;
        }
        finally {
            if (bl) {
                this.session.setLazyQueryExecution(true);
            }
        }
    }

    public abstract void init();

    public ArrayList<Expression> getExpressions() {
        return this.expressions;
    }

    public abstract double getCost();

    public int getCostAsExpression() {
        return (int)Math.min(1000000.0, 10.0 + 10.0 * this.getCost());
    }

    public abstract HashSet<Table> getTables();

    public void setOrder(ArrayList<SelectOrderBy> arrayList) {
        this.orderList = arrayList;
    }

    public boolean hasOrder() {
        return this.orderList != null || this.sort != null;
    }

    public abstract void setForUpdate(boolean var1);

    public int getColumnCount() {
        return this.visibleColumnCount;
    }

    public abstract void mapColumns(ColumnResolver var1, int var2);

    public abstract void setEvaluatable(TableFilter var1, boolean var2);

    public abstract void addGlobalCondition(Parameter var1, int var2, int var3);

    public abstract boolean allowGlobalConditions();

    public abstract boolean isEverything(ExpressionVisitor var1);

    @Override
    public boolean isReadOnly() {
        return this.isEverything(ExpressionVisitor.READONLY_VISITOR);
    }

    public abstract void updateAggregate(Session var1, int var2);

    public abstract void fireBeforeSelectTriggers();

    public void setDistinctIfPossible() {
        if (!this.isAnyDistinct() && this.offsetExpr == null && this.limitExpr == null) {
            this.distinct = true;
        }
    }

    public boolean isStandardDistinct() {
        return this.distinct;
    }

    public boolean isAnyDistinct() {
        return this.distinct;
    }

    public boolean isRandomAccessResult() {
        return this.randomAccessResult;
    }

    public void setRandomAccessResult(boolean bl) {
        this.randomAccessResult = bl;
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public void disableCache() {
        this.noCache = true;
    }

    private boolean sameResultAsLast(Session session, Value[] valueArray, Value[] valueArray2, long l) {
        if (!this.cacheableChecked) {
            long l2 = this.getMaxDataModificationId();
            boolean bl = this.noCache = l2 == Long.MAX_VALUE;
            if (!this.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) || !this.isEverything(ExpressionVisitor.INDEPENDENT_VISITOR)) {
                this.noCache = true;
            }
            this.cacheableChecked = true;
        }
        if (this.noCache) {
            return false;
        }
        Database database = session.getDatabase();
        for (int i = 0; i < valueArray.length; ++i) {
            Value value = valueArray2[i];
            Value value2 = valueArray[i];
            if (value.getValueType() == value2.getValueType() && database.areEqual(value, value2)) continue;
            return false;
        }
        return this.getMaxDataModificationId() <= l;
    }

    private Value[] getParameterValues() {
        ArrayList<Parameter> arrayList = this.getParameters();
        if (arrayList == null) {
            return new Value[0];
        }
        int n = arrayList.size();
        Value[] valueArray = new Value[n];
        for (int i = 0; i < n; ++i) {
            Value value;
            valueArray[i] = value = arrayList.get(i).getParamValue();
        }
        return valueArray;
    }

    @Override
    public final ResultInterface query(int n) {
        return this.query(n, null);
    }

    public final ResultInterface query(int n, ResultTarget resultTarget) {
        ResultInterface resultInterface;
        if (this.isUnion()) {
            return this.queryWithoutCacheLazyCheck(n, resultTarget);
        }
        this.fireBeforeSelectTriggers();
        if (this.noCache || !this.session.getDatabase().getOptimizeReuseResults() || this.session.isLazyQueryExecution() && !this.neverLazy) {
            return this.queryWithoutCacheLazyCheck(n, resultTarget);
        }
        Value[] valueArray = this.getParameterValues();
        long l = this.session.getDatabase().getModificationDataId();
        if (this.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) && this.lastResult != null && !this.lastResult.isClosed() && n == this.lastLimit && this.sameResultAsLast(this.session, valueArray, this.lastParameters, this.lastEvaluated)) {
            this.lastResult = this.lastResult.createShallowCopy(this.session);
            if (this.lastResult != null) {
                this.lastResult.reset();
                return this.lastResult;
            }
        }
        this.lastParameters = valueArray;
        this.closeLastResult();
        this.lastResult = resultInterface = this.queryWithoutCacheLazyCheck(n, resultTarget);
        this.lastEvaluated = l;
        this.lastLimit = n;
        return resultInterface;
    }

    private void closeLastResult() {
        if (this.lastResult != null) {
            this.lastResult.close();
        }
    }

    static void initOrder(Session session, ArrayList<Expression> arrayList, ArrayList<String> arrayList2, List<SelectOrderBy> list, int n, boolean bl, ArrayList<TableFilter> arrayList3) {
        for (SelectOrderBy selectOrderBy : list) {
            Expression expression = selectOrderBy.expression;
            if (expression == null) continue;
            int n2 = Query.initExpression(session, arrayList, arrayList2, expression, n, bl, arrayList3);
            selectOrderBy.columnIndexExpr = ValueExpression.get(ValueInt.get(n2 + 1));
            selectOrderBy.expression = arrayList.get(n2).getNonAliasExpression();
        }
    }

    static int initExpression(Session session, ArrayList<Expression> arrayList, ArrayList<String> arrayList2, Expression expression, int n, boolean bl, ArrayList<TableFilter> arrayList3) {
        Object object;
        Database database = session.getDatabase();
        if (expression instanceof ExpressionColumn) {
            object = (ExpressionColumn)expression;
            String string = ((ExpressionColumn)object).getOriginalTableAliasName();
            String string2 = ((ExpressionColumn)object).getOriginalColumnName();
            for (int i = 0; i < n; ++i) {
                Object object3;
                Expression expression2;
                Expression expression3 = arrayList.get(i);
                if (expression3 instanceof ExpressionColumn) {
                    expression2 = (ExpressionColumn)expression3;
                    if (!database.equalsIdentifiers(string2, ((ExpressionColumn)expression2).getColumnName())) continue;
                    if (string == null) {
                        return i;
                    }
                    object3 = ((ExpressionColumn)expression2).getOriginalTableAliasName();
                    if (object3 != null) {
                        if (!database.equalsIdentifiers((String)object3, string)) continue;
                        return i;
                    }
                    if (arrayList3 == null) continue;
                    for (TableFilter tableFilter : arrayList3) {
                        if (!database.equalsIdentifiers(tableFilter.getTableAlias(), string)) continue;
                        return i;
                    }
                    continue;
                }
                if (!(expression3 instanceof Alias)) continue;
                if (string == null && database.equalsIdentifiers(string2, expression3.getAlias())) {
                    return i;
                }
                expression2 = expression3.getNonAliasExpression();
                if (!(expression2 instanceof ExpressionColumn)) continue;
                object3 = (ExpressionColumn)expression2;
                String string3 = ((Expression)object).getSQL(true);
                String string4 = ((Expression)object3).getSQL(true);
                String string5 = ((ExpressionColumn)object3).getColumnName();
                if (!database.equalsIdentifiers(string2, string5) || !database.equalsIdentifiers(string3, string4)) continue;
                return i;
            }
        } else if (arrayList2 != null) {
            object = expression.getSQL(true);
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                if (!database.equalsIdentifiers(arrayList2.get(i), (String)object)) continue;
                return i;
            }
        }
        if (arrayList2 == null || bl && !database.getMode().allowUnrelatedOrderByExpressionsInDistinctQueries && !Query.checkOrderOther(session, expression, arrayList2)) {
            throw DbException.get(90068, expression.getSQL(false));
        }
        int n3 = arrayList.size();
        arrayList.add(expression);
        arrayList2.add(expression.getSQL(true));
        return n3;
    }

    private static boolean checkOrderOther(Session session, Expression expression, ArrayList<String> arrayList) {
        if (expression == null || expression.isConstant()) {
            return true;
        }
        String string = expression.getSQL(true);
        for (String string2 : arrayList) {
            if (!session.getDatabase().equalsIdentifiers(string, string2)) continue;
            return true;
        }
        int n = expression.getSubexpressionCount();
        if (expression instanceof FunctionCall ? !((FunctionCall)((Object)expression)).isDeterministic() : n <= 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Query.checkOrderOther(session, expression.getSubexpression(i), arrayList)) continue;
            return false;
        }
        return true;
    }

    public SortOrder prepareOrder(ArrayList<SelectOrderBy> arrayList, int n) {
        int n2 = arrayList.size();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n3;
            SelectOrderBy selectOrderBy = arrayList.get(i);
            boolean bl = false;
            Value value = selectOrderBy.columnIndexExpr.getValue(null);
            if (value == ValueNull.INSTANCE) {
                n3 = 0;
            } else {
                n3 = value.getInt();
                if (n3 < 0) {
                    bl = true;
                    n3 = -n3;
                }
                if (--n3 < 0 || n3 >= n) {
                    throw DbException.get(90068, Integer.toString(n3 + 1));
                }
            }
            nArray[i] = n3;
            int n4 = selectOrderBy.sortType;
            if (bl) {
                n4 ^= 1;
            }
            nArray2[i] = n4;
        }
        return new SortOrder(this.session.getDatabase(), nArray, nArray2, arrayList);
    }

    @Override
    public int getType() {
        return 66;
    }

    public void setOffset(Expression expression) {
        this.offsetExpr = expression;
    }

    public Expression getOffset() {
        return this.offsetExpr;
    }

    public void setLimit(Expression expression) {
        this.limitExpr = expression;
    }

    public Expression getLimit() {
        return this.limitExpr;
    }

    public void setFetchPercent(boolean bl) {
        this.fetchPercent = bl;
    }

    public boolean isFetchPercent() {
        return this.fetchPercent;
    }

    public void setWithTies(boolean bl) {
        this.withTies = bl;
    }

    public boolean isWithTies() {
        return this.withTies;
    }

    void addParameter(Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = Utils.newSmallArrayList();
        }
        this.parameters.add(parameter);
    }

    public void setSampleSize(Expression expression) {
        this.sampleSizeExpr = expression;
    }

    int getSampleSizeValue(Session session) {
        if (this.sampleSizeExpr == null) {
            return 0;
        }
        Value value = this.sampleSizeExpr.optimize(session).getValue(session);
        if (value == ValueNull.INSTANCE) {
            return 0;
        }
        return value.getInt();
    }

    public final long getMaxDataModificationId() {
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getMaxModificationIdVisitor();
        this.isEverything(expressionVisitor);
        return Math.max(expressionVisitor.getMaxDataModificationId(), this.session.getSnapshotDataModificationId());
    }

    void appendEndOfQueryToSQL(StringBuilder stringBuilder, boolean bl, Expression[] expressionArray) {
        int n;
        if (this.sort != null) {
            stringBuilder.append("\nORDER BY ").append(this.sort.getSQL(expressionArray, this.visibleColumnCount, bl));
        } else if (this.orderList != null) {
            stringBuilder.append("\nORDER BY ");
            n = this.orderList.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                this.orderList.get(i).getSQL(stringBuilder, bl);
            }
        }
        if (this.offsetExpr != null) {
            String string = StringUtils.unEnclose(this.offsetExpr.getSQL(bl));
            stringBuilder.append("\nOFFSET ").append(string).append("1".equals(string) ? " ROW" : " ROWS");
        }
        if (this.limitExpr != null) {
            stringBuilder.append("\nFETCH ").append(this.offsetExpr != null ? "NEXT" : "FIRST");
            String string = StringUtils.unEnclose(this.limitExpr.getSQL(bl));
            int n2 = n = this.fetchPercent || !"1".equals(string) ? 1 : 0;
            if (n != 0) {
                stringBuilder.append(' ').append(string);
                if (this.fetchPercent) {
                    stringBuilder.append(" PERCENT");
                }
            }
            stringBuilder.append(n == 0 ? " ROW" : " ROWS").append(this.withTies ? " WITH TIES" : " ONLY");
        }
    }

    OffsetFetch getOffsetFetch(int n) {
        long l;
        boolean bl;
        int n2;
        int n3 = n2 = n == 0 ? -1 : n;
        if (this.limitExpr != null) {
            int n4;
            Value value = this.limitExpr.getValue(this.session);
            int n5 = n4 = value == ValueNull.INSTANCE ? -1 : value.getInt();
            if (n2 < 0) {
                n2 = n4;
            } else if (n4 >= 0) {
                n2 = Math.min(n4, n2);
            }
        }
        if (bl = this.fetchPercent) {
            if (n2 < 0 || n2 > 100) {
                throw DbException.getInvalidValueException("FETCH PERCENT", n2);
            }
            if (n2 == 0) {
                bl = false;
            }
        }
        if (this.offsetExpr != null) {
            l = this.offsetExpr.getValue(this.session).getLong();
            if (l < 0L) {
                l = 0L;
            }
        } else {
            l = 0L;
        }
        return new OffsetFetch(l, n2, bl);
    }

    LocalResult finishResult(LocalResult localResult, long l, int n, boolean bl, ResultTarget resultTarget) {
        if (l != 0L) {
            if (l > Integer.MAX_VALUE) {
                throw DbException.getInvalidValueException("OFFSET", l);
            }
            localResult.setOffset((int)l);
        }
        if (n >= 0) {
            localResult.setLimit(n);
            localResult.setFetchPercent(bl);
            if (this.withTies) {
                localResult.setWithTies(this.sort);
            }
        }
        localResult.done();
        if (this.randomAccessResult && !this.distinct) {
            localResult = this.convertToDistinct(localResult);
        }
        if (resultTarget != null) {
            while (localResult.next()) {
                resultTarget.addRow(localResult.currentRow());
            }
            localResult.close();
            return null;
        }
        return localResult;
    }

    LocalResult convertToDistinct(ResultInterface resultInterface) {
        LocalResult localResult = this.session.getDatabase().getResultFactory().create(this.session, this.expressionArray, this.visibleColumnCount, this.resultColumnCount);
        localResult.setDistinct();
        resultInterface.reset();
        while (resultInterface.next()) {
            localResult.addRow(resultInterface.currentRow());
        }
        resultInterface.close();
        localResult.done();
        return localResult;
    }

    public Table toTable(String string, ArrayList<Parameter> arrayList, boolean bl, Query query2) {
        this.setParameterList(new ArrayList<Parameter>(arrayList));
        this.init();
        return TableView.createTempView(bl ? this.session.getDatabase().getSystemSession() : this.session, this.session.getUser(), string, this, query2);
    }

    @Override
    public void collectDependencies(HashSet<DbObject> hashSet) {
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getDependenciesVisitor(hashSet);
        this.isEverything(expressionVisitor);
    }

    static final class OffsetFetch {
        final long offset;
        final int fetch;
        final boolean fetchPercent;

        OffsetFetch(long l, int n, boolean bl) {
            this.offset = l;
            this.fetch = n;
            this.fetchPercent = bl;
        }
    }
}

