/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.command.Prepared;
import org.h2.command.dml.DataChangeStatement;
import org.h2.command.dml.Delete;
import org.h2.command.dml.Insert;
import org.h2.command.dml.Query;
import org.h2.command.dml.Select;
import org.h2.command.dml.Update;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.condition.ConditionAndOr;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.result.RowImpl;
import org.h2.table.DataChangeDeltaTable;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.Utils;
import org.h2.value.Value;

public class MergeUsing
extends Prepared
implements DataChangeStatement {
    Table targetTable;
    TableFilter targetTableFilter;
    private Query query;
    TableFilter sourceTableFilter;
    Expression onCondition;
    private ArrayList<When> when = Utils.newSmallArrayList();
    private String queryAlias;
    private int countUpdatedRows;
    private Select targetMatchQuery;
    private final HashMap<Value, Integer> targetRowidsRemembered = new HashMap();
    private int sourceQueryRowNumber;

    public MergeUsing(Session session, TableFilter tableFilter) {
        super(session);
        this.targetTable = tableFilter.getTable();
        this.targetTableFilter = tableFilter;
    }

    @Override
    public void setDeltaChangeCollector(ResultTarget resultTarget, DataChangeDeltaTable.ResultOption resultOption) {
        for (When when : this.when) {
            when.setDeltaChangeCollector(resultTarget, resultOption);
        }
    }

    @Override
    public int update() {
        this.countUpdatedRows = 0;
        this.targetRowidsRemembered.clear();
        this.targetTableFilter.startQuery(this.session);
        this.targetTableFilter.reset();
        this.sourceTableFilter.startQuery(this.session);
        this.sourceTableFilter.reset();
        this.sourceQueryRowNumber = 0;
        this.checkRights();
        this.setCurrentRowNumber(0L);
        for (When valueArray : this.when) {
            valueArray.reset();
        }
        ResultInterface resultInterface = this.query.query(0);
        this.targetTable.fire(this.session, this.evaluateTriggerMasks(), true);
        this.targetTable.lock(this.session, true, false);
        while (resultInterface.next()) {
            ++this.sourceQueryRowNumber;
            Value[] valueArray = resultInterface.currentRow();
            RowImpl rowImpl = new RowImpl(valueArray, 0);
            this.setCurrentRowNumber(this.sourceQueryRowNumber);
            this.merge(rowImpl);
        }
        resultInterface.close();
        this.targetTable.fire(this.session, this.evaluateTriggerMasks(), false);
        return this.countUpdatedRows;
    }

    private int evaluateTriggerMasks() {
        int n = 0;
        for (When when : this.when) {
            n |= when.evaluateTriggerMasks();
        }
        return n;
    }

    private void checkRights() {
        for (When when : this.when) {
            when.checkRights();
        }
        this.session.getUser().checkRight(this.targetTable, 1);
        this.session.getUser().checkRight(this.sourceTableFilter.getTable(), 1);
    }

    protected void merge(Row row) {
        this.sourceTableFilter.set(row);
        boolean bl = this.isTargetRowFound();
        for (When when : this.when) {
            if (!(when.getClass() == WhenNotMatched.class ^ bl)) continue;
            this.countUpdatedRows += when.merge();
        }
    }

    private boolean isTargetRowFound() {
        boolean bl = false;
        try (ResultInterface resultInterface = this.targetMatchQuery.query(0);){
            while (resultInterface.next()) {
                Value value = resultInterface.currentRow()[0];
                Integer n = this.targetRowidsRemembered.get(value);
                if (n != null) {
                    throw DbException.get(23505, "Merge using ON column expression, duplicate _ROWID_ target record already updated, deleted or inserted:_ROWID_=" + value + ":in:" + this.targetTableFilter.getTable() + ":conflicting source row number:" + n);
                }
                this.targetRowidsRemembered.put(value, this.sourceQueryRowNumber);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public String getPlanSQL(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("MERGE INTO ");
        this.targetTable.getSQL(stringBuilder, bl).append('\n').append("USING ").append(this.query.getPlanSQL(bl));
        return stringBuilder.toString();
    }

    @Override
    public void prepare() {
        this.onCondition.addFilterConditions(this.sourceTableFilter);
        this.onCondition.addFilterConditions(this.targetTableFilter);
        this.onCondition.mapColumns(this.sourceTableFilter, 2, 0);
        this.onCondition.mapColumns(this.targetTableFilter, 1, 0);
        this.onCondition = this.onCondition.optimize(this.session);
        this.onCondition.createIndexConditions(this.session, this.sourceTableFilter);
        this.onCondition.createIndexConditions(this.session, this.targetTableFilter);
        this.query.prepare();
        this.targetTableFilter.doneWithIndexConditions();
        boolean bl = false;
        for (When when : this.when) {
            when.prepare();
            if (!(when instanceof WhenNotMatched)) continue;
            bl = true;
        }
        this.targetMatchQuery = new Select(this.session, null);
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(new ExpressionColumn(this.session.getDatabase(), this.targetTableFilter.getSchemaName(), this.targetTableFilter.getTableAlias(), "_ROWID_", true));
        this.targetMatchQuery.setExpressions(arrayList);
        this.targetMatchQuery.addTableFilter(this.targetTableFilter, true);
        this.targetMatchQuery.addCondition(this.onCondition);
        this.targetMatchQuery.setForUpdate(bl);
        this.targetMatchQuery.init();
        this.targetMatchQuery.prepare();
    }

    public void setSourceTableFilter(TableFilter tableFilter) {
        this.sourceTableFilter = tableFilter;
    }

    public TableFilter getSourceTableFilter() {
        return this.sourceTableFilter;
    }

    public void setOnCondition(Expression expression) {
        this.onCondition = expression;
    }

    public Expression getOnCondition() {
        return this.onCondition;
    }

    public ArrayList<When> getWhen() {
        return this.when;
    }

    public void addWhen(When when) {
        this.when.add(when);
    }

    public void setQueryAlias(String string) {
        this.queryAlias = string;
    }

    public String getQueryAlias() {
        return this.queryAlias;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query2) {
        this.query = query2;
    }

    @Override
    public Table getTable() {
        return this.targetTableFilter.getTable();
    }

    public void setTargetTableFilter(TableFilter tableFilter) {
        this.targetTableFilter = tableFilter;
    }

    public TableFilter getTargetTableFilter() {
        return this.targetTableFilter;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(Table table) {
        this.targetTable = table;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 62;
    }

    @Override
    public String getStatementName() {
        return "MERGE";
    }

    public boolean hasCombinedMatchedClause() {
        for (When when : this.when) {
            if (!(when instanceof WhenMatched)) continue;
            WhenMatched whenMatched = (WhenMatched)when;
            if (whenMatched.updateCommand == null || whenMatched.deleteCommand == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void collectDependencies(HashSet<DbObject> hashSet) {
        for (When when : this.when) {
            when.collectDependencies(hashSet);
        }
        if (this.query != null) {
            this.query.collectDependencies(hashSet);
        }
        this.targetMatchQuery.collectDependencies(hashSet);
    }

    public static final class WhenNotMatched
    extends When {
        private Insert insertCommand;

        public WhenNotMatched(MergeUsing mergeUsing) {
            super(mergeUsing);
        }

        public Insert getInsertCommand() {
            return this.insertCommand;
        }

        public void setInsertCommand(Insert insert) {
            this.insertCommand = insert;
        }

        @Override
        void setDeltaChangeCollector(ResultTarget resultTarget, DataChangeDeltaTable.ResultOption resultOption) {
            this.insertCommand.setDeltaChangeCollector(resultTarget, resultOption);
        }

        @Override
        int merge() {
            return this.andCondition == null || this.andCondition.getBooleanValue(this.mergeUsing.getSession()) ? this.insertCommand.update() : 0;
        }

        @Override
        void prepare() {
            super.prepare();
            this.insertCommand.setSourceTableFilter(this.mergeUsing.sourceTableFilter);
            this.insertCommand.prepare();
        }

        @Override
        int evaluateTriggerMasks() {
            return 1;
        }

        @Override
        void checkRights() {
            this.mergeUsing.getSession().getUser().checkRight(this.mergeUsing.targetTable, 4);
        }

        @Override
        void collectDependencies(HashSet<DbObject> hashSet) {
            this.insertCommand.collectDependencies(hashSet);
        }
    }

    public static final class WhenMatched
    extends When {
        Update updateCommand;
        Delete deleteCommand;
        private final HashSet<Long> updatedKeys = new HashSet();

        public WhenMatched(MergeUsing mergeUsing) {
            super(mergeUsing);
        }

        public Prepared getUpdateCommand() {
            return this.updateCommand;
        }

        public void setUpdateCommand(Update update) {
            this.updateCommand = update;
        }

        public Prepared getDeleteCommand() {
            return this.deleteCommand;
        }

        public void setDeleteCommand(Delete delete) {
            this.deleteCommand = delete;
        }

        @Override
        void reset() {
            this.updatedKeys.clear();
        }

        @Override
        void setDeltaChangeCollector(ResultTarget resultTarget, DataChangeDeltaTable.ResultOption resultOption) {
            if (this.updateCommand != null) {
                this.updateCommand.setDeltaChangeCollector(resultTarget, resultOption);
            }
            if (this.deleteCommand != null) {
                this.deleteCommand.setDeltaChangeCollector(resultTarget, resultOption);
            }
        }

        @Override
        int merge() {
            int n = 0;
            if (this.updateCommand != null) {
                n += this.updateCommand.update();
            }
            if (this.deleteCommand != null) {
                n += this.deleteCommand.update();
                this.updatedKeys.clear();
            }
            return n;
        }

        @Override
        void prepare() {
            super.prepare();
            if (this.updateCommand != null) {
                this.updateCommand.setSourceTableFilter(this.mergeUsing.sourceTableFilter);
                this.updateCommand.setCondition(WhenMatched.appendCondition(this.updateCommand, this.mergeUsing.onCondition));
                if (this.andCondition != null) {
                    this.updateCommand.setCondition(WhenMatched.appendCondition(this.updateCommand, this.andCondition));
                }
                this.updateCommand.prepare();
            }
            if (this.deleteCommand != null) {
                this.deleteCommand.setSourceTableFilter(this.mergeUsing.sourceTableFilter);
                this.deleteCommand.setCondition(WhenMatched.appendCondition(this.deleteCommand, this.mergeUsing.onCondition));
                if (this.andCondition != null) {
                    this.deleteCommand.setCondition(WhenMatched.appendCondition(this.deleteCommand, this.andCondition));
                }
                this.deleteCommand.prepare();
                if (this.updateCommand != null) {
                    this.updateCommand.setUpdatedKeysCollector(this.updatedKeys);
                    this.deleteCommand.setKeysFilter(this.updatedKeys);
                }
            }
        }

        @Override
        int evaluateTriggerMasks() {
            int n = 0;
            if (this.updateCommand != null) {
                n |= 2;
            }
            if (this.deleteCommand != null) {
                n |= 4;
            }
            return n;
        }

        @Override
        void checkRights() {
            User user = this.mergeUsing.getSession().getUser();
            if (this.updateCommand != null) {
                user.checkRight(this.mergeUsing.targetTable, 8);
            }
            if (this.deleteCommand != null) {
                user.checkRight(this.mergeUsing.targetTable, 2);
            }
        }

        @Override
        void collectDependencies(HashSet<DbObject> hashSet) {
            if (this.updateCommand != null) {
                this.updateCommand.collectDependencies(hashSet);
            }
            if (this.deleteCommand != null) {
                this.deleteCommand.collectDependencies(hashSet);
            }
        }

        private static Expression appendCondition(Update update, Expression expression) {
            Expression expression2 = update.getCondition();
            return expression2 == null ? expression : new ConditionAndOr(0, expression2, expression);
        }

        private static Expression appendCondition(Delete delete, Expression expression) {
            Expression expression2 = delete.getCondition();
            return expression2 == null ? expression : new ConditionAndOr(0, expression2, expression);
        }
    }

    public static abstract class When {
        final MergeUsing mergeUsing;
        Expression andCondition;

        When(MergeUsing mergeUsing) {
            this.mergeUsing = mergeUsing;
        }

        public void setAndCondition(Expression expression) {
            this.andCondition = expression;
        }

        void reset() {
        }

        abstract void setDeltaChangeCollector(ResultTarget var1, DataChangeDeltaTable.ResultOption var2);

        abstract int merge();

        void prepare() {
            if (this.andCondition != null) {
                this.andCondition.mapColumns(this.mergeUsing.sourceTableFilter, 2, 0);
                this.andCondition.mapColumns(this.mergeUsing.targetTableFilter, 1, 0);
            }
        }

        abstract int evaluateTriggerMasks();

        abstract void checkRights();

        abstract void collectDependencies(HashSet<DbObject> var1);
    }
}

