/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log.jmx;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;

@ManagedObject(value="Jetty Logging")
public class LogMBean
extends ObjectMBean {
    public LogMBean(Object managedObject) {
        super(managedObject);
    }

    @ManagedAttribute(value="list of instantiated loggers")
    public List<String> getLoggers() {
        ArrayList<String> keySet = new ArrayList<String>(Log.getLoggers().keySet());
        return keySet;
    }

    @ManagedOperation(value="true if debug enabled for the given logger")
    public boolean isDebugEnabled(@Name(value="logger") String logger2) {
        return Log.getLogger(logger2).isDebugEnabled();
    }

    @ManagedOperation(value="Set debug enabled for given logger")
    public void setDebugEnabled(@Name(value="logger") String logger2, @Name(value="enabled") Boolean enabled) {
        Log.getLogger(logger2).setDebugEnabled(enabled);
    }
}

