/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.invoker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.model.BindingOperationInfo;

public abstract class AbstractInvoker
implements Invoker {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractInvoker.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Exchange exchange2, Object o) {
        Object serviceObject = this.getServiceObject(exchange2);
        try {
            Method m3;
            BindingOperationInfo bop = exchange2.getBindingOperationInfo();
            MethodDispatcher md = (MethodDispatcher)exchange2.getService().get(MethodDispatcher.class.getName());
            Method method = m3 = bop == null ? null : md.getMethod(bop);
            if (m3 == null && bop == null) {
                LOG.severe(new Message("MISSING_BINDING_OPERATION", LOG, new Object[0]).toString());
                throw new Fault(new Message("EXCEPTION_INVOKING_OBJECT", LOG, "No binding operation info", "unknown method", "unknown"));
            }
            MessageContentsList params = null;
            if (o instanceof List) {
                params = CastUtils.cast((List)o);
            } else if (o != null) {
                params = new MessageContentsList(o);
            }
            m3 = this.adjustMethodAndParams(m3, exchange2, params, serviceObject.getClass());
            m3 = AbstractInvoker.matchMethod(m3, serviceObject);
            Object object = this.invoke(exchange2, serviceObject, m3, params);
            return object;
        }
        finally {
            this.releaseServiceObject(exchange2, serviceObject);
        }
    }

    protected Method adjustMethodAndParams(Method m3, Exchange ex, List<Object> params, Class<?> serviceObjectClass) {
        return m3;
    }

    protected Object invoke(Exchange exchange2, Object serviceObject, Method m3, List<Object> params) {
        try {
            Object[] paramArray = new Object[]{};
            if (params != null) {
                paramArray = params.toArray();
            }
            Object res = this.performInvocation(exchange2, serviceObject, m3, paramArray);
            if (exchange2.isOneWay()) {
                return null;
            }
            return new MessageContentsList(res);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t == null) {
                t = e;
            }
            this.checkSuspendedInvocation(exchange2, serviceObject, m3, params, t);
            exchange2.getInMessage().put(FaultMode.class, FaultMode.UNCHECKED_APPLICATION_FAULT);
            for (Class<?> cl : m3.getExceptionTypes()) {
                if (!cl.isInstance(t)) continue;
                exchange2.getInMessage().put(FaultMode.class, FaultMode.CHECKED_APPLICATION_FAULT);
            }
            if (t instanceof Fault) {
                exchange2.getInMessage().put(FaultMode.class, FaultMode.CHECKED_APPLICATION_FAULT);
                throw (Fault)t;
            }
            throw this.createFault(t, m3, params, true);
        }
        catch (SuspendedInvocationException suspendedEx) {
            this.checkSuspendedInvocation(exchange2, serviceObject, m3, params, suspendedEx);
            throw suspendedEx;
        }
        catch (Fault f) {
            exchange2.getInMessage().put(FaultMode.class, FaultMode.UNCHECKED_APPLICATION_FAULT);
            throw f;
        }
        catch (Exception e) {
            this.checkSuspendedInvocation(exchange2, serviceObject, m3, params, e);
            exchange2.getInMessage().put(FaultMode.class, FaultMode.UNCHECKED_APPLICATION_FAULT);
            throw this.createFault(e, m3, params, false);
        }
    }

    protected void checkSuspendedInvocation(Exchange exchange2, Object serviceObject, Method m3, List<Object> params, Throwable t) {
        if (t instanceof SuspendedInvocationException) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "SUSPENDED_INVOCATION_EXCEPTION", new Object[]{serviceObject, m3.toString(), params});
            }
            throw (SuspendedInvocationException)t;
        }
    }

    protected Fault createFault(Throwable ex, Method m3, List<Object> params, boolean checked) {
        if (checked) {
            return new Fault(ex);
        }
        String message = ex == null ? "" : ex.getMessage();
        String method = m3 == null ? "<null>" : m3.toString();
        return new Fault(new Message("EXCEPTION_INVOKING_OBJECT", LOG, message, method, params), ex);
    }

    protected Object performInvocation(Exchange exchange2, Object serviceObject, Method m3, Object[] paramArray) throws Exception {
        paramArray = this.insertExchange(m3, paramArray, exchange2);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "INVOKING_METHOD", new Object[]{serviceObject, m3, Arrays.asList(paramArray)});
        }
        return m3.invoke(serviceObject, paramArray);
    }

    public Object[] insertExchange(Method method, Object[] params, Exchange context) {
        Object[] newParams = params;
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            if (!method.getParameterTypes()[i].equals(Exchange.class)) continue;
            newParams = new Object[params.length + 1];
            for (int j = 0; j < newParams.length; ++j) {
                newParams[j] = j == i ? context : (j > i ? params[j - 1] : params[j]);
            }
        }
        return newParams;
    }

    public abstract Object getServiceObject(Exchange var1);

    public void releaseServiceObject(Exchange context, Object obj) {
    }

    private static Method matchMethod(Method methodToMatch, Object targetObject) {
        if (AbstractInvoker.isJdkDynamicProxy(targetObject)) {
            for (Class<?> iface : targetObject.getClass().getInterfaces()) {
                Method m3 = AbstractInvoker.getMostSpecificMethod(methodToMatch, iface);
                if (methodToMatch.equals(m3)) continue;
                return m3;
            }
        }
        return methodToMatch;
    }

    public static boolean isJdkDynamicProxy(Object object) {
        return object != null && Proxy.isProxyClass(object.getClass());
    }

    public static Method getMostSpecificMethod(Method method, Class<?> targetClass) {
        if (method != null && targetClass != null) {
            try {
                method = targetClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return method;
    }
}

