/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.validation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ParameterNameProvider;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.utils.ResourceUtils;

public class JAXRSParameterNameProvider
implements ParameterNameProvider {
    @Override
    public List<String> getParameterNames(Constructor<?> constructor) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
            parameterNames.add("arg" + i);
        }
        return parameterNames;
    }

    @Override
    public List<String> getParameterNames(Method method) {
        List<Parameter> parameters = ResourceUtils.getParameters(method);
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (int i = 0; i < parameters.size(); ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append("arg").append(i);
            sb.append('(');
            Parameter parameter = parameters.get(i);
            if (parameter.getName() != null) {
                sb.append(parameter.getType().toString());
                sb.append("(\"").append(parameter.getName()).append("\")");
                sb.append(' ');
            }
            sb.append(method.getParameterTypes()[i].getSimpleName());
            sb.append(')');
            parameterNames.add(sb.toString());
        }
        return parameterNames;
    }
}

