/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.validation;

import java.lang.reflect.Method;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.validation.BeanValidationProvider;

public class JAXRSBeanValidationInvoker
extends JAXRSInvoker {
    private volatile BeanValidationProvider provider;
    private boolean validateServiceObject = true;

    @Override
    public Object invoke(Exchange exchange2, Object serviceObject, Method m3, List<Object> params) {
        Message message = JAXRSUtils.getCurrentMessage();
        BeanValidationProvider theProvider = this.getProvider(message);
        try {
            MessageContentsList list;
            if (this.isValidateServiceObject()) {
                theProvider.validateBean(serviceObject);
            }
            theProvider.validateParameters(serviceObject, m3, params.toArray());
            Object response = super.invoke(exchange2, serviceObject, m3, params);
            if (response instanceof MessageContentsList && (list = (MessageContentsList)response).size() == 1) {
                Object entity = list.get(0);
                if (entity instanceof Response) {
                    theProvider.validateReturnValue(serviceObject, m3, ((Response)entity).getEntity());
                } else {
                    theProvider.validateReturnValue(serviceObject, m3, entity);
                }
            }
            return response;
        }
        catch (Fault ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new Fault(ex);
        }
    }

    protected BeanValidationProvider getProvider(Message message) {
        if (this.provider == null) {
            Object prop = message.getContextualProperty(BeanValidationProvider.class.getName());
            this.provider = prop != null ? (BeanValidationProvider)prop : new BeanValidationProvider();
        }
        return this.provider;
    }

    public void setProvider(BeanValidationProvider provider) {
        this.provider = provider;
    }

    public boolean isValidateServiceObject() {
        return this.validateServiceObject;
    }

    public void setValidateServiceObject(boolean validateServiceObject) {
        this.validateServiceObject = validateServiceObject;
    }
}

