/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger.ui;

import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.swagger.ui.SwaggerUiService;

@PreMatching
@Priority(value=5001)
class SwaggerUiServiceFilter
implements ContainerRequestFilter {
    private final SwaggerUiService uiService;

    SwaggerUiServiceFilter(SwaggerUiService uiService) {
        this.uiService = uiService;
    }

    @Override
    public void filter(ContainerRequestContext rc) throws IOException {
        UriInfo ui;
        String path;
        int uiPathIndex;
        if ("GET".equals(rc.getRequest().getMethod()) && (uiPathIndex = (path = (ui = rc.getUriInfo()).getPath()).lastIndexOf("api-docs")) >= 0) {
            String resourcePath = uiPathIndex + 8 < path.length() ? path.substring(uiPathIndex + 8) : "";
            rc.abortWith(this.uiService.getResource(ui, resourcePath));
        }
    }
}

