/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.ext.AbstractSwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtensions;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import io.swagger.util.ParameterProcessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.ws.rs.BeanParam;
import javax.ws.rs.MatrixParam;
import org.apache.cxf.jaxrs.swagger.MatrixParameter;

public class JaxRs2Extension
extends AbstractSwaggerExtension {
    private final ObjectMapper mapper = Json.mapper();

    @Override
    public List<Parameter> extractParameters(List<Annotation> annotations, Type type, Set<Type> typesToSkip, Iterator<SwaggerExtension> chain) {
        if (this.shouldIgnoreType(type, typesToSkip)) {
            return new ArrayList<Parameter>();
        }
        List<Parameter> parameters = new ArrayList<Parameter>();
        for (Annotation annotation : annotations) {
            if (annotation instanceof MatrixParam) {
                MatrixParam param = (MatrixParam)annotation;
                MatrixParameter mp = (MatrixParameter)new MatrixParameter().name(param.value());
                Property schema = this.createProperty(type);
                if (schema != null) {
                    mp.setProperty(schema);
                }
                this.applyBeanValidatorAnnotations(mp, annotations);
                parameters.add(mp);
                continue;
            }
            if (!(annotation instanceof BeanParam)) continue;
            BeanDescription beanDesc = this.mapper.getSerializationConfig().introspect(this.constructType(type));
            List<BeanPropertyDefinition> properties = beanDesc.findProperties();
            for (BeanPropertyDefinition propDef : properties) {
                AnnotatedField field = propDef.getField();
                AnnotatedMethod setter = propDef.getSetter();
                ArrayList<Annotation> paramAnnotations = new ArrayList<Annotation>();
                Iterator<SwaggerExtension> extensions = SwaggerExtensions.chain();
                Type paramType = null;
                if (field != null) {
                    paramType = field.getAnnotated().getGenericType();
                    for (Annotation fieldAnnotation : field.annotations()) {
                        if (paramAnnotations.contains(fieldAnnotation)) continue;
                        paramAnnotations.add(fieldAnnotation);
                    }
                }
                if (setter != null) {
                    if (paramType == null && setter.getMember().getGenericParameterTypes() != null) {
                        paramType = setter.getMember().getGenericParameterTypes()[0];
                    }
                    for (Annotation fieldAnnotation : setter.annotations()) {
                        if (paramAnnotations.contains(fieldAnnotation)) continue;
                        paramAnnotations.add(fieldAnnotation);
                    }
                }
                List<Parameter> extracted = extensions.next().extractParameters(paramAnnotations, paramType, typesToSkip, extensions);
                for (Parameter param : extracted) {
                    if (ParameterProcessor.applyAnnotations(null, param, paramType, paramAnnotations) == null) continue;
                    this.applyBeanValidatorAnnotations(param, paramAnnotations);
                    parameters.add(param);
                }
            }
        }
        if (parameters.isEmpty()) {
            parameters = super.extractParameters(annotations, type, typesToSkip, chain);
        }
        return parameters;
    }

    private Property createProperty(Type type) {
        return this.enforcePrimitive(ModelConverters.getInstance().readAsProperty(type), 0);
    }

    private Property enforcePrimitive(Property in, int level) {
        if (in instanceof RefProperty) {
            return new StringProperty();
        }
        if (in instanceof ArrayProperty) {
            if (level == 0) {
                ArrayProperty array = (ArrayProperty)in;
                array.setItems(this.enforcePrimitive(array.getItems(), level + 1));
            } else {
                return new StringProperty();
            }
        }
        return in;
    }

    private void applyBeanValidatorAnnotations(Parameter parameter, List<Annotation> annotations) {
        HashMap<String, Annotation> annos = new HashMap<String, Annotation>();
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                annos.put(annotation.annotationType().getName(), annotation);
            }
        }
        if (annos.containsKey(NotNull.class.getName())) {
            parameter.setRequired(true);
        }
        if (parameter instanceof AbstractSerializableParameter) {
            Annotation max;
            Annotation min2;
            AbstractSerializableParameter serializable = (AbstractSerializableParameter)parameter;
            if (annos.containsKey(Min.class.getName())) {
                min2 = (Min)annos.get(Min.class.getName());
                serializable.setMinimum(BigDecimal.valueOf(min2.value()));
            }
            if (annos.containsKey(Max.class.getName())) {
                max = (Max)annos.get(Max.class.getName());
                serializable.setMaximum(BigDecimal.valueOf(max.value()));
            }
            if (annos.containsKey(Size.class.getName())) {
                Size size = (Size)annos.get(Size.class.getName());
                serializable.setMinimum(BigDecimal.valueOf(size.min()));
                serializable.setMaximum(BigDecimal.valueOf(size.max()));
                serializable.setMinItems(size.min());
                serializable.setMaxItems(size.max());
            }
            if (annos.containsKey(DecimalMin.class.getName())) {
                min2 = (DecimalMin)annos.get(DecimalMin.class.getName());
                if (min2.inclusive()) {
                    serializable.setMinimum(BigDecimal.valueOf(Double.valueOf(min2.value())));
                } else {
                    serializable.setExclusiveMinimum(!min2.inclusive());
                }
            }
            if (annos.containsKey(DecimalMax.class.getName())) {
                max = (DecimalMax)annos.get(DecimalMax.class.getName());
                if (max.inclusive()) {
                    serializable.setMaximum(BigDecimal.valueOf(Double.valueOf(max.value())));
                } else {
                    serializable.setExclusiveMaximum(!max.inclusive());
                }
            }
            if (annos.containsKey(Pattern.class.getName())) {
                Pattern pattern = (Pattern)annos.get(Pattern.class.getName());
                serializable.setPattern(pattern.regexp());
            }
        }
    }
}

