/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractPortableFeature;
import org.apache.cxf.feature.DelegatingFeature;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;

public abstract class AbstractSwaggerFeature<T extends Portable>
extends DelegatingFeature<T> {
    protected AbstractSwaggerFeature(T d) {
        super(d);
    }

    public static boolean isSwaggerJaxRsAvailable() {
        return Portable.isSwaggerJaxRsAvailable();
    }

    public void addSwaggerResource(Server server, Bus bus) {
        ((Portable)this.getDelegate()).addSwaggerResource(server, bus);
    }

    public void setBasePathByAddress(String address) {
        ((Portable)this.getDelegate()).setBasePathByAddress(address);
    }

    public void calculateDefaultResourcePackage(Server server) {
        ((Portable)this.getDelegate()).calculateDefaultResourcePackage(server);
    }

    public void calculateDefaultBasePath(Server server) {
        ((Portable)this.getDelegate()).calculateDefaultBasePath(server);
    }

    public String getResourcePackage() {
        return ((Portable)this.getDelegate()).getResourcePackage();
    }

    public void setResourcePackage(String resourcePackage) {
        ((Portable)this.getDelegate()).setResourcePackage(resourcePackage);
    }

    public String getVersion() {
        return ((Portable)this.getDelegate()).getVersion();
    }

    public void setVersion(String version) {
        ((Portable)this.getDelegate()).setVersion(version);
    }

    public String getBasePath() {
        return ((Portable)this.getDelegate()).getBasePath();
    }

    public void setBasePath(String basePath) {
        ((Portable)this.getDelegate()).setBasePath(basePath);
    }

    public String getTitle() {
        return ((Portable)this.getDelegate()).getTitle();
    }

    public void setTitle(String title) {
        ((Portable)this.getDelegate()).setTitle(title);
    }

    public String getDescription() {
        return ((Portable)this.getDelegate()).getDescription();
    }

    public void setDescription(String description) {
        ((Portable)this.getDelegate()).setDescription(description);
    }

    public String getContact() {
        return ((Portable)this.getDelegate()).getContact();
    }

    public void setContact(String contact) {
        ((Portable)this.getDelegate()).setContact(contact);
    }

    public String getLicense() {
        return ((Portable)this.getDelegate()).getLicense();
    }

    public void setLicense(String license) {
        ((Portable)this.getDelegate()).setLicense(license);
    }

    public String getLicenseUrl() {
        return ((Portable)this.getDelegate()).getLicenseUrl();
    }

    public void setLicenseUrl(String licenseUrl) {
        ((Portable)this.getDelegate()).setLicenseUrl(licenseUrl);
    }

    public String getTermsOfServiceUrl() {
        return ((Portable)this.getDelegate()).getTermsOfServiceUrl();
    }

    public void setTermsOfServiceUrl(String termsOfServiceUrl) {
        ((Portable)this.getDelegate()).setTermsOfServiceUrl(termsOfServiceUrl);
    }

    public String getFilterClass() {
        return ((Portable)this.getDelegate()).getFilterClass();
    }

    public void setFilterClass(String filterClass) {
        ((Portable)this.getDelegate()).setFilterClass(filterClass);
    }

    public boolean isRunAsFilter() {
        return ((Portable)this.getDelegate()).isRunAsFilter();
    }

    public void setRunAsFilter(boolean runAsFilter) {
        ((Portable)this.getDelegate()).setRunAsFilter(runAsFilter);
    }

    public boolean isActivateOnlyIfJaxrsSupported() {
        return ((Portable)this.getDelegate()).isActivateOnlyIfJaxrsSupported();
    }

    public void setActivateOnlyIfJaxrsSupported(boolean activateOnlyIfJaxrsSupported) {
        ((Portable)this.getDelegate()).setActivateOnlyIfJaxrsSupported(activateOnlyIfJaxrsSupported);
    }

    public static abstract class Portable
    implements AbstractPortableFeature {
        private static final boolean SWAGGER_JAXRS_AVAILABLE = Portable.isSwaggerJaxRsAvailable();
        protected boolean licenseWasSet;
        private boolean runAsFilter;
        private boolean activateOnlyIfJaxrsSupported;
        private String resourcePackage;
        private String version;
        private String basePath;
        private String title;
        private String description;
        private String contact;
        private String license;
        private String licenseUrl;
        private String termsOfServiceUrl;
        private String filterClass;

        private static boolean isSwaggerJaxRsAvailable() {
            try {
                Class.forName("io.swagger.jaxrs.DefaultParameterExtension");
                return true;
            }
            catch (Throwable ex) {
                return false;
            }
        }

        @Override
        public void initialize(Server server, Bus bus) {
            if (!this.activateOnlyIfJaxrsSupported || SWAGGER_JAXRS_AVAILABLE) {
                this.calculateDefaultResourcePackage(server);
                this.calculateDefaultBasePath(server);
                this.addSwaggerResource(server, bus);
                this.doInitializeProvider(server.getEndpoint(), bus);
                bus.setProperty("swagger.service.description.available", "true");
            }
        }

        protected abstract void addSwaggerResource(Server var1, Bus var2);

        protected abstract void setBasePathByAddress(String var1);

        void calculateDefaultResourcePackage(Server server) {
            if (!StringUtils.isEmpty(this.getResourcePackage())) {
                return;
            }
            JAXRSServiceFactoryBean serviceFactoryBean = (JAXRSServiceFactoryBean)server.getEndpoint().get(JAXRSServiceFactoryBean.class.getName());
            List<ClassResourceInfo> resourceInfos = serviceFactoryBean.getClassResourceInfo();
            if (resourceInfos.size() == 1) {
                this.setResourcePackage(resourceInfos.get(0).getServiceClass().getPackage().getName());
            } else {
                ArrayList serviceClasses = new ArrayList(resourceInfos.size());
                for (ClassResourceInfo cri : resourceInfos) {
                    serviceClasses.add(cri.getServiceClass());
                }
                String sharedPackage = PackageUtils.getSharedPackageName(serviceClasses);
                if (!StringUtils.isEmpty(sharedPackage)) {
                    this.setResourcePackage(sharedPackage);
                }
            }
        }

        protected void calculateDefaultBasePath(Server server) {
            if (this.getBasePath() == null || this.getBasePath().length() == 0) {
                String address = server.getEndpoint().getEndpointInfo().getAddress();
                this.setBasePathByAddress(address);
            }
        }

        public String getResourcePackage() {
            return this.resourcePackage;
        }

        public void setResourcePackage(String resourcePackage) {
            this.resourcePackage = resourcePackage;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getContact() {
            return this.contact;
        }

        public void setContact(String contact) {
            this.contact = contact;
        }

        public String getLicense() {
            return this.license;
        }

        public void setLicense(String license) {
            this.licenseWasSet = true;
            this.license = license;
        }

        public String getLicenseUrl() {
            return this.licenseUrl;
        }

        public void setLicenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
        }

        public String getTermsOfServiceUrl() {
            return this.termsOfServiceUrl;
        }

        public void setTermsOfServiceUrl(String termsOfServiceUrl) {
            this.termsOfServiceUrl = termsOfServiceUrl;
        }

        public String getFilterClass() {
            return this.filterClass;
        }

        public void setFilterClass(String filterClass) {
            this.filterClass = filterClass;
        }

        public boolean isRunAsFilter() {
            return this.runAsFilter;
        }

        public void setRunAsFilter(boolean runAsFilter) {
            this.runAsFilter = runAsFilter;
        }

        public boolean isActivateOnlyIfJaxrsSupported() {
            return this.activateOnlyIfJaxrsSupported;
        }

        public void setActivateOnlyIfJaxrsSupported(boolean activateOnlyIfJaxrsSupported) {
            this.activateOnlyIfJaxrsSupported = activateOnlyIfJaxrsSupported;
        }
    }
}

