/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.validation.Schema;
import org.apache.cxf.databinding.AbstractDataBinding;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.MessagePartInfo;

public class JAXRSDataBinding
extends AbstractDataBinding {
    private static final Class<?>[] SUPPORTED_READER_FORMATS = new Class[]{XMLStreamReader.class};
    private static final Class<?>[] SUPPORTED_WRITER_FORMATS = new Class[]{XMLStreamWriter.class};
    private MessageBodyReader<?> xmlReader;
    private MessageBodyWriter<Object> xmlWriter;

    public void setProvider(Object provider) {
        if (!(provider instanceof MessageBodyWriter)) {
            throw new IllegalArgumentException("The provider must implement javax.ws.rs.ext.MessageBodyWriter");
        }
        this.xmlWriter = (MessageBodyWriter)provider;
        if (provider instanceof MessageBodyReader) {
            this.xmlReader = (MessageBodyReader)provider;
        }
    }

    @Override
    public <T> DataReader<T> createReader(Class<T> cls) {
        if (this.xmlReader == null) {
            throw new IllegalStateException("javax.ws.rs.ext.MessageBodyReader reference is uninitialized");
        }
        return new MessageBodyDataReader();
    }

    @Override
    public <T> DataWriter<T> createWriter(Class<T> cls) {
        return new MessageBodyDataWriter();
    }

    @Override
    public Class<?>[] getSupportedReaderFormats() {
        return SUPPORTED_READER_FORMATS;
    }

    @Override
    public Class<?>[] getSupportedWriterFormats() {
        return SUPPORTED_WRITER_FORMATS;
    }

    @Override
    public void initialize(Service service) {
    }

    private MultivaluedMap<String, String> getHeaders(Message message) {
        return new MetadataMap<String, String>((Map)message.get(Message.PROTOCOL_HEADERS), true, true);
    }

    private MultivaluedMap<String, Object> getWriteHeaders(Message message) {
        return new MetadataMap<String, Object>((Map)message.get(Message.PROTOCOL_HEADERS), true, true);
    }

    private class MessageBodyDataReader
    implements DataReader<XMLStreamReader> {
        private MessageBodyDataReader() {
        }

        @Override
        public Object read(XMLStreamReader input) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object read(MessagePartInfo part, XMLStreamReader input) {
            return this.doRead(part.getTypeClass(), input);
        }

        @Override
        public Object read(QName elementQName, XMLStreamReader input, Class<?> type) {
            return this.doRead(type, input);
        }

        @Override
        private <T> T read(Class<T> cls) throws WebApplicationException, IOException {
            Message message = PhaseInterceptorChain.getCurrentMessage();
            Method method = MessageUtils.getTargetMethod(message).orElse(null);
            MessageBodyReader reader = JAXRSDataBinding.this.xmlReader;
            return reader.readFrom(cls, method.getGenericParameterTypes()[0], method.getParameterTypes()[0].getAnnotations(), MediaType.APPLICATION_ATOM_XML_TYPE, JAXRSDataBinding.this.getHeaders(message), null);
        }

        private Object doRead(Class<?> cls, XMLStreamReader input) {
            try {
                return this.read(cls);
            }
            catch (Exception ex) {
                return null;
            }
        }

        @Override
        public void setAttachments(Collection<Attachment> attachments) {
        }

        @Override
        public void setProperty(String prop, Object value) {
        }

        @Override
        public void setSchema(Schema s2) {
        }
    }

    private class MessageBodyDataWriter
    implements DataWriter<XMLStreamWriter> {
        private MessageBodyDataWriter() {
        }

        @Override
        public void write(Object obj, XMLStreamWriter output) {
            this.write(obj, (MessagePartInfo)null, output);
        }

        @Override
        public void write(Object obj, MessagePartInfo part, XMLStreamWriter output) {
            try {
                Message message = PhaseInterceptorChain.getCurrentMessage();
                Method method = MessageUtils.getTargetMethod(message).orElse(null);
                MultivaluedMap headers = JAXRSDataBinding.this.getWriteHeaders(message);
                JAXRSDataBinding.this.xmlWriter.writeTo(obj, method.getReturnType(), method.getGenericReturnType(), method.getAnnotations(), MediaType.APPLICATION_XML_TYPE, headers, null);
                message.put(Message.PROTOCOL_HEADERS, headers);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void setAttachments(Collection<Attachment> attachments) {
        }

        @Override
        public void setProperty(String key, Object value) {
        }

        @Override
        public void setSchema(Schema s2) {
        }
    }
}

