/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.staxutils.StaxUtils;

@Provider
@Produces(value={"application/xml", "application/*+xml", "text/xml"})
@Consumes(value={"application/xml", "application/*+xml", "text/xml"})
public class DataBindingProvider<T>
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    private DataBinding binding;

    public DataBindingProvider() {
    }

    public DataBindingProvider(DataBinding db) {
        this.binding = db;
    }

    public void setDataBinding(DataBinding db) {
        this.binding = db;
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T readFrom(Class<T> clazz, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        T t;
        XMLStreamReader reader = null;
        try {
            reader = this.createReader(clazz, genericType, is);
            DataReader<XMLStreamReader> dataReader = this.binding.createReader(XMLStreamReader.class);
            Object o = dataReader.read(null, reader, clazz);
            t = o == null ? null : (T)clazz.cast(o);
        }
        catch (Exception ex) {
            try {
                throw ExceptionUtils.toBadRequestException(ex, null);
            }
            catch (Throwable throwable) {
                try {
                    StaxUtils.close(reader);
                    throw throwable;
                }
                catch (XMLStreamException xMLStreamException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            StaxUtils.close(reader);
            return t;
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        return t;
    }

    protected XMLStreamReader createReader(Class<?> clazz, Type genericType, InputStream is) throws Exception {
        return StaxUtils.createXMLStreamReader(is);
    }

    @Override
    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        if (byte[].class.isAssignableFrom(t.getClass())) {
            return ((byte[])t).length;
        }
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return true;
    }

    @Override
    public void writeTo(T o, Class<?> clazz, Type genericType, Annotation[] annotations, MediaType m3, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        XMLStreamWriter writer = null;
        try {
            String enc = HttpUtils.getSetEncoding(m3, headers, StandardCharsets.UTF_8.name());
            writer = this.createWriter(clazz, genericType, enc, os);
            this.writeToWriter(writer, o);
        }
        catch (Exception ex) {
            try {
                throw ExceptionUtils.toInternalServerErrorException(ex, null);
            }
            catch (Throwable throwable) {
                StaxUtils.close(writer);
                throw throwable;
            }
        }
        StaxUtils.close(writer);
    }

    protected void writeToWriter(XMLStreamWriter writer, Object o) throws Exception {
        DataWriter<XMLStreamWriter> dataWriter = this.binding.createWriter(XMLStreamWriter.class);
        dataWriter.write(o, writer);
        writer.flush();
    }

    protected XMLStreamWriter createWriter(Class<?> clazz, Type genericType, String enc, OutputStream os) throws Exception {
        return StaxUtils.createXMLStreamWriter(os);
    }
}

