/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;

public class MethodDispatcher {
    private Map<OperationResourceInfo, Method> oriToMethod = new LinkedHashMap<OperationResourceInfo, Method>();
    private Map<Method, OperationResourceInfo> methodToOri = new LinkedHashMap<Method, OperationResourceInfo>();
    private ConcurrentHashMap<Method, Method> proxyMethodMap = new ConcurrentHashMap();

    public MethodDispatcher() {
    }

    MethodDispatcher(MethodDispatcher md, ClassResourceInfo cri) {
        for (OperationResourceInfo ori : md.getOperationResourceInfos()) {
            OperationResourceInfo clone = new OperationResourceInfo(ori, cri);
            this.oriToMethod.put(clone, clone.getMethodToInvoke());
            this.methodToOri.put(clone.getMethodToInvoke(), clone);
        }
    }

    public void bind(OperationResourceInfo o, Method ... methods) {
        Method primary = methods[0];
        for (Method m3 : methods) {
            this.methodToOri.put(m3, o);
        }
        this.oriToMethod.put(o, primary);
    }

    public OperationResourceInfo getOperationResourceInfo(Method method) {
        return this.methodToOri.get(method);
    }

    public Set<OperationResourceInfo> getOperationResourceInfos() {
        return this.oriToMethod.keySet();
    }

    public Method getMethod(OperationResourceInfo op) {
        return this.oriToMethod.get(op);
    }

    public Method getProxyMethod(Method m3) {
        return this.proxyMethodMap.get(m3);
    }

    public void addProxyMethod(Method m3, Method proxyM) {
        this.proxyMethodMap.putIfAbsent(m3, proxyM);
    }
}

