/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import javax.ws.rs.container.ResourceContext;
import org.apache.cxf.jaxrs.ext.ResourceContextProvider;
import org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.message.Message;

public class ResourceContextImpl
implements ResourceContext {
    private static final String CONTEXT_PROVIDER_PROP = "org.apache.cxf.jaxrs.resource.context.provider";
    private final ClassResourceInfo cri;
    private final Class<?> subClass;
    private final Message m;

    public ResourceContextImpl(Message m3, OperationResourceInfo ori) {
        this.m = m3;
        this.cri = ori.getClassResourceInfo();
        this.subClass = ori.getMethodToInvoke().getReturnType();
    }

    @Override
    public <T> T getResource(Class<T> cls) {
        ResourceProvider rp = null;
        Object propValue = this.m.getContextualProperty(CONTEXT_PROVIDER_PROP);
        rp = propValue instanceof ResourceContextProvider ? ((ResourceContextProvider)propValue).getResourceProvider(cls) : new PerRequestResourceProvider(cls);
        T resource = cls.cast(rp.getInstance(this.m));
        return this.doInitResource(cls, resource);
    }

    @Override
    public <T> T initResource(T resource) {
        return this.doInitResource(resource.getClass(), resource);
    }

    private <T> T doInitResource(Class<?> cls, T resource) {
        ClassResourceInfo sub = this.cri.getSubResource(this.subClass, cls, resource, true, this.m);
        sub.initBeanParamInfo(ServerProviderFactory.getInstance(this.m));
        sub.injectContexts(resource, this.m.getExchange().get(OperationResourceInfo.class), this.m);
        return resource;
    }
}

