/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.PathSegmentImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public class RequestPreprocessor {
    private static final String ALLOW_HTTP_METHOD_OVERRIDE = "org.apache.cxf.jaxrs.allow.http.method.override";
    private static final String ACCEPT_QUERY = "_type";
    private static final String CTYPE_QUERY = "_ctype";
    private static final String METHOD_QUERY = "_method";
    private static final String METHOD_HEADER = "X-HTTP-Method-Override";
    private static final Set<String> PATHS_TO_SKIP;
    private static final Map<String, String> MEDIA_TYPE_SHORTCUTS;
    private Map<Object, Object> languageMappings;
    private Map<Object, Object> extensionMappings;

    public RequestPreprocessor() {
        this(null, null);
    }

    public RequestPreprocessor(Map<Object, Object> languageMappings, Map<Object, Object> extensionMappings) {
        this.languageMappings = languageMappings == null ? Collections.emptyMap() : languageMappings;
        this.extensionMappings = extensionMappings == null ? Collections.emptyMap() : extensionMappings;
    }

    public String preprocess(Message m3, UriInfo u) {
        this.handleExtensionMappings(m3, u);
        this.handleLanguageMappings(m3, u);
        MultivaluedMap<String, String> queries = u.getQueryParameters();
        this.handleTypeQuery(m3, queries);
        this.handleCType(m3, queries);
        this.handleMethod(m3, queries, new HttpHeadersImpl(m3));
        return new UriInfoImpl(m3, null).getPath();
    }

    private void handleLanguageMappings(Message m3, UriInfo uriInfo) {
        if (this.languageMappings.isEmpty()) {
            return;
        }
        PathSegmentImpl ps = new PathSegmentImpl(uriInfo.getPath(false), false);
        String path = ps.getPath();
        for (Map.Entry<Object, Object> entry : this.languageMappings.entrySet()) {
            if (!path.endsWith("." + entry.getKey())) continue;
            this.updateAcceptLanguageHeader(m3, entry.getValue().toString());
            this.updatePath(m3, path, entry.getKey().toString(), ps.getMatrixString());
            break;
        }
    }

    private void handleExtensionMappings(Message m3, UriInfo uriInfo) {
        if (this.extensionMappings.isEmpty()) {
            return;
        }
        PathSegmentImpl ps = new PathSegmentImpl(uriInfo.getPath(false), false);
        String path = ps.getPath();
        if (PATHS_TO_SKIP.contains(path)) {
            return;
        }
        for (Map.Entry<Object, Object> entry : this.extensionMappings.entrySet()) {
            String key = entry.getKey().toString();
            if (!path.endsWith("." + key)) continue;
            this.updateAcceptTypeHeader(m3, entry.getValue().toString());
            this.updatePath(m3, path, key, ps.getMatrixString());
            if (!"wadl".equals(key)) break;
            String query2 = (String)m3.get(Message.QUERY_STRING);
            if (StringUtils.isEmpty(query2)) {
                query2 = "_wadl";
            } else if (!query2.contains("_wadl")) {
                query2 = query2 + "&_wadl";
            }
            m3.put(Message.QUERY_STRING, query2);
            break;
        }
    }

    private void updateAcceptLanguageHeader(Message m3, String anotherValue) {
        ArrayList<String> acceptLanguage = (ArrayList<String>)((Map)m3.get(Message.PROTOCOL_HEADERS)).get("Accept-Language");
        if (acceptLanguage == null) {
            acceptLanguage = new ArrayList<String>();
        }
        acceptLanguage.add(anotherValue);
        ((Map)m3.get(Message.PROTOCOL_HEADERS)).put("Accept-Language", acceptLanguage);
    }

    private void updatePath(Message m3, String path, String suffix, String matrixString) {
        String newPath = path.substring(0, path.length() - (suffix.length() + 1));
        if (matrixString != null) {
            newPath = newPath + matrixString;
        }
        HttpUtils.updatePath(m3, newPath);
    }

    private void handleMethod(Message m3, MultivaluedMap<String, String> queries, HttpHeaders headers) {
        if (MessageUtils.getContextualBoolean(m3, ALLOW_HTTP_METHOD_OVERRIDE, false)) {
            List<String> list;
            String method = queries.getFirst(METHOD_QUERY);
            if (method == null && (list = headers.getRequestHeader(METHOD_HEADER)) != null && list.size() == 1) {
                method = list.get(0);
            }
            if (method != null) {
                m3.put("org.apache.cxf.request.method", method);
            }
        }
    }

    private void handleTypeQuery(Message m3, MultivaluedMap<String, String> queries) {
        String type = queries.getFirst(ACCEPT_QUERY);
        if (type != null) {
            if (MEDIA_TYPE_SHORTCUTS.containsKey(type)) {
                type = MEDIA_TYPE_SHORTCUTS.get(type);
            }
            this.updateAcceptTypeHeader(m3, type);
        }
    }

    private void handleCType(Message m3, MultivaluedMap<String, String> queries) {
        String type = queries.getFirst(CTYPE_QUERY);
        if (type != null) {
            if (MEDIA_TYPE_SHORTCUTS.containsKey(type)) {
                type = MEDIA_TYPE_SHORTCUTS.get(type);
            }
            m3.put("Content-Type", type);
        }
    }

    private void updateAcceptTypeHeader(Message m3, String acceptValue) {
        m3.put("Accept", acceptValue);
        ((Map)m3.get(Message.PROTOCOL_HEADERS)).put("Accept", Collections.singletonList(acceptValue));
    }

    static {
        MEDIA_TYPE_SHORTCUTS = new HashMap<String, String>();
        MEDIA_TYPE_SHORTCUTS.put("json", "application/json");
        MEDIA_TYPE_SHORTCUTS.put("text", "text/*");
        MEDIA_TYPE_SHORTCUTS.put("xml", "application/xml");
        MEDIA_TYPE_SHORTCUTS.put("atom", "application/atom+xml");
        MEDIA_TYPE_SHORTCUTS.put("html", "text/html");
        MEDIA_TYPE_SHORTCUTS.put("wadl", "application/vnd.sun.wadl+xml");
        PATHS_TO_SKIP = new HashSet<String>();
        PATHS_TO_SKIP.add("swagger.json");
        PATHS_TO_SKIP.add("swagger.yaml");
        PATHS_TO_SKIP.add("openapi.json");
        PATHS_TO_SKIP.add("openapi.yaml");
    }
}

