/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.multipart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

public class MultipartBody {
    public static final String INBOUND_MESSAGE_ATTACHMENTS = "org.apache.cxf.jaxrs.attachments.inbound";
    public static final String OUTBOUND_MESSAGE_ATTACHMENTS = "org.apache.cxf.jaxrs.attachments.outbound";
    private static final MediaType MULTIPART_RELATED_TYPE = JAXRSUtils.toMediaType("multipart/related");
    private List<Attachment> atts;
    private MediaType mt;

    public MultipartBody(Attachment att) {
        this(Collections.singletonList(att));
    }

    public MultipartBody(List<Attachment> atts) {
        this(atts, false);
    }

    public MultipartBody(List<Attachment> atts, boolean outbound) {
        this(atts, MULTIPART_RELATED_TYPE, outbound);
    }

    public MultipartBody(boolean outbound) {
        this(new ArrayList<Attachment>(), MULTIPART_RELATED_TYPE, outbound);
    }

    public MultipartBody(List<Attachment> atts, MediaType mt, boolean outbound) {
        this.atts = atts;
        this.mt = mt == null ? MULTIPART_RELATED_TYPE : mt;
    }

    public MediaType getType() {
        return this.mt;
    }

    public List<Attachment> getAllAttachments() {
        return this.atts;
    }

    public List<Attachment> getChildAttachments() {
        return this.atts.subList(1, this.atts.size());
    }

    public Attachment getRootAttachment() {
        return !this.atts.isEmpty() ? this.atts.get(0) : null;
    }

    public Attachment getAttachment(String contentId) {
        for (Attachment a : this.atts) {
            if (contentId.equalsIgnoreCase(a.getContentId())) {
                return a;
            }
            ContentDisposition cd2 = a.getContentDisposition();
            if (cd2 == null || !contentId.equals(cd2.getParameter("name"))) continue;
            return a;
        }
        return null;
    }

    public <T> T getAttachmentObject(String contentId, Class<T> cls) {
        Attachment att = this.getAttachment(contentId);
        if (att != null) {
            return att.getObject(cls);
        }
        return null;
    }
}

