/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.common.openapi;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxrs.utils.ResourceUtils;

public interface SwaggerProperties {
    public static final String DEFAULT_PROPS_LOCATION = "/swagger.properties";
    public static final String DEFAULT_LICENSE_VALUE = "Apache 2.0 License";
    public static final String DEFAULT_LICENSE_URL = "http://www.apache.org/licenses/LICENSE-2.0.html";
    public static final String RESOURCE_PACKAGE_PROPERTY = "resource.package";
    public static final String TITLE_PROPERTY = "title";
    public static final String VERSION_PROPERTY = "version";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String CONTACT_PROPERTY = "contact";
    public static final String LICENSE_PROPERTY = "license";
    public static final String LICENSE_URL_PROPERTY = "license.url";
    public static final String TERMS_URL_PROPERTY = "terms.url";
    public static final String PRETTY_PRINT_PROPERTY = "pretty.print";
    public static final String FILTER_CLASS_PROPERTY = "filter.class";

    default public Properties getSwaggerProperties(String location, Bus bus) {
        Properties props = null;
        try (InputStream is = ResourceUtils.getClasspathResourceStream(location, this.getClass(), bus);){
            if (is != null) {
                props = new Properties();
                props.load(is);
            }
        }
        catch (IOException ignore) {
            props = null;
        }
        return props;
    }
}

