/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spring;

import java.util.HashMap;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.spring.JaxRsConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;

@Import(value={JaxRsConfig.class})
@ComponentScan(includeFilters={@ComponentScan.Filter(type=FilterType.ANNOTATION, value={javax.ws.rs.ext.Provider.class, Provider.class})})
public abstract class AbstractJaxRsClientConfiguration
implements ApplicationContextAware {
    protected ApplicationContext context;
    @Autowired
    private Bus bus;
    @Value(value="${cxf.jaxrs.client.address}")
    private String address;
    @Value(value="${cxf.jaxrs.client.thread-safe:false}")
    private Boolean threadSafe;
    @Value(value="${cxf.jaxrs.client.headers.accept:}")
    private String accept;
    @Value(value="${cxf.jaxrs.client.headers.content-type:}")
    private String contentType;

    protected Client createClient() {
        JAXRSClientFactoryBean bean2 = new JAXRSClientFactoryBean();
        bean2.setBus(this.bus);
        bean2.setAddress(this.address);
        bean2.setThreadSafe(this.threadSafe);
        this.setJaxrsResources(bean2);
        for (String beanName : this.context.getBeanDefinitionNames()) {
            if (this.context.findAnnotationOnBean(beanName, javax.ws.rs.ext.Provider.class) != null) {
                bean2.setProvider(this.context.getBean(beanName));
                continue;
            }
            if (this.context.findAnnotationOnBean(beanName, Provider.class) == null) continue;
            this.addCxfProvider(bean2, this.context.getBean(beanName));
        }
        HashMap<String, String> extraHeaders = new HashMap<String, String>();
        if (!StringUtils.isEmpty(this.accept)) {
            extraHeaders.put("Accept", this.accept);
        }
        if (!StringUtils.isEmpty(this.contentType)) {
            extraHeaders.put("Content-Type", this.contentType);
        }
        if (!extraHeaders.isEmpty()) {
            bean2.setHeaders(extraHeaders);
        }
        return bean2.create();
    }

    protected void addCxfProvider(JAXRSClientFactoryBean factory, Object provider) {
        Provider ann = provider.getClass().getAnnotation(Provider.class);
        if (ann.scope() == Provider.Scope.Server) {
            return;
        }
        if (ann.value() == Provider.Type.Feature) {
            factory.getFeatures().add((Feature)provider);
        } else if (ann.value() == Provider.Type.InInterceptor) {
            factory.getInInterceptors().add((Interceptor)provider);
        } else if (ann.value() == Provider.Type.OutInterceptor) {
            factory.getOutInterceptors().add((Interceptor)provider);
        }
    }

    protected abstract void setJaxrsResources(JAXRSClientFactoryBean var1);

    @Override
    public void setApplicationContext(ApplicationContext ac) throws BeansException {
        this.context = ac;
    }
}

