/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spec;

import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.impl.AbstractRequestContextImpl;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;

public class ClientRequestContextImpl
extends AbstractRequestContextImpl
implements ClientRequestContext {
    public ClientRequestContextImpl(Message m3, boolean responseContext) {
        super(m3, responseContext);
    }

    @Override
    public MediaType getMediaType() {
        if (!this.hasEntity()) {
            return null;
        }
        Object mt = HttpUtils.getModifiableHeaders(this.m).getFirst("Content-Type");
        return mt instanceof MediaType ? (MediaType)mt : JAXRSUtils.toMediaType(mt.toString());
    }

    @Override
    public Client getClient() {
        return (Client)this.m.getContextualProperty(Client.class.getName());
    }

    @Override
    public Configuration getConfiguration() {
        ClientProviderFactory cpf = ClientProviderFactory.getInstance(this.m);
        return cpf.getConfiguration(this.m);
    }

    private Object getMessageContent() {
        MessageContentsList objs = MessageContentsList.getContentsList(this.m);
        if (objs == null || objs.isEmpty()) {
            return null;
        }
        return objs.get(0);
    }

    @Override
    public Object getEntity() {
        return this.getMessageContent();
    }

    @Override
    public Annotation[] getEntityAnnotations() {
        Annotation[] anns = (Annotation[])this.m.get(Annotation.class.getName());
        return anns == null ? new Annotation[]{} : anns;
    }

    @Override
    public Class<?> getEntityClass() {
        Object entity = this.getEntity();
        return entity == null ? null : entity.getClass();
    }

    @Override
    public Type getEntityType() {
        Class<?> t = this.m.get(Type.class);
        return t != null ? t : this.getEntityClass();
    }

    @Override
    public OutputStream getEntityStream() {
        return this.m.getContent(OutputStream.class);
    }

    @Override
    public boolean hasEntity() {
        return this.getEntity() != null;
    }

    @Override
    public void setEntity(Object entity, Annotation[] anns, MediaType mt) {
        if (mt != null) {
            MultivaluedMap<String, Object> headers = this.getHeaders();
            headers.putSingle("Content-Type", mt);
            this.m.put("Content-Type", mt.toString());
        }
        if (anns != null) {
            this.m.put(Annotation.class.getName(), anns);
        }
        this.doSetEntity(entity);
    }

    @Override
    public void setEntity(Object entity) {
        this.doSetEntity(entity);
    }

    private void doSetEntity(Object entity) {
        Object actualEntity = InjectionUtils.getEntity(entity);
        this.m.setContent(List.class, actualEntity == null ? new MessageContentsList() : new MessageContentsList(actualEntity));
        Type type = null;
        if (entity != null) {
            type = GenericEntity.class.isAssignableFrom(entity.getClass()) ? ((GenericEntity)entity).getType() : entity.getClass();
            this.m.put(Type.class, type);
            this.m.remove("org.apache.cxf.empty.request");
        }
    }

    @Override
    public URI getUri() {
        String requestURI = (String)this.m.get("org.apache.cxf.request.uri");
        if (requestURI == null) {
            return null;
        }
        if (requestURI.startsWith("/")) {
            String endpointAddress = (String)this.m.get(Message.ENDPOINT_ADDRESS);
            requestURI = requestURI.length() == 1 ? endpointAddress : endpointAddress + requestURI;
        }
        return URI.create(requestURI);
    }

    @Override
    public void setEntityStream(OutputStream os) {
        this.m.setContent(OutputStream.class, os);
    }

    @Override
    public void setUri(URI requestURI) {
        this.m.put(Message.ENDPOINT_ADDRESS, requestURI.toString());
        this.m.put("org.apache.cxf.request.uri", requestURI.toString());
    }

    @Override
    public MultivaluedMap<String, Object> getHeaders() {
        this.h = null;
        return HttpUtils.getModifiableHeaders(this.m);
    }

    @Override
    public MultivaluedMap<String, String> getStringHeaders() {
        this.h = null;
        return HttpUtils.getModifiableStringHeaders(this.m);
    }
}

