/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.ext.ParamConverter;
import org.apache.cxf.jaxrs.utils.HttpUtils;

public class UrlEncodingParamConverter
implements ParamConverter<String> {
    private Set<Character> encodeClientParametersList;

    public UrlEncodingParamConverter() {
        this(null);
    }

    public UrlEncodingParamConverter(String encodeClientParametersListStr) {
        if (encodeClientParametersListStr != null) {
            String[] chars = encodeClientParametersListStr.trim().split(" ");
            this.encodeClientParametersList = new HashSet<Character>();
            for (String ch : chars) {
                this.encodeClientParametersList.add(Character.valueOf(ch.charAt(0)));
            }
        }
    }

    @Override
    public String fromString(String s2) {
        return HttpUtils.urlDecode(s2);
    }

    @Override
    public String toString(String s2) {
        if (this.encodeClientParametersList == null || this.encodeClientParametersList.isEmpty()) {
            return HttpUtils.urlEncode(s2);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s2.length(); ++i) {
            Character ch = Character.valueOf(s2.charAt(i));
            if (this.encodeClientParametersList.contains(ch)) {
                sb.append(HttpUtils.urlEncode(ch.toString()));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

