/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.lang.reflect.InvocationHandler;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.ProxyHelper;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.InvocationHandlerAware;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.ThreadLocalClientState;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.model.UserResource;

public final class JAXRSClientFactory {
    private JAXRSClientFactory() {
    }

    public static <T> T create(String baseAddress, Class<T> cls) {
        return JAXRSClientFactory.create(URI.create(baseAddress), cls);
    }

    public static <T> T create(String baseAddress, Class<T> cls, ClassLoader loader) {
        JAXRSClientFactoryBean bean2 = JAXRSClientFactory.getBean(baseAddress, cls, null);
        bean2.setClassLoader(loader);
        return bean2.create(cls, new Object[0]);
    }

    public static <T> T create(URI baseURI, Class<T> cls) {
        return JAXRSClientFactory.create(baseURI, cls, false);
    }

    public static <T> T create(URI baseURI, Class<T> cls, boolean inheritHeaders) {
        JAXRSClientFactoryBean bean2 = JAXRSClientFactory.getBean(baseURI.toString(), cls, null);
        bean2.setInheritHeaders(inheritHeaders);
        return bean2.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, Map<String, Object> properties) {
        JAXRSClientFactoryBean bean2 = JAXRSClientFactory.getBean(baseAddress, cls, null);
        bean2.setProperties(properties);
        return bean2.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, String configLocation) {
        JAXRSClientFactoryBean bean2 = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        return bean2.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, String configLocation, Object ... varValues) {
        JAXRSClientFactoryBean bean2 = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        return bean2.create(cls, varValues);
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers) {
        return JAXRSClientFactory.create(baseAddress, cls, providers, null);
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers, boolean threadSafe) {
        return JAXRSClientFactory.create(baseAddress, cls, providers, Collections.emptyMap(), threadSafe);
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers, Map<String, Object> properties, boolean threadSafe) {
        JAXRSClientFactoryBean bean2 = JAXRSClientFactory.getBean(baseAddress, cls, null);
        bean2.setProviders(providers);
        bean2.setProperties(properties);
        if (threadSafe) {
            bean2.setInitialState(new ThreadLocalClientState(baseAddress, properties));
        }
        return bean2.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers, long timeToKeepState) {
        JAXRSClientFactoryBean bean2 = JAXRSClientFactory.getBean(baseAddress, cls, null);
        bean2.setProviders(providers);
        bean2.setInitialState(new ThreadLocalClientState(baseAddress, timeToKeepState));
        return bean2.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers, String configLocation) {
        JAXRSClientFactoryBean bean2 = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        bean2.setProviders(providers);
        return bean2.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers, List<Feature> features, String configLocation) {
        JAXRSClientFactoryBean bean2 = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        bean2.setProviders(providers);
        bean2.setFeatures(features);
        return bean2.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, String username, String password, String configLocation) {
        JAXRSClientFactoryBean bean2 = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        bean2.setUsername(username);
        bean2.setPassword(password);
        return bean2.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers, String username, String password, String configLocation) {
        JAXRSClientFactoryBean bean2 = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        bean2.setUsername(username);
        bean2.setPassword(password);
        bean2.setProviders(providers);
        return bean2.create(cls, new Object[0]);
    }

    public static <T> T createFromModel(String baseAddress, Class<T> cls, String modelRef, String configLocation) {
        return JAXRSClientFactory.createFromModel(baseAddress, cls, modelRef, Collections.emptyList(), configLocation);
    }

    public static <T> T createFromModel(String baseAddress, Class<T> cls, String modelRef, List<?> providers, String configLocation) {
        JAXRSClientFactoryBean bean2 = WebClient.getBean(baseAddress, configLocation);
        bean2.setProviders(providers);
        bean2.setModelRef(modelRef);
        bean2.setServiceClass(cls);
        return bean2.create(cls, new Object[0]);
    }

    public static <T> T createFromModel(String baseAddress, Class<T> cls, String modelRef, List<?> providers, boolean threadSafe) {
        JAXRSClientFactoryBean bean2 = WebClient.getBean(baseAddress, null);
        bean2.setProviders(providers);
        bean2.setModelRef(modelRef);
        bean2.setServiceClass(cls);
        if (threadSafe) {
            bean2.setInitialState(new ThreadLocalClientState(baseAddress));
        }
        return bean2.create(cls, new Object[0]);
    }

    public static <T> T createFromModel(String baseAddress, Class<T> cls, String modelRef, List<?> providers, long timeToKeepState) {
        JAXRSClientFactoryBean bean2 = WebClient.getBean(baseAddress, null);
        bean2.setProviders(providers);
        bean2.setModelRef(modelRef);
        bean2.setServiceClass(cls);
        bean2.setInitialState(new ThreadLocalClientState(baseAddress, timeToKeepState));
        return bean2.create(cls, new Object[0]);
    }

    public static <T> T createFromModel(String baseAddress, Class<T> cls, List<UserResource> modelBeans, String configLocation) {
        return JAXRSClientFactory.createFromModel(baseAddress, cls, modelBeans, Collections.emptyList(), configLocation);
    }

    public static <T> T createFromModel(String baseAddress, Class<T> cls, List<UserResource> modelBeans, List<?> providers, String configLocation) {
        JAXRSClientFactoryBean bean2 = WebClient.getBean(baseAddress, configLocation);
        bean2.setProviders(providers);
        bean2.setModelBeans(modelBeans);
        bean2.setServiceClass(cls);
        return bean2.create(cls, new Object[0]);
    }

    public static <T> T fromClient(Client client, Class<T> cls) {
        return JAXRSClientFactory.fromClient(client, cls, false);
    }

    public static <T> T fromClient(Client client, Class<T> cls, boolean inheritHeaders) {
        JAXRSClientFactoryBean bean2 = JAXRSClientFactory.getBean(client.getCurrentURI().toString(), cls, null);
        bean2.setInheritHeaders(inheritHeaders);
        ClientState clientState = WebClient.getClientState(client);
        T proxy = null;
        if (clientState == null) {
            proxy = bean2.create(cls, new Object[0]);
            if (inheritHeaders) {
                WebClient.client(proxy).headers(client.getHeaders());
            }
        } else {
            MultivaluedMap<String, String> headers = inheritHeaders ? client.getHeaders() : null;
            bean2.setInitialState(clientState.newState(client.getCurrentURI(), headers, null, bean2.getProperties()));
            proxy = bean2.create(cls, new Object[0]);
        }
        WebClient.copyProperties(WebClient.client(proxy), client);
        return proxy;
    }

    static <T> T createProxy(Class<T> cls, ClassLoader loader, InvocationHandler handler) {
        return cls.cast(ProxyHelper.getProxy(loader == null ? cls.getClassLoader() : loader, new Class[]{Client.class, InvocationHandlerAware.class, cls}, handler));
    }

    private static JAXRSClientFactoryBean getBean(String baseAddress, Class<?> cls, String configLocation) {
        JAXRSClientFactoryBean bean2 = WebClient.getBean(baseAddress, configLocation);
        bean2.setServiceClass(cls);
        return bean2;
    }
}

