/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.RxInvokerProvider;
import javax.ws.rs.core.Configuration;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.message.Message;

public final class ClientProviderFactory
extends ProviderFactory {
    private List<ProviderInfo<ClientRequestFilter>> clientRequestFilters = new ArrayList<ProviderInfo<ClientRequestFilter>>(1);
    private List<ProviderInfo<ClientResponseFilter>> clientResponseFilters = new ArrayList<ProviderInfo<ClientResponseFilter>>(1);
    private List<ProviderInfo<ResponseExceptionMapper<?>>> responseExceptionMappers = new ArrayList(1);
    private RxInvokerProvider<?> rxInvokerProvider;

    private ClientProviderFactory(Bus bus) {
        super(bus);
    }

    public static ClientProviderFactory createInstance(Bus bus) {
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus();
        }
        ClientProviderFactory factory = new ClientProviderFactory(bus);
        ProviderFactory.initFactory(factory);
        factory.setBusProviders();
        return factory;
    }

    public static ClientProviderFactory getInstance(Message m3) {
        return ClientProviderFactory.getInstance(m3.getExchange().getEndpoint());
    }

    public static ClientProviderFactory getInstance(Endpoint e) {
        return (ClientProviderFactory)e.get("org.apache.cxf.jaxrs.client.ClientProviderFactory");
    }

    @Override
    protected void setProviders(boolean custom, boolean busGlobal, Object ... providers) {
        List<ProviderInfo<? extends Object>> theProviders = this.prepareProviders(custom, busGlobal, providers, null);
        super.setCommonProviders(theProviders);
        for (ProviderInfo<? extends Object> provider : theProviders) {
            Class<?> providerCls = ClassHelper.getRealClass(this.getBus(), provider.getProvider());
            if (providerCls == Object.class) {
                providerCls = provider.getProvider().getClass();
            }
            if (ClientProviderFactory.filterContractSupported(provider, providerCls, ClientRequestFilter.class)) {
                this.addProviderToList(this.clientRequestFilters, provider);
            }
            if (ClientProviderFactory.filterContractSupported(provider, providerCls, ClientResponseFilter.class)) {
                this.addProviderToList(this.clientResponseFilters, provider);
            }
            if (ResponseExceptionMapper.class.isAssignableFrom(providerCls)) {
                this.addProviderToList(this.responseExceptionMappers, provider);
            }
            if (!RxInvokerProvider.class.isAssignableFrom(providerCls)) continue;
            this.rxInvokerProvider = (RxInvokerProvider)RxInvokerProvider.class.cast(provider.getProvider());
        }
        Collections.sort(this.clientRequestFilters, new ProviderFactory.BindingPriorityComparator(ClientRequestFilter.class, true));
        Collections.sort(this.clientResponseFilters, new ProviderFactory.BindingPriorityComparator(ClientResponseFilter.class, false));
        this.injectContextProxies(this.responseExceptionMappers, this.clientRequestFilters, this.clientResponseFilters);
    }

    public <T extends Throwable> ResponseExceptionMapper<T> createResponseExceptionMapper(Message m3, Class<?> paramType) {
        return this.responseExceptionMappers.stream().filter(em -> this.handleMapper(em, paramType, m3, ResponseExceptionMapper.class, true)).map(ProviderInfo::getProvider).sorted(new ProviderFactory.ClassComparator(paramType)).findFirst().orElse(null);
    }

    @Override
    public void clearProviders() {
        super.clearProviders();
        this.responseExceptionMappers.clear();
        this.clientRequestFilters.clear();
        this.clientResponseFilters.clear();
    }

    public List<ProviderInfo<ClientRequestFilter>> getClientRequestFilters() {
        return Collections.unmodifiableList(this.clientRequestFilters);
    }

    public List<ProviderInfo<ClientResponseFilter>> getClientResponseFilters() {
        return Collections.unmodifiableList(this.clientResponseFilters);
    }

    @Override
    public Configuration getConfiguration(Message m3) {
        return (Configuration)m3.getExchange().getOutMessage().getContextualProperty(Configuration.class.getName());
    }

    public RxInvokerProvider<?> getRxInvokerProvider() {
        return this.rxInvokerProvider;
    }
}

