/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.jaxrs.impl.AsyncResponseImpl;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ResourceContextImpl;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ApplicationInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.invoker.AbstractInvoker;

public class JAXRSInvoker
extends AbstractInvoker {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSInvoker.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSInvoker.class);
    private static final String SERVICE_LOADER_AS_CONTEXT = "org.apache.cxf.serviceloader-context";
    private static final String SERVICE_OBJECT_SCOPE = "org.apache.cxf.service.scope";
    private static final String REQUEST_SCOPE = "request";
    private static final String LAST_SERVICE_OBJECT = "org.apache.cxf.service.object.last";
    private static final String PROXY_INVOCATION_ERROR_FRAGMENT = "object is not an instance of declaring class";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Exchange exchange2, Object request) {
        MessageContentsList responseList = this.checkExchangeForResponse(exchange2);
        if (responseList != null) {
            return responseList;
        }
        AsyncResponse asyncResp = exchange2.get(AsyncResponse.class);
        if (asyncResp != null) {
            AsyncResponseImpl asyncImpl = (AsyncResponseImpl)asyncResp;
            asyncImpl.prepareContinuation();
            try {
                asyncImpl.handleTimeout();
                return this.handleAsyncResponse(exchange2, asyncImpl);
            }
            catch (Throwable t) {
                return this.handleAsyncFault(exchange2, asyncImpl, t);
            }
        }
        ResourceProvider provider = this.getResourceProvider(exchange2);
        Object rootInstance = null;
        Message inMessage = exchange2.getInMessage();
        try {
            rootInstance = this.getServiceObject(exchange2);
            Object serviceObject = this.getActualServiceObject(exchange2, rootInstance);
            Object object = this.invoke(exchange2, request, serviceObject);
            return object;
        }
        catch (WebApplicationException ex) {
            responseList = this.checkExchangeForResponse(exchange2);
            if (responseList != null) {
                MessageContentsList messageContentsList = responseList;
                return messageContentsList;
            }
            Object object = this.handleFault(ex, inMessage);
            return object;
        }
        finally {
            boolean suspended = this.isSuspended(exchange2);
            if (suspended || exchange2.isOneWay() || inMessage.get("thread.context.switched") != null) {
                ServerProviderFactory.clearThreadLocalProxies(inMessage);
            }
            if (suspended || this.isServiceObjectRequestScope(inMessage)) {
                this.persistRoots(exchange2, rootInstance, provider);
            } else {
                provider.releaseInstance(inMessage, rootInstance);
            }
        }
    }

    private boolean isSuspended(Exchange exchange2) {
        return exchange2.getInMessage().getInterceptorChain().getState() == InterceptorChain.State.SUSPENDED;
    }

    private Object handleAsyncResponse(Exchange exchange2, AsyncResponseImpl ar) {
        Object asyncObj = ar.getResponseObject();
        if (asyncObj instanceof Throwable) {
            Throwable throwable;
            Throwable cause = throwable = (Throwable)asyncObj;
            if (throwable instanceof CompletionException) {
                cause = throwable.getCause();
            }
            return this.handleAsyncFault(exchange2, ar, cause != null ? cause : throwable);
        }
        this.setResponseContentTypeIfNeeded(exchange2.getInMessage(), asyncObj);
        return new MessageContentsList(asyncObj);
    }

    private Object handleAsyncFault(Exchange exchange2, AsyncResponseImpl ar, Throwable t) {
        try {
            return this.handleFault(new Fault(t), exchange2.getInMessage(), null, null);
        }
        catch (Fault ex) {
            ar.setUnmappedThrowable(ex.getCause() == null ? ex : ex.getCause());
            if (this.isSuspended(exchange2)) {
                ar.reset();
                exchange2.getInMessage().getInterceptorChain().unpause();
            }
            return new MessageContentsList(Response.serverError().build());
        }
    }

    private void persistRoots(Exchange exchange2, Object rootInstance, Object provider) {
        exchange2.put("service.root.instance", rootInstance);
        exchange2.put("service.root.provider", provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Exchange exchange2, Object request, Object resourceObject) {
        ApplicationInfo appProvider;
        OperationResourceInfo ori = exchange2.get(OperationResourceInfo.class);
        ClassResourceInfo cri = ori.getClassResourceInfo();
        Message inMessage = exchange2.getInMessage();
        ServerProviderFactory providerFactory = ServerProviderFactory.getInstance(inMessage);
        cri.injectContexts(resourceObject, ori, inMessage);
        if (cri.isRoot() && (appProvider = providerFactory.getApplicationProvider()) != null) {
            InjectionUtils.injectContexts(appProvider.getProvider(), appProvider, inMessage);
        }
        Method methodToInvoke = this.getMethodToInvoke(cri, ori, resourceObject);
        MessageContentsList params = null;
        if (request instanceof List) {
            params = CastUtils.cast((List)request);
        } else if (request != null) {
            params = new MessageContentsList(request);
        }
        Object result = null;
        ClassLoaderUtils.ClassLoaderHolder contextLoader = null;
        AsyncResponseImpl asyncResponse = null;
        try {
            if (this.setServiceLoaderAsContextLoader(inMessage)) {
                contextLoader = ClassLoaderUtils.setThreadContextClassloader(resourceObject.getClass().getClassLoader());
            }
            if (!ori.isSubResourceLocator()) {
                asyncResponse = (AsyncResponseImpl)inMessage.get(AsyncResponse.class);
            }
            result = this.invoke(exchange2, resourceObject, methodToInvoke, params);
            if (asyncResponse == null && !ori.isSubResourceLocator()) {
                asyncResponse = this.checkFutureResponse(inMessage, JAXRSInvoker.checkResultObject(result));
            }
            if (asyncResponse != null) {
                if (!asyncResponse.suspendContinuationIfNeeded()) {
                    result = this.handleAsyncResponse(exchange2, asyncResponse);
                } else {
                    providerFactory.clearThreadLocalProxies();
                }
            }
        }
        catch (Fault ex) {
            Object faultResponse = asyncResponse != null ? this.handleAsyncFault(exchange2, asyncResponse, ex.getCause() == null ? ex : ex.getCause()) : this.handleFault(ex, inMessage, cri, methodToInvoke);
            Object object = faultResponse;
            return object;
        }
        finally {
            exchange2.put(LAST_SERVICE_OBJECT, resourceObject);
            if (contextLoader != null) {
                contextLoader.reset();
            }
        }
        ClassResourceInfo subCri = null;
        if (ori.isSubResourceLocator()) {
            try {
                MultivaluedMap<String, String> values = this.getTemplateValues(inMessage);
                String subResourcePath = values.getFirst("FINAL_MATCH_GROUP");
                String httpMethod = (String)inMessage.get("org.apache.cxf.request.method");
                String contentType = (String)inMessage.get("Content-Type");
                if (contentType == null) {
                    contentType = "*/*";
                }
                List acceptContentType = (List)exchange2.get("Accept");
                result = JAXRSInvoker.checkSubResultObject(result, subResourcePath);
                Class<?> subResponseType = null;
                if (result.getClass() == Class.class) {
                    ResourceContextImpl rc = new ResourceContextImpl(inMessage, ori);
                    result = rc.getResource((Class)result);
                    subResponseType = InjectionUtils.getActualType(methodToInvoke.getGenericReturnType());
                } else {
                    subResponseType = methodToInvoke.getReturnType();
                }
                subCri = cri.getSubResource(subResponseType, ClassHelper.getRealClass(exchange2.getBus(), result), result);
                if (subCri == null) {
                    org.apache.cxf.common.i18n.Message errorM = new org.apache.cxf.common.i18n.Message("NO_SUBRESOURCE_FOUND", BUNDLE, subResourcePath);
                    LOG.severe(errorM.toString());
                    throw ExceptionUtils.toNotFoundException(null, null);
                }
                OperationResourceInfo subOri = JAXRSUtils.findTargetMethod(Collections.singletonMap(subCri, values), inMessage, httpMethod, values, contentType, acceptContentType);
                exchange2.put(OperationResourceInfo.class, subOri);
                inMessage.put("jaxrs.template.parameters", values);
                if (!subOri.isSubResourceLocator() && JAXRSUtils.runContainerRequestFilters(providerFactory, inMessage, false, subOri.getNameBindings())) {
                    return new MessageContentsList(exchange2.get(Response.class));
                }
                List<Object> newParams = JAXRSUtils.processParameters(subOri, values, inMessage);
                inMessage.setContent(List.class, newParams);
                return this.invoke(exchange2, newParams, result);
            }
            catch (IOException ex) {
                Response resp = JAXRSUtils.convertFaultToResponse(ex, inMessage);
                if (resp == null) {
                    resp = JAXRSUtils.convertFaultToResponse(ex, inMessage);
                }
                return new MessageContentsList(resp);
            }
            catch (WebApplicationException ex) {
                Response excResponse = JAXRSUtils.noResourceMethodForOptions(ex.getResponse(), (String)inMessage.get("org.apache.cxf.request.method")) ? JAXRSUtils.createResponse(Collections.singletonList(subCri), null, null, 200, true) : JAXRSUtils.convertFaultToResponse(ex, inMessage);
                return new MessageContentsList(excResponse);
            }
        }
        this.setResponseContentTypeIfNeeded(inMessage, result);
        return result;
    }

    protected AsyncResponseImpl checkFutureResponse(Message inMessage, Object result) {
        if (result instanceof CompletionStage) {
            CompletionStage stage = (CompletionStage)result;
            AsyncResponseImpl asyncResponse = new AsyncResponseImpl(inMessage);
            stage.whenComplete((v, t) -> {
                if (t instanceof CancellationException) {
                    asyncResponse.cancel();
                } else {
                    asyncResponse.resume(v != null ? v : t);
                }
            });
            return asyncResponse;
        }
        return null;
    }

    protected Method getMethodToInvoke(ClassResourceInfo cri, OperationResourceInfo ori, Object resourceObject) {
        Method resourceMethod = cri.getMethodDispatcher().getMethod(ori);
        Method methodToInvoke = null;
        if (Proxy.class.isInstance(resourceObject)) {
            methodToInvoke = cri.getMethodDispatcher().getProxyMethod(resourceMethod);
            if (methodToInvoke == null) {
                methodToInvoke = InjectionUtils.checkProxy(resourceMethod, resourceObject);
                cri.getMethodDispatcher().addProxyMethod(resourceMethod, methodToInvoke);
            }
        } else {
            methodToInvoke = resourceMethod;
        }
        return methodToInvoke;
    }

    private MessageContentsList checkExchangeForResponse(Exchange exchange2) {
        Response r = exchange2.get(Response.class);
        if (r != null) {
            JAXRSUtils.setMessageContentType(exchange2.getInMessage(), r);
            return new MessageContentsList(r);
        }
        return null;
    }

    private void setResponseContentTypeIfNeeded(Message inMessage, Object response) {
        if (response instanceof Response) {
            JAXRSUtils.setMessageContentType(inMessage, (Response)response);
        }
    }

    private Object handleFault(Throwable ex, Message inMessage) {
        return this.handleFault(new Fault(ex), inMessage, null, null);
    }

    private Object handleFault(Fault ex, Message inMessage, ClassResourceInfo cri, Method methodToInvoke) {
        Response excResponse;
        String errorMessage = ex.getMessage();
        if (errorMessage != null && cri != null && errorMessage.contains(PROXY_INVOCATION_ERROR_FRAGMENT)) {
            org.apache.cxf.common.i18n.Message errorM = new org.apache.cxf.common.i18n.Message("PROXY_INVOCATION_FAILURE", BUNDLE, methodToInvoke, cri.getServiceClass().getName());
            LOG.severe(errorM.toString());
        }
        if ((excResponse = JAXRSUtils.convertFaultToResponse(ex.getCause() == null ? ex : ex.getCause(), inMessage)) == null) {
            inMessage.getExchange().put(Message.PROPOGATE_EXCEPTION, ExceptionUtils.propogateException(inMessage));
            throw ex;
        }
        return new MessageContentsList(excResponse);
    }

    protected MultivaluedMap<String, String> getTemplateValues(Message msg) {
        MetadataMap<String, String> values = new MetadataMap<String, String>();
        MultivaluedMap oldValues = (MultivaluedMap)msg.get("jaxrs.template.parameters");
        if (oldValues != null) {
            values.putAll(oldValues);
        }
        return values;
    }

    private boolean setServiceLoaderAsContextLoader(Message inMessage) {
        Object en = inMessage.getContextualProperty(SERVICE_LOADER_AS_CONTEXT);
        return Boolean.TRUE.equals(en) || "true".equals(en);
    }

    private boolean isServiceObjectRequestScope(Message inMessage) {
        Object scope = inMessage.getContextualProperty(SERVICE_OBJECT_SCOPE);
        return REQUEST_SCOPE.equals(scope);
    }

    private ResourceProvider getResourceProvider(Exchange exchange2) {
        Object provider = exchange2.remove("service.root.provider");
        if (provider == null) {
            OperationResourceInfo ori = exchange2.get(OperationResourceInfo.class);
            ClassResourceInfo cri = ori.getClassResourceInfo();
            return cri.getResourceProvider();
        }
        return (ResourceProvider)provider;
    }

    @Override
    public Object getServiceObject(Exchange exchange2) {
        Object root = exchange2.remove("service.root.instance");
        if (root != null) {
            return root;
        }
        OperationResourceInfo ori = exchange2.get(OperationResourceInfo.class);
        ClassResourceInfo cri = ori.getClassResourceInfo();
        return cri.getResourceProvider().getInstance(exchange2.getInMessage());
    }

    protected Object getActualServiceObject(Exchange exchange2, Object rootInstance) {
        Object last = exchange2.get(LAST_SERVICE_OBJECT);
        return last != null ? last : rootInstance;
    }

    private static Object checkResultObject(Object result) {
        if (result != null) {
            if (result instanceof MessageContentsList) {
                result = ((MessageContentsList)result).get(0);
            } else if (result instanceof List) {
                result = ((List)result).get(0);
            } else if (result.getClass().isArray()) {
                result = ((Object[])result)[0];
            }
        }
        return result;
    }

    private static Object checkSubResultObject(Object result, String subResourcePath) {
        if ((result = JAXRSInvoker.checkResultObject(result)) == null) {
            org.apache.cxf.common.i18n.Message errorM = new org.apache.cxf.common.i18n.Message("NULL_SUBRESOURCE", BUNDLE, subResourcePath);
            LOG.info(errorM.toString());
            throw ExceptionUtils.toNotFoundException(null, null);
        }
        return result;
    }
}

