/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Logging;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.ext.logging.event.PrintWriterEventSender;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.factory.FactoryBeanListenerManager;

@Deprecated
public class OldLoggingFactoryBeanListener
implements FactoryBeanListener {
    public OldLoggingFactoryBeanListener(Bus b) {
        FactoryBeanListenerManager m3 = b.getExtension(FactoryBeanListenerManager.class);
        for (FactoryBeanListener f : m3.getListeners()) {
            if (!"OldLoggingFactoryBeanListener".equals(f.getClass().getSimpleName())) continue;
            m3.removeListener(f);
        }
    }

    @Override
    public void handleEvent(FactoryBeanListener.Event ev, AbstractServiceFactoryBean factory, Object ... args) {
        switch (ev) {
            case ENDPOINT_SELECTED: {
                Class cls = (Class)args[2];
                Endpoint ep = (Endpoint)args[1];
                Bus bus = factory.getBus();
                if (cls == null) {
                    return;
                }
                this.addLoggingSupport(ep, bus, cls.getAnnotation(Logging.class));
                break;
            }
            case SERVER_CREATED: {
                Class cls = (Class)args[2];
                if (cls == null) {
                    return;
                }
                Server server = (Server)args[0];
                Bus bus = factory.getBus();
                this.addLoggingSupport(server.getEndpoint(), bus, cls.getAnnotation(Logging.class));
                break;
            }
        }
    }

    private LogEventSender createEventSender(String location) {
        if (StringUtils.isEmpty(location)) {
            return null;
        }
        if ("<stdout>".equals(location)) {
            return new PrintWriterEventSender(System.out);
        }
        if ("<stderr>".equals(location)) {
            return new PrintWriterEventSender(System.err);
        }
        if (location.startsWith("file:")) {
            try {
                URI uri = new URI(location);
                File file = new File(uri);
                PrintWriter writer = new PrintWriter((Writer)new FileWriter(file, true), true);
                return new PrintWriterEventSender(writer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void addLoggingSupport(Endpoint endpoint, Bus bus, Logging annotation) {
        if (annotation != null) {
            LogEventSender out;
            LoggingFeature lf = new LoggingFeature();
            lf.setPrettyLogging(annotation.pretty());
            lf.setLimit(annotation.limit());
            lf.setLogBinary(annotation.showBinary());
            lf.setLogBinary(annotation.showBinary());
            LogEventSender in = this.createEventSender(annotation.outLocation());
            if (in != null) {
                lf.setOutSender(in);
            }
            if ((out = this.createEventSender(annotation.inLocation())) != null) {
                lf.setInSender(out);
            }
            lf.initialize(endpoint, bus);
        }
    }
}

