/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.ext.logging.MaskSensitiveHelper;
import org.apache.cxf.ext.logging.event.DefaultLogEventMapper;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.ext.logging.event.PrettyLoggingFilter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public abstract class AbstractLoggingInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final int DEFAULT_LIMIT = 49152;
    public static final int DEFAULT_THRESHOLD = -1;
    public static final String CONTENT_SUPPRESSED = "--- Content suppressed ---";
    protected static final String LIVE_LOGGING_PROP = "org.apache.cxf.logging.enable";
    protected int limit = 49152;
    protected long threshold = -1L;
    protected boolean logBinary;
    protected boolean logMultipart = true;
    protected LogEventSender sender;
    protected final DefaultLogEventMapper eventMapper = new DefaultLogEventMapper();
    protected final MaskSensitiveHelper maskSensitiveHelper = new MaskSensitiveHelper();
    protected Set<String> sensitiveProtocolHeaderNames = new HashSet<String>();

    public AbstractLoggingInterceptor(String phase, LogEventSender sender) {
        super(phase);
        this.sender = sender;
    }

    protected static boolean isLoggingDisabledNow(Message message) throws Fault {
        Object liveLoggingProp = message.getContextualProperty(LIVE_LOGGING_PROP);
        return liveLoggingProp != null && PropertyUtils.isFalse(liveLoggingProp);
    }

    public void addBinaryContentMediaTypes(String mediaTypes) {
        this.eventMapper.addBinaryContentMediaTypes(mediaTypes);
    }

    public void setLimit(int lim) {
        this.limit = lim;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setInMemThreshold(long t) {
        this.threshold = t;
    }

    public long getInMemThreshold() {
        return this.threshold;
    }

    public void addSensitiveElementNames(Set<String> sensitiveElementNames) {
        this.maskSensitiveHelper.addSensitiveElementNames(sensitiveElementNames);
    }

    public void addSensitiveProtocolHeaderNames(Set<String> protocolHeaderNames) {
        this.sensitiveProtocolHeaderNames.addAll(protocolHeaderNames);
    }

    public void setPrettyLogging(boolean prettyLogging) {
        if (this.sender instanceof PrettyLoggingFilter) {
            ((PrettyLoggingFilter)this.sender).setPrettyLogging(prettyLogging);
        }
    }

    protected boolean shouldLogContent(LogEvent event) {
        return event.isBinaryContent() && this.logBinary || event.isMultipartContent() && this.logMultipart || !event.isBinaryContent() && !event.isMultipartContent();
    }

    public void setLogBinary(boolean logBinary) {
        this.logBinary = logBinary;
    }

    public void setLogMultipart(boolean logMultipart) {
        this.logMultipart = logMultipart;
    }

    public void createExchangeId(Message message) {
        Exchange exchange2 = message.getExchange();
        String exchangeId = (String)exchange2.get("exchangeId");
        if (exchangeId == null) {
            exchangeId = UUID.randomUUID().toString();
            exchange2.put("exchangeId", exchangeId);
        }
    }

    protected String transform(Message message, String originalLogString) {
        return originalLogString;
    }

    protected String maskSensitiveElements(Message message, String originalLogString) {
        return this.maskSensitiveHelper.maskSensitiveElements(message, originalLogString);
    }
}

