/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.models.ArrayModel;
import io.swagger.models.AuthorizationScope;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Method;
import io.swagger.models.ModelImpl;
import io.swagger.models.ParamType;
import io.swagger.models.PassAs;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.SwaggerVersion;
import io.swagger.models.apideclaration.Api;
import io.swagger.models.apideclaration.ApiDeclaration;
import io.swagger.models.apideclaration.ExtendedTypedObject;
import io.swagger.models.apideclaration.Items;
import io.swagger.models.apideclaration.Model;
import io.swagger.models.apideclaration.ModelProperty;
import io.swagger.models.apideclaration.Operation;
import io.swagger.models.apideclaration.ResponseMessage;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.AuthorizationValue;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.parameters.AbstractParameter;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UntypedProperty;
import io.swagger.models.resourcelisting.ApiInfo;
import io.swagger.models.resourcelisting.ApiKeyAuthorization;
import io.swagger.models.resourcelisting.ApiListingReference;
import io.swagger.models.resourcelisting.Authorization;
import io.swagger.models.resourcelisting.AuthorizationCodeGrant;
import io.swagger.models.resourcelisting.BasicAuthorization;
import io.swagger.models.resourcelisting.ImplicitGrant;
import io.swagger.models.resourcelisting.OAuth2Authorization;
import io.swagger.models.resourcelisting.ResourceListing;
import io.swagger.parser.Swagger20Parser;
import io.swagger.parser.SwaggerLegacyParser;
import io.swagger.parser.SwaggerParserExtension;
import io.swagger.parser.util.ClasspathHelper;
import io.swagger.parser.util.RemoteUrl;
import io.swagger.parser.util.SwaggerDeserializationResult;
import io.swagger.report.MessageBuilder;
import io.swagger.transform.migrate.ApiDeclarationMigrator;
import io.swagger.transform.migrate.ResourceListingMigrator;
import io.swagger.util.Json;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerCompatConverter
implements SwaggerParserExtension {
    static Logger LOGGER = LoggerFactory.getLogger(SwaggerCompatConverter.class);

    @Override
    public SwaggerDeserializationResult readWithInfo(JsonNode node) {
        return null;
    }

    @Override
    public SwaggerDeserializationResult readWithInfo(String location, List<AuthorizationValue> auths) {
        SwaggerDeserializationResult result = new SwaggerDeserializationResult();
        try {
            Swagger swagger = this.read(location, auths);
            if (swagger != null) {
                result.setSwagger(swagger);
                JsonNode jsonNode = Json.mapper().convertValue((Object)swagger, JsonNode.class);
                return new Swagger20Parser().readWithInfo(jsonNode);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Swagger read(JsonNode node) throws IOException {
        return null;
    }

    public Swagger read(String input) throws IOException {
        return this.read(input, null);
    }

    @Override
    public Swagger read(String input, List<AuthorizationValue> auths) throws IOException {
        Swagger output = null;
        MessageBuilder migrationMessages = new MessageBuilder();
        SwaggerLegacyParser swaggerParser = new SwaggerLegacyParser();
        ResourceListing resourceListing = null;
        resourceListing = this.readResourceListing(input, migrationMessages, auths);
        ArrayList<ApiDeclaration> apis = new ArrayList<ApiDeclaration>();
        if (resourceListing != null) {
            List<ApiListingReference> refs = resourceListing.getApis();
            boolean readAsSingleFile = false;
            if (refs != null) {
                for (ApiListingReference ref : refs) {
                    ApiDeclaration apiDeclaration = null;
                    ObjectNode node = ref.getExtraFields();
                    JsonNode operations = ((JsonNode)node).get("operations");
                    if (operations != null) {
                        if (!readAsSingleFile) {
                            apiDeclaration = this.readDeclaration(input, migrationMessages, auths);
                            readAsSingleFile = true;
                        }
                    } else {
                        String location = null;
                        if (input.startsWith("http")) {
                            String pathLocation = ref.getPath();
                            if (pathLocation.startsWith("http")) {
                                location = pathLocation;
                            } else if (pathLocation.startsWith("/")) {
                                if (resourceListing.getSwaggerVersion().equals((Object)SwaggerVersion.V1_1) && resourceListing.getExtraFields().get("basePath") != null) {
                                    String basePath = resourceListing.getExtraFields().get("basePath").textValue();
                                    location = basePath + pathLocation;
                                } else {
                                    location = input + pathLocation;
                                }
                            } else {
                                location = input + "/" + pathLocation;
                            }
                        } else {
                            File fileLocation = new File(input);
                            location = ref.getPath().startsWith("/") ? fileLocation.getParent() + ref.getPath() : fileLocation.getParent() + File.separator + ref.getPath();
                        }
                        if (location.indexOf(".{format}") != -1) {
                            location = location.replaceAll("\\.\\{format\\}", ".json");
                        }
                        apiDeclaration = this.readDeclaration(location, migrationMessages, auths);
                    }
                    if (apiDeclaration == null) continue;
                    apis.add(apiDeclaration);
                }
            }
            output = this.convert(resourceListing, apis);
        }
        return output;
    }

    public ResourceListing readResourceListing(String input, MessageBuilder messages, List<AuthorizationValue> auths) {
        ResourceListing output = null;
        JsonNode jsonNode = null;
        try {
            if (input.startsWith("http")) {
                String json = RemoteUrl.urlToString(input, auths);
                jsonNode = Json.mapper().readTree(json);
            } else {
                String fileScheme = "file:";
                java.nio.file.Path path = input.toLowerCase().startsWith("file:") ? Paths.get(URI.create(input)) : Paths.get(input, new String[0]);
                String json = Files.exists(path, new LinkOption[0]) ? FileUtils.readFileToString(path.toFile(), "UTF-8") : ClasspathHelper.loadFileFromClasspath(input);
                jsonNode = Json.mapper().readTree(json);
            }
            if (jsonNode.get("swaggerVersion") == null) {
                return null;
            }
            ResourceListingMigrator migrator = new ResourceListingMigrator();
            JsonNode transformed = migrator.migrate(messages, jsonNode);
            output = Json.mapper().convertValue((Object)transformed, ResourceListing.class);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (Exception e) {
            LOGGER.error("failed to read resource listing", e);
        }
        return output;
    }

    public io.swagger.models.Model convertModel(Model model) {
        ModelImpl output = new ModelImpl();
        output.setName(model.getId());
        output.setDescription(model.getDescription());
        output.setDiscriminator(model.getDiscriminator());
        if (model.getRequired() != null) {
            output.setRequired(model.getRequired());
        }
        for (String key : model.getProperties().keySet()) {
            Property prop = this.convertProperty(model.getProperties().get(key));
            if (prop == null) continue;
            output.addProperty(key, prop);
        }
        return output;
    }

    public Property convertProperty(ModelProperty property) {
        Property output = null;
        output = this.propertyFromTypedObject(property);
        output.setDescription(property.getDescription());
        return output;
    }

    public Parameter convertParameter(io.swagger.models.apideclaration.Parameter param) {
        String format;
        AbstractParameter p;
        AbstractParameter output = null;
        List<String> _enum = param.getEnumValues();
        if (ParamType.PATH.equals((Object)param.getParamType())) {
            p = new PathParameter();
            ((AbstractSerializableParameter)p).setDefaultValue(param.getDefaultValue());
            ((AbstractSerializableParameter)p).setEnum(_enum);
            output = p;
        } else if (ParamType.QUERY.equals((Object)param.getParamType())) {
            p = new QueryParameter();
            ((AbstractSerializableParameter)p).setDefaultValue(param.getDefaultValue());
            ((AbstractSerializableParameter)p).setEnum(_enum);
            output = p;
        } else if (ParamType.HEADER.equals((Object)param.getParamType())) {
            p = new HeaderParameter();
            ((AbstractSerializableParameter)p).setDefaultValue(param.getDefaultValue());
            ((AbstractSerializableParameter)p).setEnum(_enum);
            output = p;
        } else if (ParamType.BODY.equals((Object)param.getParamType())) {
            output = p = new BodyParameter();
        } else if (ParamType.FORM.equals((Object)param.getParamType())) {
            p = new FormParameter();
            ((AbstractSerializableParameter)p).setDefaultValue(param.getDefaultValue());
            ((AbstractSerializableParameter)p).setEnum(_enum);
            output = p;
        }
        output.setName(param.getName());
        output.setDescription(param.getDescription());
        if (param.getRequired() != null) {
            output.setRequired(param.getRequired());
        }
        Object property = null;
        String type = param.getType() == null ? null : param.getType().toString();
        String string = format = param.getFormat() == null ? null : param.getFormat().toString();
        if (null == type) {
            LOGGER.warn("Empty type in Param: " + param);
        }
        if (output instanceof BodyParameter) {
            BodyParameter bp = (BodyParameter)output;
            bp.setSchema(this.modelFromExtendedTypedObject(param));
        } else if (output instanceof SerializableParameter) {
            SerializableParameter sp = (SerializableParameter)((Object)output);
            Property p2 = null;
            if (param.getAllowMultiple() != null && param.getAllowMultiple().booleanValue()) {
                ArrayProperty arrayProperty = new ArrayProperty();
                Property innerType = PropertyBuilder.build(type, format, null);
                arrayProperty.setItems(innerType);
                p2 = arrayProperty;
            } else {
                p2 = this.propertyFromTypedObject(param);
                if (p2 == null) {
                    LOGGER.warn(String.format("WARNING! No property detected for parameter '%s' (%s)! Falling back to string!", new Object[]{param.getName(), param.getParamType()}));
                    p2 = new StringProperty();
                }
            }
            if (p2 instanceof ArrayProperty) {
                ArrayProperty ap = (ArrayProperty)p2;
                sp.setType("array");
                sp.setCollectionFormat("csv");
                sp.setItems(ap.getItems());
            } else {
                sp.setType(p2.getType());
                sp.setFormat(p2.getFormat());
            }
        }
        if (output instanceof PathParameter) {
            output.setRequired(true);
        }
        return output;
    }

    public io.swagger.models.Model modelFromExtendedTypedObject(ExtendedTypedObject obj) {
        String type = obj.getType() == null ? null : obj.getType().toString();
        String format = obj.getFormat() == null ? null : obj.getFormat().toString();
        io.swagger.models.Model output = null;
        if (obj.getRef() != null) {
            output = new RefModel().asDefault(obj.getRef());
        } else if ("array".equals(type)) {
            ArrayModel am = new ArrayModel();
            Items items = obj.getItems();
            type = items.getType() == null ? null : items.getType().toString();
            Property innerType = PropertyBuilder.build(type, format = items.getFormat() == null ? null : items.getFormat().toString(), null);
            if (innerType != null) {
                am.setItems(innerType);
            }
            if (items.getRef() != null) {
                am.setItems(new RefProperty(items.getRef()));
            } else {
                am.setItems(new RefProperty(type));
            }
            output = am;
        } else {
            Property input = PropertyBuilder.build(type, format, null);
            if (input != null) {
                output = PropertyBuilder.toModel(input);
            } else if (!"void".equals(type)) {
                output = new RefModel().asDefault(type);
            }
        }
        return output;
    }

    public Property propertyFromTypedObject(ExtendedTypedObject obj) {
        String type = obj.getType() == null ? null : obj.getType().toString();
        String format = obj.getFormat() == null ? null : obj.getFormat().toString();
        Property output = null;
        if ("array".equals(type)) {
            Property innerType;
            ArrayProperty am = new ArrayProperty();
            Items items = obj.getItems();
            if (items == null) {
                LOGGER.error("Error! Missing array type for property!  Assuming `object` -- please fix your spec");
                items = new Items();
                items.setType("object");
            }
            type = items.getType() == null ? null : items.getType().toString();
            format = items.getFormat() == null ? null : items.getFormat().toString();
            HashMap<PropertyBuilder.PropertyId, Object> args = new HashMap<PropertyBuilder.PropertyId, Object>();
            if (items.getExtraFields().get("enum") != null && items.getExtraFields().get("enum").isArray()) {
                ArrayNode an = (ArrayNode)items.getExtraFields().get("enum");
                ArrayList<String> enumValues = new ArrayList<String>();
                for (JsonNode jn : an) {
                    enumValues.add(jn.textValue());
                }
                args.put(PropertyBuilder.PropertyId.ENUM, enumValues);
            }
            if ((innerType = PropertyBuilder.build(type, format, args)) != null && !(innerType instanceof UntypedProperty)) {
                am.setItems(innerType);
            } else if (items.getRef() != null) {
                am.setItems(new RefProperty(items.getRef()));
            } else {
                am.setItems(new RefProperty(type));
            }
            output = am;
        } else {
            Property i;
            HashMap<PropertyBuilder.PropertyId, Object> args = new HashMap<PropertyBuilder.PropertyId, Object>();
            if (obj.getEnumValues() != null && obj.getEnumValues().size() > 0) {
                args.put(PropertyBuilder.PropertyId.ENUM, obj.getEnumValues());
            }
            if (obj.getMinimum() != null) {
                args.put(PropertyBuilder.PropertyId.MINIMUM, new BigDecimal(obj.getMinimum()));
            }
            if (obj.getMaximum() != null) {
                args.put(PropertyBuilder.PropertyId.MAXIMUM, new BigDecimal(obj.getMaximum()));
            }
            if ((i = PropertyBuilder.build(type, format, args)) != null && !(i instanceof UntypedProperty)) {
                output = i;
            } else if (obj.getRef() != null) {
                output = new RefProperty(obj.getRef());
            } else if (type != null && !type.equals("void")) {
                output = new RefProperty(type);
            }
        }
        return output;
    }

    public io.swagger.models.Operation convertOperation(String tag, Operation operation, ApiDeclaration apiDeclaration) {
        if (operation.getMethod() == null) {
            JsonNode node = operation.getExtraFields().get("httpMethod");
            Method method = Method.forValue(node.asText());
            operation.setMethod(method);
        }
        io.swagger.models.Operation output = new io.swagger.models.Operation().summary(operation.getSummary()).description(operation.getNotes()).operationId(operation.getNickname());
        if (tag != null) {
            output.tag(tag);
        }
        for (io.swagger.models.apideclaration.Parameter parameter : operation.getParameters()) {
            output.parameter(this.convertParameter(parameter));
        }
        if (operation.getConsumes() != null && !operation.getConsumes().isEmpty()) {
            for (String consumes : operation.getConsumes()) {
                output.consumes(consumes);
            }
        } else if (apiDeclaration.getConsumes() != null) {
            for (String consumes : apiDeclaration.getConsumes()) {
                output.consumes(consumes);
            }
        }
        if (operation.getProduces() != null && !operation.getProduces().isEmpty()) {
            for (String produces : operation.getProduces()) {
                output.produces(produces);
            }
        } else if (apiDeclaration.getProduces() != null) {
            for (String produces : apiDeclaration.getProduces()) {
                output.produces(produces);
            }
        }
        for (ResponseMessage message : operation.getResponseMessages()) {
            Response response = new Response().description(message.getMessage());
            Object responseModel = null;
            if (message.getResponseModel() != null) {
                response.schema(new RefProperty(message.getResponseModel()));
            }
            output.response(message.getCode(), response);
        }
        Property responseProperty = this.propertyFromTypedObject(operation);
        Response response = new Response().description("success").schema(responseProperty);
        if (output.getResponses() == null) {
            output.defaultResponse(response);
        } else if (responseProperty != null) {
            output.response(200, response);
        }
        Map<String, List<AuthorizationScope>> auths = operation.getAuthorizations();
        for (String securityName : auths.keySet()) {
            List<AuthorizationScope> scopes = auths.get(securityName);
            ArrayList<String> updatedScopes = new ArrayList<String>();
            for (AuthorizationScope s2 : scopes) {
                updatedScopes.add(s2.getScope());
            }
            output.addSecurity(securityName, updatedScopes);
        }
        return output;
    }

    public ApiDeclaration readDeclaration(String input, MessageBuilder messages, List<AuthorizationValue> auths) {
        ApiDeclaration output = null;
        try {
            JsonNode jsonNode = null;
            if (input.startsWith("http")) {
                String json = RemoteUrl.urlToString(input, auths);
                jsonNode = Json.mapper().readTree(json);
            } else {
                String fileScheme = "file:";
                java.nio.file.Path path = input.toLowerCase().startsWith("file:") ? Paths.get(URI.create(input)) : Paths.get(input, new String[0]);
                String json = Files.exists(path, new LinkOption[0]) ? FileUtils.readFileToString(path.toFile(), "UTF-8") : ClasspathHelper.loadFileFromClasspath(input);
                jsonNode = Json.mapper().readTree(json);
            }
            if (jsonNode.isObject()) {
                ((ObjectNode)jsonNode).remove("authorizations");
            }
            ApiDeclarationMigrator migrator = new ApiDeclarationMigrator();
            JsonNode transformed = migrator.migrate(messages, jsonNode);
            output = Json.mapper().convertValue((Object)transformed, ApiDeclaration.class);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (Exception e) {
            LOGGER.error("failed to read api declaration", e);
        }
        return output;
    }

    public Swagger convert(ResourceListing resourceListing, List<ApiDeclaration> apiDeclarations) {
        Info info = new Info();
        if (resourceListing.getInfo() != null) {
            ApiInfo apiInfo = resourceListing.getInfo();
            Contact contact = null;
            if (apiInfo.getContact() != null) {
                contact = new Contact().url(apiInfo.getContact());
            }
            License license = null;
            if (apiInfo.getLicense() != null) {
                license = new License().name(apiInfo.getLicense()).url(apiInfo.getLicenseUrl());
            }
            info = new Info().description(apiInfo.getDescription()).version(resourceListing.getApiVersion()).title(apiInfo.getTitle()).termsOfService(apiInfo.getTermsOfServiceUrl()).contact(contact).license(license);
        } else if (resourceListing.getApiVersion() != null) {
            info = new Info().version(resourceListing.getApiVersion());
        }
        HashMap<String, Path> paths = new HashMap<String, Path>();
        HashMap<String, io.swagger.models.Model> definitions = new HashMap<String, io.swagger.models.Model>();
        String basePath = null;
        for (ApiDeclaration apiDeclaration : apiDeclarations) {
            String tag;
            if (apiDeclaration.getApiListingRef() != null) {
                String refPath = apiDeclaration.getApiListingRef().getPath();
                tag = refPath.substring(refPath.lastIndexOf("/") + 1);
            } else {
                tag = apiDeclaration.getResourcePath();
            }
            if (tag != null) {
                tag = tag.replaceAll("/", "");
            }
            if (basePath != null) {
                if (!basePath.equals(apiDeclaration.getBasePath()) && apiDeclaration.getBasePath() != null) {
                    LOGGER.warn("warning!  multiple basePath values not supported!");
                }
            } else {
                basePath = apiDeclaration.getBasePath();
            }
            List<Api> apis = apiDeclaration.getApis();
            for (Api api : apis) {
                String apiPath = api.getPath();
                String description = api.getDescription();
                List<Operation> ops = api.getOperations();
                Path path = (Path)paths.get(apiPath);
                if (path == null) {
                    path = new Path();
                    paths.put(apiPath, path);
                }
                for (Operation op : ops) {
                    io.swagger.models.Operation operation = this.convertOperation(tag, op, apiDeclaration);
                    if (op.getMethod() != null) {
                        path.set(op.getMethod().toString().toLowerCase(), operation);
                        continue;
                    }
                    LOGGER.info("skipping operation with missing method:\n" + Json.pretty(op));
                }
            }
            Map<String, Model> apiModels = apiDeclaration.getModels();
            for (String key : apiModels.keySet()) {
                io.swagger.models.Model model = this.convertModel(apiModels.get(key));
                definitions.put(key, model);
            }
        }
        String host = null;
        String scheme = "http";
        if (basePath != null) {
            String[] parts = basePath.split("://");
            if (parts.length == 2) {
                scheme = parts[0];
                int pos = parts[1].indexOf("/");
                if (pos != -1) {
                    host = parts[1].substring(0, pos);
                    basePath = parts[1].substring(pos);
                } else {
                    host = parts[1];
                    basePath = "/";
                }
            }
            if (!basePath.startsWith("/")) {
                basePath = "/" + basePath;
            }
        }
        Swagger swagger = new Swagger().host(host).scheme(Scheme.forValue(scheme)).basePath(basePath).info(info).paths(paths).basePath(basePath);
        swagger.setDefinitions(definitions);
        Map<String, Authorization> authorizations = resourceListing.getAuthorizations();
        if (authorizations != null) {
            for (String string : authorizations.keySet()) {
                Authorization o2;
                Authorization auth = authorizations.get(string);
                if (auth instanceof OAuth2Authorization) {
                    OAuth2Definition oauth2;
                    o2 = (OAuth2Authorization)auth;
                    List<AuthorizationScope> scopes = ((OAuth2Authorization)o2).getScopes();
                    if (((OAuth2Authorization)o2).getGrantTypes().getImplicit() != null) {
                        ImplicitGrant ig = ((OAuth2Authorization)o2).getGrantTypes().getImplicit();
                        oauth2 = new OAuth2Definition().implicit(ig.getLoginEndpoint().getUrl());
                        if (swagger.getSecurityDefinitions() != null && swagger.getSecurityDefinitions().keySet().contains(string)) {
                            System.err.println("Warning!  Authorization nickname already in use!");
                        } else {
                            swagger.securityDefinition(string, oauth2);
                        }
                        for (AuthorizationScope scope : scopes) {
                            oauth2.scope(scope.getScope(), scope.getDescription());
                        }
                        continue;
                    }
                    if (((OAuth2Authorization)o2).getGrantTypes().getAuthorization_code() == null) continue;
                    AuthorizationCodeGrant ac = ((OAuth2Authorization)o2).getGrantTypes().getAuthorization_code();
                    oauth2 = new OAuth2Definition().accessCode(ac.getTokenRequestEndpoint().getUrl(), ac.getTokenEndpoint().getUrl());
                    if (swagger.getSecurityDefinitions() != null && swagger.getSecurityDefinitions().keySet().contains(string)) {
                        System.err.println("Warning!  Authorization nickname already in use!");
                    } else {
                        swagger.securityDefinition(string, oauth2);
                    }
                    for (AuthorizationScope scope : scopes) {
                        oauth2.scope(scope.getScope(), scope.getDescription());
                    }
                    continue;
                }
                if (auth instanceof ApiKeyAuthorization) {
                    o2 = (ApiKeyAuthorization)auth;
                    ApiKeyAuthDefinition def = new ApiKeyAuthDefinition();
                    PassAs passAs = ((ApiKeyAuthorization)o2).getPassAs();
                    if (PassAs.HEADER.equals((Object)passAs)) {
                        def.in(In.HEADER);
                    } else {
                        def.in(In.QUERY);
                    }
                    def.setName(((ApiKeyAuthorization)o2).getKeyname());
                    swagger.securityDefinition(string, def);
                    continue;
                }
                if (!(auth instanceof BasicAuthorization)) continue;
                BasicAuthDefinition def = new BasicAuthDefinition();
                swagger.securityDefinition(string, def);
            }
        }
        return swagger;
    }
}

