/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs.listing;

import io.swagger.config.FilterFactory;
import io.swagger.config.Scanner;
import io.swagger.config.SwaggerConfig;
import io.swagger.core.filter.SpecFilter;
import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.jaxrs.Reader;
import io.swagger.jaxrs.config.JaxrsScanner;
import io.swagger.jaxrs.config.ReaderConfigUtils;
import io.swagger.jaxrs.config.SwaggerContextService;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import io.swagger.models.Swagger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseApiListingResource {
    private static volatile boolean initialized = false;
    private static volatile ConcurrentMap<String, Boolean> initializedScanner = new ConcurrentHashMap<String, Boolean>();
    private static volatile ConcurrentMap<String, Boolean> initializedConfig = new ConcurrentHashMap<String, Boolean>();
    private static Logger LOGGER = LoggerFactory.getLogger(BaseApiListingResource.class);

    private static synchronized Swagger scan(Application app, ServletContext context, ServletConfig sc, UriInfo uriInfo) {
        Swagger swagger = null;
        SwaggerContextService ctxService = new SwaggerContextService().withServletConfig(sc).withBasePath(BaseApiListingResource.getBasePath(uriInfo));
        Scanner scanner = ctxService.getScanner();
        if (scanner != null) {
            Set<Class<?>> classes;
            SwaggerSerializers.setPrettyPrint(scanner.getPrettyPrint());
            swagger = new SwaggerContextService().withServletConfig(sc).withBasePath(BaseApiListingResource.getBasePath(uriInfo)).getSwagger();
            if (scanner instanceof JaxrsScanner) {
                JaxrsScanner jaxrsScanner = (JaxrsScanner)scanner;
                classes = jaxrsScanner.classesFromContext(app, sc);
            } else {
                classes = scanner.classes();
            }
            if (classes != null) {
                Reader reader = new Reader(swagger, ReaderConfigUtils.getReaderConfig(context));
                swagger = reader.read(classes);
                if (scanner instanceof SwaggerConfig) {
                    swagger = ((SwaggerConfig)((Object)scanner)).configure(swagger);
                } else {
                    SwaggerConfig swaggerConfig = ctxService.getConfig();
                    if (swaggerConfig != null) {
                        LOGGER.debug("configuring swagger with " + swaggerConfig);
                        swaggerConfig.configure(swagger);
                    } else {
                        LOGGER.debug("no configurator");
                    }
                }
                new SwaggerContextService().withServletConfig(sc).withBasePath(BaseApiListingResource.getBasePath(uriInfo)).updateSwagger(swagger);
            }
        }
        if (SwaggerContextService.isScannerIdInitParamDefined(sc)) {
            initializedScanner.put(sc.getServletName() + "_" + SwaggerContextService.getScannerIdFromInitParam(sc), true);
        } else if (SwaggerContextService.isConfigIdInitParamDefined(sc)) {
            initializedConfig.put(sc.getServletName() + "_" + SwaggerContextService.getConfigIdFromInitParam(sc), true);
        } else if (SwaggerContextService.isUsePathBasedConfigInitParamDefined(sc)) {
            initializedConfig.put(sc.getServletName() + "_" + ctxService.getBasePath(), true);
        } else {
            initialized = true;
        }
        return swagger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Swagger process(Application app, ServletContext servletContext, ServletConfig sc, HttpHeaders headers, UriInfo uriInfo) {
        SwaggerContextService ctxService = new SwaggerContextService().withServletConfig(sc).withBasePath(BaseApiListingResource.getBasePath(uriInfo));
        Swagger swagger = ctxService.getSwagger();
        Class<ApiListingResource> clazz = ApiListingResource.class;
        synchronized (ApiListingResource.class) {
            SwaggerSpecFilter filterImpl;
            if (SwaggerContextService.isScannerIdInitParamDefined(sc)) {
                if (!initializedScanner.containsKey(sc.getServletName() + "_" + SwaggerContextService.getScannerIdFromInitParam(sc))) {
                    swagger = BaseApiListingResource.scan(app, servletContext, sc, uriInfo);
                }
            } else if (SwaggerContextService.isConfigIdInitParamDefined(sc)) {
                if (!initializedConfig.containsKey(sc.getServletName() + "_" + SwaggerContextService.getConfigIdFromInitParam(sc))) {
                    swagger = BaseApiListingResource.scan(app, servletContext, sc, uriInfo);
                }
            } else if (SwaggerContextService.isUsePathBasedConfigInitParamDefined(sc)) {
                if (!initializedConfig.containsKey(sc.getServletName() + "_" + ctxService.getBasePath())) {
                    swagger = BaseApiListingResource.scan(app, servletContext, sc, uriInfo);
                }
            } else if (!initialized) {
                swagger = BaseApiListingResource.scan(app, servletContext, sc, uriInfo);
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            if (swagger != null && (filterImpl = FilterFactory.getFilter()) != null) {
                SpecFilter f = new SpecFilter();
                swagger = f.filter(swagger, filterImpl, BaseApiListingResource.getQueryParams(uriInfo.getQueryParameters()), BaseApiListingResource.getCookies(headers), BaseApiListingResource.getHeaders(headers));
            }
            return swagger;
        }
    }

    protected Response getListingYamlResponse(Application app, ServletContext servletContext, ServletConfig servletConfig, HttpHeaders headers, UriInfo uriInfo) {
        Swagger swagger = this.process(app, servletContext, servletConfig, headers, uriInfo);
        if (swagger != null) {
            return Response.ok().entity(swagger).type("application/yaml").build();
        }
        return Response.status(404).build();
    }

    protected Response getListingJsonResponse(Application app, ServletContext servletContext, ServletConfig servletConfig, HttpHeaders headers, UriInfo uriInfo) {
        Swagger swagger = this.process(app, servletContext, servletConfig, headers, uriInfo);
        if (swagger != null) {
            return Response.ok().entity(swagger).type("application/json").build();
        }
        return Response.status(404).build();
    }

    private static Map<String, List<String>> getQueryParams(MultivaluedMap<String, String> params) {
        HashMap<String, List<String>> output = new HashMap<String, List<String>>();
        if (params != null) {
            for (String key : params.keySet()) {
                List values = (List)params.get(key);
                output.put(key, values);
            }
        }
        return output;
    }

    private static Map<String, String> getCookies(HttpHeaders headers) {
        HashMap<String, String> output = new HashMap<String, String>();
        if (headers != null) {
            for (String key : headers.getCookies().keySet()) {
                Cookie cookie = headers.getCookies().get(key);
                output.put(key, cookie.getValue());
            }
        }
        return output;
    }

    private static Map<String, List<String>> getHeaders(HttpHeaders headers) {
        HashMap<String, List<String>> output = new HashMap<String, List<String>>();
        if (headers != null) {
            for (String key : headers.getRequestHeaders().keySet()) {
                List values = (List)headers.getRequestHeaders().get(key);
                output.put(key, values);
            }
        }
        return output;
    }

    private static String getBasePath(UriInfo uriInfo) {
        if (uriInfo != null) {
            return uriInfo.getBaseUri().getPath();
        }
        return "/";
    }
}

