/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.ext.AbstractSwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtensions;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import io.swagger.util.ParameterProcessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

public class DefaultParameterExtension
extends AbstractSwaggerExtension {
    private static Class<?> CLASS_BEAN_PARAM;
    final ObjectMapper mapper = Json.mapper();

    @Override
    public List<Parameter> extractParameters(List<Annotation> annotations, Type type, Set<Type> typesToSkip, Iterator<SwaggerExtension> chain) {
        if (this.shouldIgnoreType(type, typesToSkip)) {
            return new ArrayList<Parameter>();
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        AbstractSerializableParameter parameter = null;
        for (Annotation annotation : annotations) {
            Property schema;
            Annotation param;
            if (annotation instanceof QueryParam) {
                param = (QueryParam)annotation;
                QueryParameter qp = (QueryParameter)new QueryParameter().name(param.value());
                schema = this.createProperty(type);
                if (schema != null) {
                    qp.setProperty(schema);
                }
                parameter = qp;
                continue;
            }
            if (annotation instanceof PathParam) {
                param = (PathParam)annotation;
                PathParameter pp = (PathParameter)new PathParameter().name(param.value());
                schema = this.createProperty(type);
                if (schema != null) {
                    pp.setProperty(schema);
                }
                parameter = pp;
                continue;
            }
            if (annotation instanceof HeaderParam) {
                param = (HeaderParam)annotation;
                HeaderParameter hp = (HeaderParameter)new HeaderParameter().name(param.value());
                schema = this.createProperty(type);
                if (schema != null) {
                    hp.setProperty(schema);
                }
                parameter = hp;
                continue;
            }
            if (annotation instanceof CookieParam) {
                param = (CookieParam)annotation;
                CookieParameter cp = (CookieParameter)new CookieParameter().name(param.value());
                schema = this.createProperty(type);
                if (schema != null) {
                    cp.setProperty(schema);
                }
                parameter = cp;
                continue;
            }
            if (annotation instanceof FormParam) {
                param = (FormParam)annotation;
                FormParameter fp = (FormParameter)new FormParameter().name(param.value());
                schema = this.createProperty(type);
                if (schema != null) {
                    fp.setProperty(schema);
                }
                parameter = fp;
                continue;
            }
            this.handleAdditionalAnnotation(parameters, annotation, type, typesToSkip);
        }
        if (parameter != null) {
            parameters.add(parameter);
        }
        return parameters;
    }

    private void handleAdditionalAnnotation(List<Parameter> parameters, Annotation annotation, Type type, Set<Type> typesToSkip) {
        if (this.isBeanParametersAggregatorAnnotation(annotation)) {
            BeanDescription beanDesc = this.mapper.getSerializationConfig().introspect(this.constructType(type));
            List<BeanPropertyDefinition> properties = beanDesc.findProperties();
            for (BeanPropertyDefinition propDef : properties) {
                AnnotatedField field = propDef.getField();
                AnnotatedMethod setter = propDef.getSetter();
                AnnotatedMethod getter = propDef.getGetter();
                ArrayList<Annotation> paramAnnotations = new ArrayList<Annotation>();
                Iterator<SwaggerExtension> extensions = SwaggerExtensions.chain();
                JavaType paramType = null;
                if (field != null) {
                    paramType = field.getType();
                    for (Annotation fieldAnnotation : field.annotations()) {
                        if (paramAnnotations.contains(fieldAnnotation)) continue;
                        paramAnnotations.add(fieldAnnotation);
                    }
                }
                if (setter != null) {
                    if (paramType == null) {
                        paramType = setter.getParameterType(0);
                    }
                    for (Annotation fieldAnnotation : setter.annotations()) {
                        if (paramAnnotations.contains(fieldAnnotation)) continue;
                        paramAnnotations.add(fieldAnnotation);
                    }
                }
                if (getter != null) {
                    if (paramType == null) {
                        paramType = getter.getType();
                    }
                    for (Annotation fieldAnnotation : getter.annotations()) {
                        if (paramAnnotations.contains(fieldAnnotation)) continue;
                        paramAnnotations.add(fieldAnnotation);
                    }
                }
                if (paramType == null) continue;
                List<Parameter> extracted = extensions.next().extractParameters(paramAnnotations, paramType, typesToSkip, extensions);
                for (Parameter param : extracted) {
                    if (ParameterProcessor.applyAnnotations(null, param, paramType, paramAnnotations) == null) continue;
                    parameters.add(param);
                }
            }
        }
    }

    protected boolean isBeanParametersAggregatorAnnotation(Annotation annotation) {
        return CLASS_BEAN_PARAM != null && CLASS_BEAN_PARAM.isAssignableFrom(annotation.getClass());
    }

    @Override
    protected boolean shouldIgnoreClass(Class<?> cls) {
        return cls.getName().startsWith("javax.ws.rs.");
    }

    private Property createProperty(Type type) {
        return this.enforcePrimitive(ModelConverters.getInstance().readAsProperty(type), 0);
    }

    private Property enforcePrimitive(Property in, int level) {
        if (in instanceof RefProperty) {
            return new StringProperty();
        }
        if (in instanceof ArrayProperty) {
            if (level == 0) {
                ArrayProperty array = (ArrayProperty)in;
                array.setItems(this.enforcePrimitive(array.getItems(), level + 1));
            } else {
                return new StringProperty();
            }
        }
        return in;
    }

    static {
        try {
            CLASS_BEAN_PARAM = Class.forName("javax.ws.rs.BeanParam", true, DefaultParameterExtension.class.getClassLoader());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

