/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.tests.demo.workflow;

import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowSettings;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordGeneratorWorkflow
extends WorkflowDefinition<State> {
    private static final Logger logger = LoggerFactory.getLogger(WordGeneratorWorkflow.class);

    protected WordGeneratorWorkflow(String flowName, WorkflowSettings settings) {
        super(flowName, State.start, State.error, settings);
        this.setDescription("Generate random words");
        for (State originState : State.values()) {
            for (State targetState : State.values()) {
                if (originState == State.end || originState == State.error || targetState == State.error) continue;
                this.permit(originState, targetState);
            }
        }
    }

    public WordGeneratorWorkflow() {
        this("wordGenerator", new WorkflowSettings.Builder().build());
    }

    protected static State randState() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        double sum = 0.0;
        for (State v : State.values()) {
            sum += v.fraction;
        }
        double rand = ((Random)random).nextDouble();
        double threshold = 0.0;
        for (State v : State.values()) {
            if (!((threshold += v.fraction / sum) > rand)) continue;
            return v;
        }
        return State.values()[State.values().length - 1];
    }

    public NextAction start(StateExecution execution) {
        State newState = WordGeneratorWorkflow.randState();
        return NextAction.moveToState(newState, "Go to state " + newState);
    }

    public void error(StateExecution execution) {
        logger.error("Finished with error");
    }

    public NextAction end(StateExecution execution) {
        logger.info("Finished word: {}", (Object)execution.getVariable("word", "").toUpperCase(Locale.GERMAN));
        return NextAction.stopInState(State.end, "Finished in end state");
    }

    protected NextAction update(StateExecution execution, String state) {
        State newState = WordGeneratorWorkflow.randState();
        logger.info("{}->{}", (Object)state, (Object)newState.name());
        String word = execution.getVariable("word", "");
        execution.setVariable("word", word + state);
        return NextAction.moveToState(newState, "Go to state " + newState);
    }

    public NextAction a(StateExecution execution) {
        return this.update(execution, "a");
    }

    public NextAction b(StateExecution execution) {
        return this.update(execution, "b");
    }

    public NextAction c(StateExecution execution) {
        return this.update(execution, "c");
    }

    public NextAction d(StateExecution execution) {
        return this.update(execution, "d");
    }

    public NextAction e(StateExecution execution) {
        return this.update(execution, "e");
    }

    public NextAction f(StateExecution execution) {
        return this.update(execution, "f");
    }

    public NextAction g(StateExecution execution) {
        return this.update(execution, "g");
    }

    public NextAction h(StateExecution execution) {
        return this.update(execution, "h");
    }

    public NextAction i(StateExecution execution) {
        return this.update(execution, "i");
    }

    public NextAction j(StateExecution execution) {
        return this.update(execution, "j");
    }

    public NextAction k(StateExecution execution) {
        return this.update(execution, "k");
    }

    public NextAction l(StateExecution execution) {
        return this.update(execution, "l");
    }

    public NextAction m(StateExecution execution) {
        return this.update(execution, "m");
    }

    public NextAction n(StateExecution execution) {
        return this.update(execution, "n");
    }

    public NextAction o(StateExecution execution) {
        return this.update(execution, "o");
    }

    public NextAction p(StateExecution execution) {
        return this.update(execution, "p");
    }

    public NextAction q(StateExecution execution) {
        return this.update(execution, "q");
    }

    public NextAction r(StateExecution execution) {
        return this.update(execution, "r");
    }

    public NextAction s(StateExecution execution) {
        return this.update(execution, "s");
    }

    public NextAction t(StateExecution execution) {
        return this.update(execution, "t");
    }

    public NextAction u(StateExecution execution) {
        return this.update(execution, "u");
    }

    public NextAction v(StateExecution execution) {
        return this.update(execution, "v");
    }

    public NextAction w(StateExecution execution) {
        return this.update(execution, "w");
    }

    public NextAction x(StateExecution execution) {
        return this.update(execution, "x");
    }

    public NextAction y(StateExecution execution) {
        return this.update(execution, "y");
    }

    public NextAction z(StateExecution execution) {
        return this.update(execution, "z");
    }

    public static enum State implements WorkflowState
    {
        start(WorkflowStateType.start),
        a(0.08167),
        b(0.01492),
        c(0.02782),
        d(0.04253),
        e(0.12702),
        f(0.02228),
        g(0.02015),
        h(0.06094),
        i(0.0666),
        j(0.00153),
        k(0.00772),
        l(0.04025),
        m(0.02406),
        n(0.06749),
        o(0.07507),
        p(0.01929),
        q(9.5E-4),
        r(0.05987),
        s(0.06327),
        t(0.09056),
        u(0.02758),
        v(0.00978),
        w(0.0236),
        x(0.0015),
        y(0.01974),
        z(7.4E-4),
        end(0.13012),
        error(WorkflowStateType.end);

        final double fraction;
        private final WorkflowStateType type;

        private State(WorkflowStateType type) {
            this(0.0, type);
        }

        private State(double fraction) {
            this(fraction, WorkflowStateType.normal);
        }

        private State(double fraction, WorkflowStateType type) {
            this.fraction = fraction;
            this.type = type;
        }

        @Override
        public WorkflowStateType getType() {
            return this.type;
        }
    }
}

