/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.tests.demo.workflow;

import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.WorkflowSettings;
import io.nflow.tests.demo.workflow.WordGeneratorWorkflow;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordGeneratorErrorsWorkflow
extends WordGeneratorWorkflow {
    private static final Logger logger = LoggerFactory.getLogger(WordGeneratorErrorsWorkflow.class);
    private static final double ERROR_FRACTION = 0.5;
    private static final WorkflowSettings wordGeneratorErrorsWorkSettings = new WorkflowSettings.Builder().setMinErrorTransitionDelay(300).setMaxErrorTransitionDelay(1000).setShortTransitionDelay(200).setImmediateTransitionDelay(100).setMaxRetries(10).setHistoryDeletableAfter(Period.days(2)).build();

    public WordGeneratorErrorsWorkflow() {
        super("wordGeneratorErrors", wordGeneratorErrorsWorkSettings);
        this.setDescription("Workflow for testing randomly failing states");
    }

    @Override
    protected NextAction update(StateExecution execution, String state) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (((Random)random).nextDouble() < 0.25) {
            logger.info("Generating error at state {} before new state is set", (Object)state);
            throw new RuntimeException("error at state " + state + " before new state is set");
        }
        NextAction nextAction = super.update(execution, state);
        if (((Random)random).nextDouble() < 0.25) {
            logger.info("Generating error at state {} after new state is set", (Object)state);
            throw new RuntimeException("error at state " + state + " after new state is set");
        }
        return nextAction;
    }
}

