/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.tests.demo.workflow;

import io.nflow.engine.workflow.definition.Mutable;
import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.StateVar;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;
import io.nflow.tests.demo.domain.CreateLoanResponse;
import io.nflow.tests.demo.domain.QueryCreditApplicationResponse;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class WithdrawLoanWorkflow
extends WorkflowDefinition<State> {
    private static final String CREDIT_APPLICATION_KEY = "credit_application_key";
    private static final String LOAN_KEY = "loan_key";
    private static final String COMPLETED_KEY = "completed_key";

    @Inject
    public WithdrawLoanWorkflow() {
        super("withdrawLoan", State.createLoan, State.manualProcessing);
        this.setName("Withdraw loan");
        this.setDescription("Creates loan, deposits the money and updates credit application");
        this.permit(State.createLoan, State.transferMoney);
        this.permit(State.transferMoney, State.updateCreditApplication, State.transferMoneyFailed);
        this.permit(State.transferMoneyFailed, State.manualProcessing);
        this.permit(State.updateCreditApplication, State.done);
    }

    public NextAction createLoan(StateExecution execution, @StateVar(value="loan_key") Mutable<CreateLoanResponse> loan, @StateVar(value="credit_application_key") Mutable<QueryCreditApplicationResponse> application) {
        application.setVal(new QueryCreditApplicationResponse());
        loan.setVal(new CreateLoanResponse());
        return NextAction.moveToState(State.transferMoney, "Loan created");
    }

    public NextAction transferMoney(StateExecution execution) {
        this.setApplicationCompleted(execution, true);
        return NextAction.moveToState(State.updateCreditApplication, "Money transferred");
    }

    public NextAction updateCreditApplication(StateExecution execution) {
        return NextAction.moveToState(State.done, "Credit application updated");
    }

    public NextAction transferMoneyFailed(StateExecution execution) {
        return NextAction.moveToState(State.manualProcessing, "Loan cancelled");
    }

    private void setApplicationCompleted(StateExecution execution, boolean success) {
        execution.setVariable(COMPLETED_KEY, Boolean.toString(success));
    }

    public static enum State implements WorkflowState
    {
        createLoan(WorkflowStateType.start, "Start process by creating the loan"),
        transferMoney(WorkflowStateType.normal, "Transfer money to deposit account"),
        transferMoneyFailed(WorkflowStateType.normal, "Transfering money failed, reverse creating loan"),
        updateCreditApplication(WorkflowStateType.normal, "Update the credit application state"),
        manualProcessing(WorkflowStateType.manual, "Process must be handled manually because of an unexpected situation"),
        done(WorkflowStateType.end, "Credit application has been completed.");

        private WorkflowStateType type;
        private String description;

        private State(WorkflowStateType type, String description) {
            this.type = type;
            this.description = description;
        }

        @Override
        public WorkflowStateType getType() {
            return this.type;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

