/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.tests.demo.workflow;

import io.nflow.engine.workflow.curated.CronWorkflow;
import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.WorkflowSettings;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.springframework.stereotype.Component;

@Component
public class TestCronWorkflow
extends CronWorkflow {
    public static final String TYPE = "testCron";

    protected TestCronWorkflow() {
        super(TYPE, new WorkflowSettings.Builder().setHistoryDeletableAfter(Period.hours(1)).setDeleteHistoryCondition(() -> true).build());
    }

    public NextAction doWork(StateExecution execution) {
        WorkflowInstance childWorkflow = new WorkflowInstance.Builder().setType("demo").build();
        execution.addChildWorkflows(childWorkflow);
        return NextAction.moveToStateAfter(CronWorkflow.State.waitForWorkToFinish, DateTime.now().plusMinutes(1), "Work delegated to child workflow");
    }

    @Override
    protected DateTime getNextActivationTime(StateExecution execution, String cron) {
        return super.getNextActivationTime(execution, cron);
    }

    @Override
    protected boolean handleFailureImpl(StateExecution execution) {
        return super.handleFailureImpl(execution);
    }

    @Override
    protected DateTime waitForWorkToFinishImpl(StateExecution execution) {
        return super.waitForWorkToFinishImpl(execution);
    }
}

