/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.tests.demo.workflow;

import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.StateVar;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowSettings;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.stereotype.Component;

@Component
public class StateWorkflow
extends WorkflowDefinition<State> {
    public static final String STATE_WORKFLOW_TYPE = "stateWorkflow";
    public static final String STATEVAR_QUERYTEST = "queryTest";

    public StateWorkflow() {
        super(STATE_WORKFLOW_TYPE, State.state1, State.error, new WorkflowSettings.Builder().setMinErrorTransitionDelay(0).setMaxErrorTransitionDelay(0).setShortTransitionDelay(0).setMaxRetries(3).build());
        this.setDescription("Workflow for testing state variables");
        this.permit(State.state1, State.state2);
        this.permit(State.state2, State.state3);
        this.permit(State.state3, State.state4);
        this.permit(State.state4, State.state5);
        this.permit(State.state5, State.done);
    }

    public NextAction state1(StateExecution execution, @StateVar(value="variable1", instantiateIfNotExists=true) Variable variable1) {
        variable1.value = "foo1";
        execution.setVariable(STATEVAR_QUERYTEST, "oldValue");
        return NextAction.moveToState(State.state2, "variable1 is set to " + variable1.value);
    }

    public NextAction state2(StateExecution execution, @StateVar(value="variable2", instantiateIfNotExists=true) Variable variable2) {
        variable2.value = "bar1";
        execution.setVariable(STATEVAR_QUERYTEST, "anotherOldValue");
        return NextAction.moveToState(State.state3, "variable1 is set to " + variable2.value);
    }

    public NextAction state3(StateExecution execution, @StateVar(value="variable2") Variable variable2) {
        variable2.value = "bar2";
        execution.setVariable(STATEVAR_QUERYTEST, "newValue");
        return NextAction.moveToState(State.state4, "variable2 is set to " + variable2.value);
    }

    public NextAction state4(StateExecution execution, @StateVar(value="variable1") Variable variable1, @StateVar(value="variable2") Variable variable2) {
        return NextAction.moveToState(State.state5, String.format("variable1=%s variable2=%s", variable1, variable2));
    }

    public NextAction state5(StateExecution execution, @StateVar(value="variable2") Variable variable2) {
        variable2.value = "bar3";
        return NextAction.moveToState(State.done, "variable2 is set to " + variable2.value);
    }

    public void done(StateExecution execution) {
        System.out.println("StateWorkflow done.");
    }

    public static class Variable {
        public String value;

        public String toString() {
            return ToStringBuilder.reflectionToString(this);
        }
    }

    public static enum State implements WorkflowState
    {
        state1(WorkflowStateType.start, "Set variable 1"),
        state2(WorkflowStateType.normal, "Set variable 2"),
        state3(WorkflowStateType.normal, "Update variable 2"),
        state4(WorkflowStateType.normal, "Do nothing"),
        state5(WorkflowStateType.normal, "Update variable 2"),
        done(WorkflowStateType.end, "Finished"),
        error(WorkflowStateType.manual, "Error state");

        private final WorkflowStateType type;
        private final String description;

        private State(WorkflowStateType type, String description) {
            this.type = type;
            this.description = description;
        }

        @Override
        public WorkflowStateType getType() {
            return this.type;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

