/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.tests.demo.workflow;

import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class SlowWorkflow
extends WorkflowDefinition<State> {
    public static final String SLOW_WORKFLOW_TYPE = "slowWorkflow";
    public static final int SIGNAL_INTERRUPT = 1;

    public SlowWorkflow() {
        super(SLOW_WORKFLOW_TYPE, State.begin, State.error);
        this.setDescription("Workflow for testing a state that has a long execution time");
        this.permit(State.begin, State.process);
        this.permit(State.process, State.done);
    }

    public NextAction begin(StateExecution execution) {
        return NextAction.moveToState(State.process, "Go to process state");
    }

    public NextAction process(StateExecution execution) throws InterruptedException {
        for (int i = 0; i < 50; ++i) {
            TimeUnit.MILLISECONDS.sleep(200L);
            if (!execution.getSignal().isPresent()) continue;
            Integer signal = execution.getSignal().get();
            execution.setSignal(Optional.empty(), "Clearing signal from process state");
            return NextAction.moveToState(State.interrupted, "Interrupted with signal " + signal + ", moving to interrupted state");
        }
        return NextAction.moveToState(State.done, "Go to done state");
    }

    @Override
    public Map<Integer, String> getSupportedSignals() {
        return Collections.singletonMap(1, "Interrupted");
    }

    public static enum State implements WorkflowState
    {
        begin(WorkflowStateType.start),
        process(WorkflowStateType.normal),
        interrupted(WorkflowStateType.end),
        done(WorkflowStateType.end),
        error(WorkflowStateType.manual);

        private WorkflowStateType type;

        private State(WorkflowStateType type) {
            this.type = type;
        }

        @Override
        public WorkflowStateType getType() {
            return this.type;
        }
    }
}

