/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.tests.demo.workflow;

import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;

public class SimpleWorkflow
extends WorkflowDefinition<State> {
    public static final String SIMPLE_WORKFLOW_TYPE = "simple";

    public SimpleWorkflow() {
        super(SIMPLE_WORKFLOW_TYPE, State.begin, State.error);
        this.setDescription("Simple demo workflow: start -> done");
        this.permit(State.begin, State.done);
    }

    public NextAction begin(StateExecution execution) {
        return NextAction.stopInState(State.done, "Finished");
    }

    public static enum State implements WorkflowState
    {
        begin(WorkflowStateType.start),
        done(WorkflowStateType.end),
        error(WorkflowStateType.manual);

        private WorkflowStateType type;

        private State(WorkflowStateType type) {
            this.type = type;
        }

        @Override
        public WorkflowStateType getType() {
            return this.type;
        }
    }
}

