/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.tests.demo.workflow;

import io.nflow.engine.workflow.definition.Mutable;
import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.StateVar;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import io.nflow.tests.demo.domain.CreateCreditApplicationRequest;
import io.nflow.tests.demo.domain.CreateLoanResponse;
import io.nflow.tests.demo.domain.CreditDecisionData;
import io.nflow.tests.demo.domain.QueryCreditApplicationResponse;
import io.nflow.tests.demo.workflow.CreditDecisionWorkflow;
import org.joda.time.DateTime;
import org.springframework.stereotype.Component;

@Component
public class ProcessCreditApplicationWorkflow
extends WorkflowDefinition<State> {
    private static final String CREDIT_APPLICATION_KEY = "credit_application_key";
    private static final String LOAN_KEY = "loan_key";
    private static final String CREDIT_DECISION_RESULT = "credit_decision_result";

    public ProcessCreditApplicationWorkflow() {
        super("processCreditApplication", State.createCreditApplication, State.manualProcessing);
        this.setName("Process credit application");
        this.setDescription("Makes credit decision, creates loan, deposits the money and updates credit application");
        this.permit(State.createCreditApplication, State.startCreditDecisionWorkflow);
        this.permit(State.startCreditDecisionWorkflow, State.waitCreditDecisionWorkflow);
        this.permit(State.waitCreditDecisionWorkflow, State.createLoan);
        this.permit(State.waitCreditDecisionWorkflow, State.updateCreditApplication);
        this.permit(State.createLoan, State.transferMoney);
        this.permit(State.transferMoney, State.updateCreditApplication, State.transferMoneyFailed);
        this.permit(State.transferMoneyFailed, State.manualProcessing);
        this.permit(State.updateCreditApplication, State.done);
    }

    public NextAction createCreditApplication(StateExecution execution, @StateVar(readOnly=true, value="requestData") CreateCreditApplicationRequest request, @StateVar(value="credit_application_key") Mutable<QueryCreditApplicationResponse> application) {
        request.processWorkflowId = execution.getWorkflowInstanceId();
        application.setVal(new QueryCreditApplicationResponse());
        return NextAction.moveToState(State.startCreditDecisionWorkflow, "Credit application created");
    }

    public NextAction startCreditDecisionWorkflow(StateExecution execution, @StateVar(value="credit_application_key") QueryCreditApplicationResponse application) {
        CreditDecisionData creditDecisionData = new CreditDecisionData();
        creditDecisionData.clientId = application.clientId;
        creditDecisionData.amount = application.amount;
        execution.addChildWorkflows(execution.workflowInstanceBuilder().setType("creditDecision").setBusinessKey(application.applicationId).putStateVariable("requestData", creditDecisionData).build());
        return NextAction.moveToStateAfter(State.waitCreditDecisionWorkflow, DateTime.now().plusMonths(1), "Credit decision request submitted");
    }

    public NextAction waitCreditDecisionWorkflow(StateExecution execution, @StateVar(value="credit_decision_result") Mutable<String> creditDecisionResult) {
        WorkflowInstance decisionWorkflow = execution.getAllChildWorkflows().get(0);
        creditDecisionResult.setVal(decisionWorkflow.state);
        if (CreditDecisionWorkflow.State.approved.name().equals(decisionWorkflow.state)) {
            return NextAction.moveToState(State.createLoan, "Credit decision approved");
        }
        if (CreditDecisionWorkflow.State.rejected.name().equals(decisionWorkflow.state)) {
            return NextAction.moveToState(State.updateCreditApplication, "Credit decision rejected");
        }
        return NextAction.retryAfter(DateTime.now().plusSeconds(20), "Credit decision workflow in state " + decisionWorkflow.state);
    }

    public NextAction createLoan(StateExecution execution, @StateVar(value="loan_key") Mutable<CreateLoanResponse> loan) {
        CreateLoanResponse response = new CreateLoanResponse();
        response.success = true;
        loan.setVal(response);
        return NextAction.moveToState(State.transferMoney, "Loan created");
    }

    public NextAction transferMoney(StateExecution execution) {
        return NextAction.moveToState(State.updateCreditApplication, "Money transferred");
    }

    public NextAction updateCreditApplication(StateExecution execution) {
        return NextAction.moveToState(State.done, "Credit application updated");
    }

    public NextAction transferMoneyFailed(StateExecution execution) {
        return NextAction.moveToState(State.manualProcessing, "Loan cancelled");
    }

    public static enum State implements WorkflowState
    {
        createCreditApplication(WorkflowStateType.start, "Create new credit application"),
        startCreditDecisionWorkflow(WorkflowStateType.normal, "Start credit decision workflow"),
        waitCreditDecisionWorkflow(WorkflowStateType.normal, "Poll for result of credit decision process"),
        createLoan(WorkflowStateType.normal, "Create the loan based on application"),
        transferMoney(WorkflowStateType.normal, "Transfer money to deposit account"),
        transferMoneyFailed(WorkflowStateType.normal, "Transfering money failed, reverse creating loan"),
        updateCreditApplication(WorkflowStateType.normal, "Update the credit application state"),
        manualProcessing(WorkflowStateType.manual, "Process must be handled manually because of an unexpected situation"),
        done(WorkflowStateType.end, "Credit application has been completed.");

        private WorkflowStateType type;
        private String description;

        private State(WorkflowStateType type, String description) {
            this.type = type;
            this.description = description;
        }

        @Override
        public WorkflowStateType getType() {
            return this.type;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

