/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.tests.demo.workflow;

import io.nflow.engine.exception.StateProcessExceptionHandling;
import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.NonRetryable;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowSettings;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;
import java.util.function.BiFunction;
import org.springframework.stereotype.Component;

@Component
public class NoRetryWorkflow
extends WorkflowDefinition<State> {
    public static final String TYPE = "noRetry";

    public NoRetryWorkflow() {
        super(TYPE, State.begin, State.error, new WorkflowSettings.Builder().setExceptionAnalyzer(NoRetryWorkflow.exceptionAnalyzer()).build());
        this.setDescription("Workflow demonstrating how to avoid automatic retry");
        this.permit(State.begin, State.process);
        this.permit(State.process, State.done);
    }

    private static BiFunction<WorkflowState, Throwable, StateProcessExceptionHandling> exceptionAnalyzer() {
        return (s2, t) -> new StateProcessExceptionHandling.Builder().setRetryable(s2 != State.begin && !t.getClass().isAnnotationPresent(NonRetryable.class)).build();
    }

    public NextAction begin(StateExecution execution) {
        throw new RuntimeException();
    }

    public NextAction process(StateExecution execution) {
        throw new NonRetryableException();
    }

    @NonRetryable
    static class NonRetryableException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        NonRetryableException() {
        }
    }

    public static enum State implements WorkflowState
    {
        begin(WorkflowStateType.start, "Retry always disabled for this state"),
        process(WorkflowStateType.normal, "Retry disabled for exceptions annotated with @NonRetryable"),
        done(WorkflowStateType.end, "End state"),
        error(WorkflowStateType.manual, "Error state");

        private WorkflowStateType type;
        private String description;

        private State(WorkflowStateType type, String description) {
            this.type = type;
            this.description = description;
        }

        @Override
        public WorkflowStateType getType() {
            return this.type;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

