/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.tests.demo.workflow;

import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ForeverWaitingWorkflow
extends WorkflowDefinition<State> {
    private static final Logger logger = LoggerFactory.getLogger(ForeverWaitingWorkflow.class);
    public static final String FOREVER_WAITING_WORKFLOW_TYPE = "foreverWaiting";

    public ForeverWaitingWorkflow() {
        super(FOREVER_WAITING_WORKFLOW_TYPE, State.begin, State.error);
        this.setDescription("Workflow that waits for a year in 'waiting' state");
        this.permit(State.begin, State.waiting);
        this.permit(State.waiting, State.waiting);
    }

    public NextAction begin(StateExecution execution) {
        logger.info("in begin state");
        return NextAction.moveToStateAfter(State.waiting, DateTime.now().plusYears(1), "Move to waiting after an year");
    }

    public NextAction waiting(StateExecution execution) {
        logger.info("in waiting state");
        return NextAction.moveToStateAfter(State.waiting, DateTime.now().plusYears(1), "Move to waiting again after an year");
    }

    public static enum State implements WorkflowState
    {
        begin(WorkflowStateType.start),
        waiting(WorkflowStateType.normal),
        done(WorkflowStateType.end),
        error(WorkflowStateType.manual);

        private WorkflowStateType type;

        private State(WorkflowStateType type) {
            this.type = type;
        }

        @Override
        public WorkflowStateType getType() {
            return this.type;
        }
    }
}

