/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.tests.demo.workflow;

import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.StateVar;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;
import io.nflow.engine.workflow.instance.QueryWorkflowInstances;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FibonacciWorkflow
extends WorkflowDefinition<State> {
    public static final String WORKFLOW_TYPE = "fibonacci";
    private static final Logger logger = LoggerFactory.getLogger(FibonacciWorkflow.class);

    public FibonacciWorkflow() {
        super(WORKFLOW_TYPE, State.begin, State.error);
        this.setDescription("Fibonacci series generator using recursive process. Each step is handled by a new child workflow.");
        this.permit(State.begin, State.nMinus2);
        this.permit(State.nMinus2, State.nMinus1);
        this.permit(State.nMinus2, State.poll);
        this.permit(State.nMinus1, State.poll);
        this.permit(State.nMinus1, State.done);
        this.permit(State.nMinus2, State.done);
        this.permit(State.poll, State.done);
    }

    public NextAction begin(StateExecution execution, @StateVar(value="requestData", readOnly=true) FiboData fiboData) {
        int n = fiboData.n;
        logger.info("Fibonacci step N = {}", (Object)n);
        execution.setVariable("result", 0);
        return NextAction.moveToState(State.nMinus2, "Starting N = " + n);
    }

    public NextAction nMinus2(StateExecution execution, @StateVar(value="requestData", readOnly=true) FiboData fiboData) {
        int n = fiboData.n;
        return this.nextStep(execution, n - 2, 2, State.nMinus1);
    }

    public NextAction nMinus1(StateExecution execution, @StateVar(value="requestData", readOnly=true) FiboData fiboData) {
        int n = fiboData.n;
        return this.nextStep(execution, n - 1, 1, State.poll);
    }

    private NextAction nextStep(StateExecution execution, int nextN, int offset, State nextState) {
        if (nextN < 2) {
            logger.info("nextN = {}. skipping to done", (Object)nextN);
            execution.setVariable("result", execution.getVariable("result", Integer.class) + 1);
            return NextAction.moveToState(nextState, "N - " + offset + " = " + nextN + ". Going to end.");
        }
        logger.info("Create child workflow N={}", (Object)nextN);
        execution.addChildWorkflows(this.createWorkflow(execution, nextN));
        return NextAction.moveToState(nextState, "Creating childWorkflow to process f(" + nextN + ")");
    }

    public NextAction poll(StateExecution execution) {
        QueryWorkflowInstances query2 = new QueryWorkflowInstances.Builder().addStatuses(WorkflowInstance.WorkflowInstanceStatus.manual, WorkflowInstance.WorkflowInstanceStatus.finished).setIncludeCurrentStateVariables(true).build();
        List<WorkflowInstance> finishedChildren = execution.queryChildWorkflows(query2);
        if (finishedChildren.size() < execution.getAllChildWorkflows().size()) {
            return NextAction.retryAfter(DateTime.now().plusSeconds(10), "Child workflows are not ready yet.");
        }
        int sum = 0;
        for (WorkflowInstance child : finishedChildren) {
            if (child.status != WorkflowInstance.WorkflowInstanceStatus.finished) {
                return NextAction.stopInState(State.error, "Some of the children failed");
            }
            String childResult = child.stateVariables.get("result");
            sum += Integer.parseInt(childResult != null ? childResult : "0");
        }
        execution.setVariable("result", execution.getVariable("result", Integer.class) + sum);
        return NextAction.moveToState(State.done, "All is good");
    }

    public void done(StateExecution execution, @StateVar(value="requestData") FiboData fiboData, @StateVar(value="result") int result) {
        logger.info("We are done: fibonacci({}) == {}", (Object)fiboData.n, (Object)result);
    }

    public void error(StateExecution execution, @StateVar(value="requestData") FiboData fiboData, @StateVar(value="result") int result) {
        logger.error("Failed to compute F({})", (Object)fiboData.n);
    }

    private WorkflowInstance createWorkflow(StateExecution execution, int n) {
        return execution.workflowInstanceBuilder().setType(WORKFLOW_TYPE).putStateVariable("requestData", new FiboData(n)).build();
    }

    public static class FiboData {
        public int n;

        public FiboData() {
        }

        public FiboData(int n) {
            this();
            this.n = n;
        }
    }

    public static enum State implements WorkflowState
    {
        begin(WorkflowStateType.start),
        nMinus1(WorkflowStateType.normal),
        nMinus2(WorkflowStateType.normal),
        poll(WorkflowStateType.wait),
        done(WorkflowStateType.end),
        error(WorkflowStateType.manual);

        private WorkflowStateType type;

        private State(WorkflowStateType type) {
            this.type = type;
        }

        @Override
        public WorkflowStateType getType() {
            return this.type;
        }
    }
}

