/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.tests.demo.workflow;

import com.fasterxml.jackson.databind.JsonNode;
import io.nflow.engine.workflow.curated.BulkWorkflow;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import java.util.stream.StreamSupport;
import org.joda.time.DateTime;
import org.springframework.stereotype.Component;

@Component
public class DemoBulkWorkflow
extends BulkWorkflow {
    public static final String DEMO_BULK_WORKFLOW_TYPE = "demoBulk";

    public DemoBulkWorkflow() {
        super(DEMO_BULK_WORKFLOW_TYPE);
    }

    @Override
    protected boolean splitWorkImpl(StateExecution execution, JsonNode data) {
        if (data.size() == 0) {
            return false;
        }
        execution.addChildWorkflows((WorkflowInstance[])StreamSupport.stream(data.spliterator(), false).map(this::createInstance).toArray(WorkflowInstance[]::new));
        return true;
    }

    private WorkflowInstance createInstance(JsonNode childData) {
        return new WorkflowInstance.Builder().setType("demo").setNextActivation(null).putStateVariable("requestData", childData.asText()).build();
    }

    @Override
    protected DateTime waitForChildrenUntil() {
        return DateTime.now().plusSeconds(10);
    }

    @Override
    protected DateTime waitForChildrenToCompleteUntil() {
        return DateTime.now().plusSeconds(10);
    }
}

