/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.tests.demo.workflow;

import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowSettings;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import org.joda.time.Period;
import org.springframework.stereotype.Component;

@Component
public class DeleteHistoryWorkflow
extends WorkflowDefinition<State> {
    public static final String TYPE = "deleteHistory";

    public DeleteHistoryWorkflow() {
        super(TYPE, State.begin, State.error, new WorkflowSettings.Builder().setHistoryDeletableAfter(Period.ZERO).setDeleteHistoryCondition(() -> true).build());
        this.setDescription("Delete history workflow");
        this.permit(State.begin, State.process);
        this.permit(State.process, State.done);
    }

    public NextAction begin(StateExecution execution) {
        WorkflowInstance childWorkflow = new WorkflowInstance.Builder().setType(TYPE).build();
        execution.addChildWorkflows(childWorkflow);
        execution.setVariable("notDeletedVariable", "value");
        return NextAction.moveToState(State.process, "Begin");
    }

    public NextAction process(StateExecution execution) {
        return NextAction.moveToState(State.done, "Process");
    }

    public void done(StateExecution execution) {
    }

    public static enum State implements WorkflowState
    {
        begin(WorkflowStateType.start),
        process(WorkflowStateType.normal),
        done(WorkflowStateType.end),
        error(WorkflowStateType.manual);

        private WorkflowStateType type;

        private State(WorkflowStateType type) {
            this.type = type;
        }

        @Override
        public WorkflowStateType getType() {
            return this.type;
        }
    }
}

