/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.tests.demo.workflow;

import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.StateVar;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;
import io.nflow.tests.demo.domain.CreditDecisionData;
import org.springframework.stereotype.Component;

@Component
public class CreditDecisionWorkflow
extends WorkflowDefinition<State> {
    public static final String TYPE = "creditDecision";
    public static final String VAR_REQUEST_DATA = "requestData";

    public CreditDecisionWorkflow() {
        super(TYPE, State.internalBlacklist, State.manualDecision);
        this.setDescription("Approve or reject credit application");
        this.permit(State.internalBlacklist, State.decisionEngine);
        this.permit(State.decisionEngine, State.satQuery);
        this.permit(State.satQuery, State.approved);
        this.permit(State.satQuery, State.rejected);
    }

    public NextAction internalBlacklist(StateExecution execution) {
        return NextAction.moveToState(State.decisionEngine, "Customer not blacklisted");
    }

    public NextAction decisionEngine(StateExecution execution) {
        return NextAction.moveToState(State.satQuery, "Decision engine approves");
    }

    public NextAction satQuery(StateExecution execution) {
        return NextAction.moveToState(State.manualDecision, "SAT query failed");
    }

    public void approved(StateExecution execution, @StateVar(value="requestData") CreditDecisionData requestData) {
        execution.wakeUpParentWorkflow(new String[0]);
    }

    public void rejected(StateExecution execution, @StateVar(value="requestData") CreditDecisionData requestData) {
        execution.wakeUpParentWorkflow(new String[0]);
    }

    public static enum State implements WorkflowState
    {
        internalBlacklist(WorkflowStateType.start, "Reject internally blacklisted customers"),
        decisionEngine(WorkflowStateType.normal, "Check if application ok for decision engine"),
        satQuery(WorkflowStateType.normal, "Query customer credit rating from SAT"),
        manualDecision(WorkflowStateType.manual, "Manually approve or reject the application"),
        approved(WorkflowStateType.end, "Credit Decision Approved"),
        rejected(WorkflowStateType.end, "Credit Decision Rejected");

        private WorkflowStateType type;
        private String description;

        private State(WorkflowStateType type, String description) {
            this.type = type;
            this.description = description;
        }

        @Override
        public WorkflowStateType getType() {
            return this.type;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

