/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.tests.demo.workflow;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.StateVar;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowSettings;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="jackson reads public fields")
public class CreditApplicationWorkflow
extends WorkflowDefinition<State> {
    private static final Logger logger = LoggerFactory.getLogger(CreditApplicationWorkflow.class);
    private static final String VAR_KEY = "info";

    public CreditApplicationWorkflow() {
        super("creditApplicationProcess", State.createCreditApplication, State.error, new WorkflowSettings.Builder().setMinErrorTransitionDelay(0).setMaxErrorTransitionDelay(0).setShortTransitionDelay(0).setMaxRetries(3).build());
        this.setDescription("Mock workflow that makes credit decision, creates loan, deposits the money and updates credit application");
        this.permit(State.createCreditApplication, State.acceptCreditApplication);
        this.permit(State.acceptCreditApplication, State.grantLoan);
        this.permit(State.acceptCreditApplication, State.finishCreditApplication);
        this.permit(State.finishCreditApplication, State.done);
    }

    public NextAction createCreditApplication(StateExecution execution, @StateVar(value="requestData", readOnly=true) CreditApplication request, @StateVar(instantiateIfNotExists=true, value="info") WorkflowInfo info) {
        logger.info("IRL: external service call for persisting credit application using request data");
        info.applicationId = "abc" + request.customerId;
        return NextAction.moveToState(State.acceptCreditApplication, "Credit application created");
    }

    public NextAction previewCreditApplication(StateExecution execution, @StateVar(value="requestData", readOnly=false) CreditApplication request, @StateVar(instantiateIfNotExists=true, value="info") WorkflowInfo info) {
        logger.info("IRL: external service call for persisting credit application using request data");
        info.applicationId = "abc" + request.customerId;
        request.simulation = true;
        return NextAction.moveToState(State.acceptCreditApplication, "Credit application previewed");
    }

    public void acceptCreditApplication(StateExecution execution, @StateVar(value="info") WorkflowInfo info) {
        System.err.println(execution.getVariable("diipa", Boolean.class));
        logger.info("IRL: descheduling workflow instance, next state set externally");
    }

    public NextAction grantLoan(StateExecution execution, @StateVar(value="requestData", readOnly=true) CreditApplication request, @StateVar(value="info") WorkflowInfo info) {
        logger.info("IRL: external service call for granting a loan");
        if (request.simulation) {
            logger.info("STUPID USER");
            return NextAction.moveToState(State.finishCreditApplication, "l\u00f6rl\u00e4b\u00e4");
        }
        throw new RuntimeException("Failed to create loan");
    }

    public NextAction finishCreditApplication(StateExecution execution, @StateVar(value="info") WorkflowInfo info) {
        logger.info("IRL: external service call for updating credit application status");
        return NextAction.moveToState(State.done, "Credit application finished");
    }

    public void done(StateExecution execution, @StateVar(value="info") WorkflowInfo info) {
        logger.info("Credit application process ended");
    }

    public void error(StateExecution execution, @StateVar(value="info") WorkflowInfo info) {
        logger.info("IRL: some UI should poll for workflows that have reached error state");
    }

    public static class WorkflowInfo {
        public String applicationId;
    }

    public static class CreditApplication {
        public String customerId;
        public BigDecimal amount;
        public boolean simulation = false;

        public CreditApplication() {
        }

        public CreditApplication(String customerId, BigDecimal amount) {
            this.customerId = customerId;
            this.amount = amount;
        }
    }

    public static enum State implements WorkflowState
    {
        createCreditApplication(WorkflowStateType.start, "Credit application is persisted to database"),
        previewCreditApplication(WorkflowStateType.start, "Check if credit application would be accepted (ie. simulate)"),
        acceptCreditApplication(WorkflowStateType.manual, "Manual credit decision is made"),
        grantLoan(WorkflowStateType.normal, "Loan is created to loan system"),
        finishCreditApplication(WorkflowStateType.normal, "Credit application status is set"),
        done(WorkflowStateType.end, "Credit application process finished"),
        error(WorkflowStateType.manual, "Manual processing of failed applications");

        private final WorkflowStateType type;
        private final String description;

        private State(WorkflowStateType type, String description) {
            this.type = type;
            this.description = description;
        }

        @Override
        public WorkflowStateType getType() {
            return this.type;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

