/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.tests.demo.workflow;

import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;
import org.springframework.stereotype.Component;

@Component
public class BusinessKeyWorkflow
extends WorkflowDefinition<State> {
    public static final String BUSINESS_KEY_WORKFLOW_TYPE = "businessKeyWorkflow";

    public BusinessKeyWorkflow() {
        super(BUSINESS_KEY_WORKFLOW_TYPE, State.begin, State.error);
        this.setDescription("Workflow that updates business key");
        this.permit(State.begin, State.process);
        this.permit(State.process, State.done);
    }

    public NextAction begin(StateExecution execution) {
        return NextAction.moveToState(State.process, "Go to process state");
    }

    public NextAction process(StateExecution execution) {
        execution.setBusinessKey("newBusinessKey");
        return NextAction.stopInState(State.done, "Go to done state");
    }

    public static enum State implements WorkflowState
    {
        begin(WorkflowStateType.start),
        process(WorkflowStateType.normal),
        done(WorkflowStateType.end),
        error(WorkflowStateType.manual);

        private WorkflowStateType type;

        private State(WorkflowStateType type) {
            this.type = type;
        }

        @Override
        public WorkflowStateType getType() {
            return this.type;
        }
    }
}

