/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.tests.demo.workflow;

import io.nflow.engine.workflow.definition.Mutable;
import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.StateVar;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowSettings;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;
import org.springframework.stereotype.Component;

@Component
public class ActionStateVariableWorkflow
extends WorkflowDefinition<State> {
    public static final String WORKFLOW_TYPE = "actionStateVariableWorkflow";
    public static final int MAX_STATE_VAR_VALUE = 10;
    private static final String STATE_VAR = "stateVar";

    public ActionStateVariableWorkflow() {
        super(WORKFLOW_TYPE, State.setVariable, State.error, new WorkflowSettings.Builder().setMinErrorTransitionDelay(0).setMaxErrorTransitionDelay(0).setShortTransitionDelay(0).setMaxRetries(3).build());
        this.setDescription("Workflow for testing action state variables");
        this.permit(State.setVariable, State.setVariable);
        this.permit(State.setVariable, State.done);
    }

    public NextAction setVariable(StateExecution execution, @StateVar(value="stateVar", instantiateIfNotExists=true) Mutable<Long> val) {
        if (val.getVal() >= 10L) {
            execution.setCreateAction(false);
            return NextAction.stopInState(State.done, "Done");
        }
        val.setVal(val.getVal() + 1L);
        return NextAction.moveToState(State.setVariable, "Continue");
    }

    public static enum State implements WorkflowState
    {
        setVariable(WorkflowStateType.start),
        done(WorkflowStateType.end),
        error(WorkflowStateType.manual);

        private final WorkflowStateType type;

        private State(WorkflowStateType type) {
            this.type = type;
        }

        @Override
        public WorkflowStateType getType() {
            return this.type;
        }
    }
}

